/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.azure;

import com.microsoft.azure.storage.blob.CloudBlobClient;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.hop.vfs.azure.AzureFileName;
import org.apache.hop.vfs.azure.AzureFileObject;
import org.apache.hop.vfs.azure.AzureFileProvider;

public class AzureFileSystem
extends AbstractFileSystem {
    private CloudBlobClient client;

    public AzureFileSystem(AzureFileName fileName, CloudBlobClient service, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super((FileName)fileName, null, fileSystemOptions);
        this.client = service;
    }

    protected void addCapabilities(Collection<Capability> capabilities) {
        capabilities.addAll(AzureFileProvider.capabilities);
    }

    protected FileObject createFile(AbstractFileName name) throws Exception {
        return new AzureFileObject(name, this, this.client);
    }
}

