/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapDifference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.cassandra.diag.DiagnosticEvent;
import org.apache.cassandra.schema.CachingParams;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.schema.CompressionParams;
import org.apache.cassandra.schema.Diff;
import org.apache.cassandra.schema.DroppedColumn;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.MemtableParams;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.schema.Tables;
import org.apache.cassandra.schema.TriggerMetadata;
import org.apache.cassandra.schema.Triggers;
import org.apache.cassandra.schema.Views;
import org.apache.cassandra.utils.Collectors3;

public final class SchemaEvent
extends DiagnosticEvent {
    private final SchemaEventType type;
    private final ImmutableCollection<String> keyspaces;
    private final ImmutableMap<String, String> indexTables;
    private final ImmutableCollection<String> tables;
    private final ImmutableCollection<String> nonSystemKeyspaces;
    private final ImmutableCollection<String> userKeyspaces;
    private final int numberOfTables;
    private final UUID version;
    @Nullable
    private final KeyspaceMetadata ksUpdate;
    @Nullable
    private final KeyspaceMetadata previous;
    @Nullable
    private final KeyspaceMetadata.KeyspaceDiff ksDiff;
    @Nullable
    private final TableMetadata tableUpdate;
    @Nullable
    private final Tables.TablesDiff tablesDiff;
    @Nullable
    private final Views.ViewsDiff viewsDiff;
    @Nullable
    private final MapDifference<String, TableMetadata> indexesDiff;

    SchemaEvent(SchemaEventType type, Schema schema, @Nullable KeyspaceMetadata ksUpdate, @Nullable KeyspaceMetadata previous, @Nullable KeyspaceMetadata.KeyspaceDiff ksDiff, @Nullable TableMetadata tableUpdate, @Nullable Tables.TablesDiff tablesDiff, @Nullable Views.ViewsDiff viewsDiff, @Nullable MapDifference<String, TableMetadata> indexesDiff) {
        this.type = type;
        this.ksUpdate = ksUpdate;
        this.previous = previous;
        this.ksDiff = ksDiff;
        this.tableUpdate = tableUpdate;
        this.tablesDiff = tablesDiff;
        this.viewsDiff = viewsDiff;
        this.indexesDiff = indexesDiff;
        this.keyspaces = schema.distributedAndLocalKeyspaces().names();
        this.nonSystemKeyspaces = schema.distributedKeyspaces().names();
        this.userKeyspaces = schema.getUserKeyspaces().names();
        this.numberOfTables = schema.getNumberOfTables();
        this.version = schema.getVersion();
        this.indexTables = schema.distributedKeyspaces().stream().flatMap(ks -> ks.tables.indexTables().entrySet().stream()).collect(Collectors3.toImmutableMap(e -> String.format("%s,%s", ((TableMetadata)e.getValue()).keyspace, e.getKey()), e -> String.format("%s,%s,%s", ((TableMetadata)e.getValue()).id.toHexString(), ((TableMetadata)e.getValue()).keyspace, ((TableMetadata)e.getValue()).name)));
        this.tables = (ImmutableCollection)schema.distributedKeyspaces().stream().flatMap(ks -> StreamSupport.stream(ks.tablesAndViews().spliterator(), false)).map(e -> String.format("%s,%s,%s", e.id.toHexString(), e.keyspace, e.name)).collect(Collectors3.toImmutableList());
    }

    public SchemaEventType getType() {
        return this.type;
    }

    @Override
    public Map<String, Serializable> toMap() {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        ret.put("keyspaces", (Serializable)this.keyspaces);
        ret.put("nonSystemKeyspaces", (Serializable)this.nonSystemKeyspaces);
        ret.put("userKeyspaces", (Serializable)this.userKeyspaces);
        ret.put("numberOfTables", Integer.valueOf(this.numberOfTables));
        ret.put("version", this.version);
        ret.put("tables", (Serializable)this.tables);
        ret.put("indexTables", (Serializable)this.indexTables);
        if (this.ksUpdate != null) {
            ret.put("ksMetadataUpdate", this.repr(this.ksUpdate));
        }
        if (this.previous != null) {
            ret.put("ksMetadataPrevious", this.repr(this.previous));
        }
        if (this.ksDiff != null) {
            HashMap<String, HashMap<String, Serializable>> ks = new HashMap<String, HashMap<String, Serializable>>();
            ks.put("before", this.repr(this.ksDiff.before));
            ks.put("after", this.repr(this.ksDiff.after));
            ks.put("tables", this.repr(this.ksDiff.tables));
            ks.put("views", this.repr(this.ksDiff.views));
            ks.put("types", this.repr(this.ksDiff.types));
            ks.put("udas", this.repr(this.ksDiff.udas));
            ks.put("udfs", this.repr(this.ksDiff.udfs));
            ret.put("ksDiff", ks);
        }
        if (this.tableUpdate != null) {
            ret.put("tableMetadataUpdate", this.repr(this.tableUpdate));
        }
        if (this.tablesDiff != null) {
            ret.put("tablesDiff", this.repr(this.tablesDiff));
        }
        if (this.viewsDiff != null) {
            ret.put("viewsDiff", this.repr(this.viewsDiff));
        }
        if (this.indexesDiff != null) {
            ret.put("indexesDiff", Lists.newArrayList(this.indexesDiff.entriesDiffering().keySet()));
        }
        return ret;
    }

    private HashMap<String, Serializable> repr(Diff<?, ?> diff) {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        if (diff.created != null) {
            ret.put("created", (Serializable)((Object)diff.created.toString()));
        }
        if (diff.dropped != null) {
            ret.put("dropped", (Serializable)((Object)diff.dropped.toString()));
        }
        if (diff.altered != null) {
            ret.put("created", Lists.newArrayList(diff.altered.stream().map(Diff.Altered::toString).iterator()));
        }
        return ret;
    }

    private HashMap<String, Serializable> repr(KeyspaceMetadata ksm) {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        ret.put("name", (Serializable)((Object)ksm.name));
        if (ksm.kind != null) {
            ret.put("kind", (Serializable)((Object)ksm.kind.name()));
        }
        if (ksm.params != null) {
            ret.put("params", (Serializable)((Object)ksm.params.toString()));
        }
        if (ksm.tables != null) {
            ret.put("tables", (Serializable)((Object)ksm.tables.toString()));
        }
        if (ksm.views != null) {
            ret.put("views", (Serializable)((Object)ksm.views.toString()));
        }
        if (ksm.functions != null) {
            ret.put("functions", (Serializable)((Object)ksm.functions.toString()));
        }
        if (ksm.types != null) {
            ret.put("types", (Serializable)((Object)ksm.types.toString()));
        }
        return ret;
    }

    private HashMap<String, Serializable> repr(TableMetadata table) {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        ret.put("id", (Serializable)((Object)table.id.toHexString()));
        ret.put("name", (Serializable)((Object)table.name));
        ret.put("keyspace", (Serializable)((Object)table.keyspace));
        ret.put("partitioner", (Serializable)((Object)table.partitioner.toString()));
        ret.put("kind", (Serializable)((Object)table.kind.name()));
        ret.put("flags", Lists.newArrayList(table.flags.stream().map(Enum::name).iterator()));
        ret.put("params", this.repr(table.params));
        ret.put("indexes", Lists.newArrayList(table.indexes.stream().map(this::repr).iterator()));
        ret.put("triggers", Lists.newArrayList(this.repr(table.triggers)));
        ret.put("columns", Lists.newArrayList(table.columns.values().stream().map(this::repr).iterator()));
        ret.put("droppedColumns", Lists.newArrayList(table.droppedColumns.values().stream().map(this::repr).iterator()));
        ret.put("isCompactTable", Boolean.valueOf(table.isCompactTable()));
        ret.put("isCompound", Boolean.valueOf(TableMetadata.Flag.isCompound(table.flags)));
        ret.put("isCounter", Boolean.valueOf(table.isCounter()));
        ret.put("isCQLTable", Boolean.valueOf(TableMetadata.Flag.isCQLTable(table.flags)));
        ret.put("isDense", Boolean.valueOf(TableMetadata.Flag.isDense(table.flags)));
        ret.put("isIndex", Boolean.valueOf(table.isIndex()));
        ret.put("isStaticCompactTable", Boolean.valueOf(TableMetadata.Flag.isStaticCompactTable(table.flags)));
        ret.put("isView", Boolean.valueOf(table.isView()));
        ret.put("isVirtual", Boolean.valueOf(table.isVirtual()));
        return ret;
    }

    private HashMap<String, Serializable> repr(TableParams params) {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        if (params == null) {
            return ret;
        }
        ret.put("minIndexInterval", Integer.valueOf(params.minIndexInterval));
        ret.put("maxIndexInterval", Integer.valueOf(params.maxIndexInterval));
        ret.put("defaultTimeToLive", Integer.valueOf(params.defaultTimeToLive));
        ret.put("gcGraceSeconds", Integer.valueOf(params.gcGraceSeconds));
        ret.put("bloomFilterFpChance", Double.valueOf(params.bloomFilterFpChance));
        ret.put("cdc", Boolean.valueOf(params.cdc));
        ret.put("crcCheckChance", Double.valueOf(params.crcCheckChance));
        ret.put("memtableFlushPeriodInMs", Integer.valueOf(params.memtableFlushPeriodInMs));
        ret.put("comment", (Serializable)((Object)params.comment));
        ret.put("caching", this.repr(params.caching));
        ret.put("compaction", this.repr(params.compaction));
        ret.put("compression", this.repr(params.compression));
        ret.put("memtable", (Serializable)((Object)this.repr(params.memtable)));
        if (params.speculativeRetry != null) {
            ret.put("speculativeRetry", (Serializable)((Object)params.speculativeRetry.kind().name()));
        }
        return ret;
    }

    private HashMap<String, Serializable> repr(CachingParams caching) {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        if (caching == null) {
            return ret;
        }
        ret.putAll(caching.asMap());
        return ret;
    }

    private HashMap<String, Serializable> repr(CompactionParams comp) {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        if (comp == null) {
            return ret;
        }
        ret.putAll(comp.asMap());
        return ret;
    }

    private HashMap<String, Serializable> repr(CompressionParams compr) {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        if (compr == null) {
            return ret;
        }
        ret.putAll(compr.asMap());
        return ret;
    }

    private String repr(MemtableParams params) {
        return params.configurationKey();
    }

    private HashMap<String, Serializable> repr(IndexMetadata index) {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        if (index == null) {
            return ret;
        }
        ret.put("name", (Serializable)((Object)index.name));
        ret.put("kind", (Serializable)((Object)index.kind.name()));
        ret.put("id", index.id);
        ret.put("options", new HashMap<String, String>(index.options));
        ret.put("isCustom", Boolean.valueOf(index.isCustom()));
        ret.put("isKeys", Boolean.valueOf(index.isKeys()));
        ret.put("isComposites", Boolean.valueOf(index.isComposites()));
        return ret;
    }

    private List<Map<String, Serializable>> repr(Triggers triggers) {
        ArrayList<Map<String, Serializable>> ret = new ArrayList<Map<String, Serializable>>();
        if (triggers == null) {
            return ret;
        }
        Iterator<TriggerMetadata> iter = triggers.iterator();
        while (iter.hasNext()) {
            ret.add(this.repr(iter.next()));
        }
        return ret;
    }

    private HashMap<String, Serializable> repr(TriggerMetadata trigger) {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        if (trigger == null) {
            return ret;
        }
        ret.put("name", (Serializable)((Object)trigger.name));
        ret.put("classOption", (Serializable)((Object)trigger.classOption));
        return ret;
    }

    private HashMap<String, Serializable> repr(ColumnMetadata col) {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        if (col == null) {
            return ret;
        }
        ret.put("name", (Serializable)((Object)col.name.toString()));
        ret.put("kind", (Serializable)((Object)col.kind.name()));
        ret.put("type", (Serializable)((Object)col.type.toString()));
        ret.put("ksName", (Serializable)((Object)col.ksName));
        ret.put("cfName", (Serializable)((Object)col.cfName));
        ret.put("position", Integer.valueOf(col.position()));
        ret.put("clusteringOrder", (Serializable)((Object)col.clusteringOrder().name()));
        ret.put("isComplex", Boolean.valueOf(col.isComplex()));
        ret.put("isStatic", Boolean.valueOf(col.isStatic()));
        ret.put("isPrimaryKeyColumn", Boolean.valueOf(col.isPrimaryKeyColumn()));
        ret.put("isSimple", Boolean.valueOf(col.isSimple()));
        ret.put("isPartitionKey", Boolean.valueOf(col.isPartitionKey()));
        ret.put("isClusteringColumn", Boolean.valueOf(col.isClusteringColumn()));
        ret.put("isCounterColumn", Boolean.valueOf(col.isCounterColumn()));
        ret.put("isRegular", Boolean.valueOf(col.isRegular()));
        return ret;
    }

    private HashMap<String, Serializable> repr(DroppedColumn column) {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        if (column == null) {
            return ret;
        }
        ret.put("droppedTime", Long.valueOf(column.droppedTime));
        ret.put("column", this.repr(column.column));
        return ret;
    }

    public static enum SchemaEventType {
        KS_METADATA_LOADED,
        KS_METADATA_RELOADED,
        KS_METADATA_REMOVED,
        VERSION_UPDATED,
        VERSION_ANOUNCED,
        KS_CREATING,
        KS_CREATED,
        KS_ALTERING,
        KS_ALTERED,
        KS_DROPPING,
        KS_DROPPED,
        TABLE_CREATING,
        TABLE_CREATED,
        TABLE_ALTERING,
        TABLE_ALTERED,
        TABLE_DROPPING,
        TABLE_DROPPED,
        SCHEMATA_LOADING,
        SCHEMATA_LOADED,
        SCHEMATA_CLEARED;

    }
}

