/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformStatus;
import org.apache.hop.server.HttpUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HopServerPipelineStatus {
    public static final String XML_TAG = "pipeline-status";
    private String id;
    private String pipelineName;
    private String statusDescription;
    private String errorDescription;
    private String loggingString;
    private int firstLoggingLineNr;
    private int lastLoggingLineNr;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    private Date logDate = new Date();
    private List<TransformStatus> transformStatusList = new ArrayList<TransformStatus>();
    private Result result;
    private boolean paused;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    private Date executionStartDate;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    private Date executionEndDate;

    public HopServerPipelineStatus() {
    }

    public HopServerPipelineStatus(String pipelineName, String id, String statusDescription) {
        this();
        this.pipelineName = pipelineName;
        this.id = id;
        this.statusDescription = statusDescription;
    }

    @JsonIgnore
    public String getXml() throws HopException {
        boolean sendResultXmlWithStatus = EnvUtil.getSystemProperty((String)"HOP_COMPATIBILITY_SEND_RESULT_XML_WITH_FULL_STATUS", (String)"N").equalsIgnoreCase("Y");
        return this.getXml(sendResultXmlWithStatus);
    }

    public String getXml(boolean sendResultXmlWithStatus) throws HopException {
        StringBuilder xml = new StringBuilder();
        xml.append(XmlHandler.openTag((String)XML_TAG)).append(Const.CR);
        xml.append("  ").append(XmlHandler.addTagValue((String)"pipeline_name", (String)this.pipelineName));
        xml.append("  ").append(XmlHandler.addTagValue((String)"id", (String)this.id));
        xml.append("  ").append(XmlHandler.addTagValue((String)"status_desc", (String)this.statusDescription));
        xml.append("  ").append(XmlHandler.addTagValue((String)"error_desc", (String)this.errorDescription));
        xml.append("  ").append(XmlHandler.addTagValue((String)"log_date", (String)XmlHandler.date2string((Date)this.logDate)));
        xml.append("  ").append(XmlHandler.addTagValue((String)"execution_start_date", (String)XmlHandler.date2string((Date)this.executionStartDate)));
        xml.append("  ").append(XmlHandler.addTagValue((String)"execution_end_date", (String)XmlHandler.date2string((Date)this.executionEndDate)));
        xml.append("  ").append(XmlHandler.addTagValue((String)"paused", (boolean)this.paused));
        xml.append("  ").append(XmlHandler.openTag((String)"transform_status_list")).append(Const.CR);
        for (int i = 0; i < this.transformStatusList.size(); ++i) {
            TransformStatus transformStatus = this.transformStatusList.get(i);
            xml.append("    ").append(transformStatus.getXml()).append(Const.CR);
        }
        xml.append("  ").append(XmlHandler.closeTag((String)"transform_status_list")).append(Const.CR);
        xml.append("  ").append(XmlHandler.addTagValue((String)"first_log_line_nr", (int)this.firstLoggingLineNr));
        xml.append("  ").append(XmlHandler.addTagValue((String)"last_log_line_nr", (int)this.lastLoggingLineNr));
        if (this.result != null) {
            String resultXML = sendResultXmlWithStatus ? this.result.getXml() : this.result.getBasicXml();
            xml.append(resultXML);
        }
        xml.append("  ").append(XmlHandler.addTagValue((String)"logging_string", (String)XmlHandler.buildCDATA((String)this.loggingString)));
        xml.append(XmlHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public HopServerPipelineStatus(Node pipelineStatusNode) throws HopException {
        this();
        Node resultNode;
        this.id = XmlHandler.getTagValue((Node)pipelineStatusNode, (String)"id");
        this.pipelineName = XmlHandler.getTagValue((Node)pipelineStatusNode, (String)"pipeline_name");
        this.statusDescription = XmlHandler.getTagValue((Node)pipelineStatusNode, (String)"status_desc");
        this.errorDescription = XmlHandler.getTagValue((Node)pipelineStatusNode, (String)"error_desc");
        this.logDate = XmlHandler.stringToDate((String)XmlHandler.getTagValue((Node)pipelineStatusNode, (String)"log_date"));
        this.executionStartDate = XmlHandler.stringToDate((String)XmlHandler.getTagValue((Node)pipelineStatusNode, (String)"execution_start_date"));
        this.executionEndDate = XmlHandler.stringToDate((String)XmlHandler.getTagValue((Node)pipelineStatusNode, (String)"execution_end_date"));
        this.paused = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)pipelineStatusNode, (String)"paused"));
        Node statusListNode = XmlHandler.getSubNode((Node)pipelineStatusNode, (String)"transform_status_list");
        int nr = XmlHandler.countNodes((Node)statusListNode, (String)"transform_status");
        for (int i = 0; i < nr; ++i) {
            Node transformStatusNode = XmlHandler.getSubNodeByNr((Node)statusListNode, (String)"transform_status", (int)i);
            TransformStatus transformStatus = new TransformStatus(transformStatusNode);
            this.transformStatusList.add(transformStatus);
        }
        this.firstLoggingLineNr = Const.toInt((String)XmlHandler.getTagValue((Node)pipelineStatusNode, (String)"first_log_line_nr"), (int)0);
        this.lastLoggingLineNr = Const.toInt((String)XmlHandler.getTagValue((Node)pipelineStatusNode, (String)"last_log_line_nr"), (int)0);
        String loggingString64 = XmlHandler.getTagValue((Node)pipelineStatusNode, (String)"logging_string");
        if (!Utils.isEmpty((CharSequence)loggingString64)) {
            String dataString64 = loggingString64.substring("<![CDATA[".length(), loggingString64.length() - "]]>".length());
            try {
                this.loggingString = HttpUtil.decodeBase64ZippedString((String)dataString64);
            }
            catch (IOException e) {
                this.loggingString = "Unable to decode logging from remote server : " + e.toString() + Const.CR + Const.getSimpleStackTrace((Throwable)e) + Const.CR + Const.getStackTracker((Throwable)e);
            }
        } else {
            this.loggingString = "";
        }
        if ((resultNode = XmlHandler.getSubNode((Node)pipelineStatusNode, (String)"result")) != null) {
            try {
                this.result = new Result(resultNode);
            }
            catch (HopException e) {
                this.loggingString = this.loggingString + "Unable to serialize result object as XML" + Const.CR + Const.getSimpleStackTrace((Throwable)e) + Const.CR + Const.getStackTracker((Throwable)e) + Const.CR;
            }
            this.result.setLogText(this.loggingString);
        }
    }

    public static HopServerPipelineStatus fromXml(String xml) throws HopException {
        Document document = XmlHandler.loadXmlString((String)xml);
        HopServerPipelineStatus status = new HopServerPipelineStatus(XmlHandler.getSubNode((Node)document, (String)XML_TAG));
        return status;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public void setPipelineName(String pipelineName) {
        this.pipelineName = pipelineName;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public List<TransformStatus> getTransformStatusList() {
        return this.transformStatusList;
    }

    public void setTransformStatusList(List<TransformStatus> transformStatusList) {
        this.transformStatusList = transformStatusList;
    }

    public String getLoggingString() {
        return this.loggingString;
    }

    public void setLoggingString(String loggingString) {
        this.loggingString = loggingString;
    }

    public boolean isRunning() {
        return this.getStatusDescription() != null && (this.getStatusDescription().equalsIgnoreCase("Running") || this.getStatusDescription().equalsIgnoreCase("Initializing") || this.getStatusDescription().equalsIgnoreCase("Paused"));
    }

    public boolean isStopped() {
        return this.getStatusDescription() != null && (this.getStatusDescription().equalsIgnoreCase("Stopped") || this.getStatusDescription().equalsIgnoreCase("Stopped (with errors)"));
    }

    public boolean isWaiting() {
        return this.getStatusDescription() != null && this.getStatusDescription().equalsIgnoreCase("Waiting");
    }

    public boolean isFinished() {
        return this.getStatusDescription() != null && (this.getStatusDescription().equalsIgnoreCase("Finished") || this.getStatusDescription().equalsIgnoreCase("Finished (with errors)"));
    }

    public long getNrTransformErrors() {
        long errors = 0L;
        for (int i = 0; i < this.transformStatusList.size(); ++i) {
            TransformStatus transformStatus = this.transformStatusList.get(i);
            errors += transformStatus.getErrors();
        }
        return errors;
    }

    public Result getResult(PipelineMeta pipelineMeta) {
        Result result = new Result();
        for (TransformStatus transformStatus : this.transformStatusList) {
            result.setNrErrors(result.getNrErrors() + transformStatus.getErrors() + (long)(result.isStopped() ? 1 : 0));
            result.setNrLinesRead(Math.max(result.getNrLinesRead(), transformStatus.getLinesRead()));
            result.setNrLinesWritten(Math.max(result.getNrLinesWritten(), transformStatus.getLinesWritten()));
            result.setNrLinesInput(Math.max(result.getNrLinesInput(), transformStatus.getLinesInput()));
            result.setNrLinesOutput(Math.max(result.getNrLinesOutput(), transformStatus.getLinesOutput()));
            result.setNrLinesUpdated(Math.max(result.getNrLinesUpdated(), transformStatus.getLinesUpdated()));
            result.setNrLinesRejected(Math.max(result.getNrLinesRejected(), transformStatus.getLinesRejected()));
            if (!transformStatus.isStopped()) continue;
            result.setStopped(true);
            result.setResult(false);
        }
        return result;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public int getLastLoggingLineNr() {
        return this.lastLoggingLineNr;
    }

    public void setLastLoggingLineNr(int lastLoggingLineNr) {
        this.lastLoggingLineNr = lastLoggingLineNr;
    }

    public int getFirstLoggingLineNr() {
        return this.firstLoggingLineNr;
    }

    public void setFirstLoggingLineNr(int firstLoggingLineNr) {
        this.firstLoggingLineNr = firstLoggingLineNr;
    }

    public Date getLogDate() {
        return this.logDate;
    }

    public void setLogDate(Date logDate) {
        this.logDate = logDate;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getExecutionStartDate() {
        return this.executionStartDate;
    }

    public void setExecutionStartDate(Date executionStartDate) {
        this.executionStartDate = executionStartDate;
    }

    public Date getExecutionEndDate() {
        return this.executionEndDate;
    }

    public void setExecutionEndDate(Date executionEndDate) {
        this.executionEndDate = executionEndDate;
    }
}

