/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.IFSDataStream;

class IFSOpenRep
extends IFSDataStream {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    private static final int FILE_HANDLE_OFFSET = 22;
    private static final int FILE_ID_OFFSET = 26;
    private static final int FILE_DATA_CCSID_OFFSET = 34;
    private static final int ACTION_TAKEN_OFFSET = 36;
    private static final int CREATE_DATE_OFFSET = 38;
    private static final int MODIFY_DATE_OFFSET = 46;
    private static final int ACCESS_DATE_OFFSET = 54;
    private static final int FILE_SIZE_OFFSET = 62;
    private static final int FIXED_ATTRS_OFFSET = 66;
    private static final int NEED_EXT_ATTRS_OFFSET = 70;
    private static final int NUM_EXT_ATTRS_OFFSET = 72;
    private static final int CHARS_EA_NAMES_OFFSET = 74;
    private static final int BYTES_EA_VALUES_OFFSET = 78;
    private static final int VERSION_OFFSET = 82;
    private static final int AMOUNT_ACCESSED_OFFSET = 86;
    private static final int ACCESS_HISTORY_OFFSET = 88;
    private static final int LARGE_FILE_SIZE_OFFSET = 89;

    IFSOpenRep() {
    }

    long getAccessDate() {
        return this.getDate(54);
    }

    long getCreationDate() {
        return this.getDate(38);
    }

    int getFileHandle() {
        return this.get32bit(22);
    }

    long getFileSize(int datastreamLevel) {
        if (datastreamLevel < 16) {
            int size = this.get32bit(62);
            return (long)size & 0xFFFFFFFFL;
        }
        return this.get64bit(89);
    }

    long getModificationDate() {
        return this.getDate(46);
    }

    @Override
    public Object getNewDataStream() {
        return new IFSOpenRep();
    }

    @Override
    public int hashCode() {
        return 32770;
    }
}

