/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.TaskInfo;
import org.apache.spark.util.Distribution;
import org.apache.spark.util.Distribution$;
import org.apache.spark.util.StatCounter;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class StatsReportListener$
implements Logging {
    public static StatsReportListener$ MODULE$;
    private final int[] percentiles;
    private final double[] probabilities;
    private final String percentilesHeader;
    private final long seconds;
    private final long minutes;
    private final long hours;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new StatsReportListener$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int[] percentiles() {
        return this.percentiles;
    }

    public double[] probabilities() {
        return this.probabilities;
    }

    public String percentilesHeader() {
        return this.percentilesHeader;
    }

    public Option<Distribution> extractDoubleDistribution(Seq<Tuple2<TaskInfo, TaskMetrics>> taskInfoMetrics, Function2<TaskInfo, TaskMetrics, Object> getMetric) {
        return Distribution$.MODULE$.apply((Iterable<Object>)((Iterable)taskInfoMetrics.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)StatsReportListener$.$anonfun$extractDoubleDistribution$1(getMetric, x0$1)), Seq$.MODULE$.canBuildFrom())));
    }

    public Option<Distribution> extractLongDistribution(Seq<Tuple2<TaskInfo, TaskMetrics>> taskInfoMetrics, Function2<TaskInfo, TaskMetrics, Object> getMetric) {
        return this.extractDoubleDistribution(taskInfoMetrics, (Function2<TaskInfo, TaskMetrics, Object>)(Function2 & Serializable & scala.Serializable)(info, metric) -> BoxesRunTime.boxToDouble((double)StatsReportListener$.$anonfun$extractLongDistribution$1(getMetric, info, metric)));
    }

    public void showDistribution(String heading, Distribution d, Function1<Object, String> formatNumber) {
        StatCounter stats = d.statCounter();
        IndexedSeq quantiles = (IndexedSeq)d.getQuantiles((Iterable<Object>)Predef$.MODULE$.wrapDoubleArray(this.probabilities())).map(formatNumber, IndexedSeq$.MODULE$.canBuildFrom());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(0).append(heading).append(stats).toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.percentilesHeader());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append("\t").append(quantiles.mkString("\t")).toString());
    }

    public void showDistribution(String heading, Option<Distribution> dOpt, Function1<Object, String> formatNumber) {
        dOpt.foreach((Function1 & Serializable & scala.Serializable)d -> {
            StatsReportListener$.MODULE$.showDistribution(heading, d, (Function1<Object, String>)formatNumber);
            return BoxedUnit.UNIT;
        });
    }

    public void showDistribution(String heading, Option<Distribution> dOpt, String format) {
        this.showDistribution(heading, dOpt, (Function1<Object, String>)(Function1 & Serializable & scala.Serializable)d -> StatsReportListener$.f$1(BoxesRunTime.unboxToDouble((Object)d), format));
    }

    public void showDistribution(String heading, String format, Function2<TaskInfo, TaskMetrics, Object> getMetric, Seq<Tuple2<TaskInfo, TaskMetrics>> taskInfoMetrics) {
        this.showDistribution(heading, this.extractDoubleDistribution(taskInfoMetrics, getMetric), format);
    }

    public void showBytesDistribution(String heading, Function2<TaskInfo, TaskMetrics, Object> getMetric, Seq<Tuple2<TaskInfo, TaskMetrics>> taskInfoMetrics) {
        this.showBytesDistribution(heading, this.extractLongDistribution(taskInfoMetrics, getMetric));
    }

    public void showBytesDistribution(String heading, Option<Distribution> dOpt) {
        dOpt.foreach((Function1 & Serializable & scala.Serializable)dist -> {
            StatsReportListener$.MODULE$.showBytesDistribution(heading, dist);
            return BoxedUnit.UNIT;
        });
    }

    public void showBytesDistribution(String heading, Distribution dist) {
        this.showDistribution(heading, dist, (Function1<Object, String>)(Function1 & Serializable & scala.Serializable)d -> Utils$.MODULE$.bytesToString((long)BoxesRunTime.unboxToDouble((Object)d)));
    }

    public void showMillisDistribution(String heading, Option<Distribution> dOpt) {
        this.showDistribution(heading, dOpt, (Function1<Object, String>)(Function1 & Serializable & scala.Serializable)d -> StatsReportListener$.MODULE$.millisToString((long)BoxesRunTime.unboxToDouble((Object)d)));
    }

    public void showMillisDistribution(String heading, Function2<TaskInfo, TaskMetrics, Object> getMetric, Seq<Tuple2<TaskInfo, TaskMetrics>> taskInfoMetrics) {
        this.showMillisDistribution(heading, this.extractLongDistribution(taskInfoMetrics, getMetric));
    }

    public long seconds() {
        return this.seconds;
    }

    public long minutes() {
        return this.minutes;
    }

    public long hours() {
        return this.hours;
    }

    public String millisToString(long ms) {
        Tuple2 tuple2;
        Tuple2 tuple22 = ms > this.hours() ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)((double)ms / (double)this.hours())), (Object)"hours") : (ms > this.minutes() ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)((double)ms / (double)this.minutes())), (Object)"min") : (tuple2 = ms > this.seconds() ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)((double)ms / (double)this.seconds())), (Object)"s") : new Tuple2((Object)BoxesRunTime.boxToDouble((double)ms), (Object)"ms")));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double size = tuple2._1$mcD$sp();
        String units = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)size), (Object)units);
        double size2 = tuple23._1$mcD$sp();
        String units2 = (String)tuple23._2();
        return new StringOps(Predef$.MODULE$.augmentString("%.1f %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)size2), units2}));
    }

    public static final /* synthetic */ double $anonfun$extractDoubleDistribution$1(Function2 getMetric$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TaskInfo info = (TaskInfo)tuple2._1();
            TaskMetrics metric = (TaskMetrics)tuple2._2();
            return BoxesRunTime.unboxToDouble((Object)getMetric$1.apply((Object)info, (Object)metric));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ double $anonfun$extractLongDistribution$1(Function2 getMetric$2, TaskInfo info, TaskMetrics metric) {
        return BoxesRunTime.unboxToLong((Object)getMetric$2.apply((Object)info, (Object)metric));
    }

    private static final String f$1(double d, String format$1) {
        return new StringOps(Predef$.MODULE$.augmentString(format$1)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)d)}));
    }

    private StatsReportListener$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.percentiles = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 5, 10, 25, 50, 75, 90, 95, 100}), ClassTag$.MODULE$.Int());
        this.probabilities = (double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.percentiles())).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$11 -> (double)x$11 / 100.0, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        this.percentilesHeader = new StringBuilder(2).append("\t").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.percentiles())).mkString("%\t")).append("%").toString();
        this.seconds = 1000L;
        this.minutes = this.seconds() * 60L;
        this.hours = this.minutes() * 60L;
    }
}

