/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.spark.SparkConf;
import org.apache.spark.api.python.Py4JServer;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.sys.package$;

public final class PythonGatewayServer$
implements Logging {
    public static PythonGatewayServer$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new PythonGatewayServer$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void main(String[] args) {
        SparkConf sparkConf = new SparkConf();
        Py4JServer gatewayServer = new Py4JServer(sparkConf);
        gatewayServer.start();
        int boundPort = gatewayServer.getListeningPort();
        if (boundPort == -1) {
            this.logError((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(24).append(gatewayServer.server().getClass()).append(" failed to bind; exiting").toString());
            System.exit(1);
        } else {
            InetAddress address = InetAddress.getLoopbackAddress();
            this.logDebug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(42).append("Started PythonGatewayServer on ").append(address).append(" with port ").append(boundPort).toString());
        }
        File connectionInfoPath = new File((String)package$.MODULE$.env().apply((Object)"_PYSPARK_DRIVER_CONN_INFO_PATH"));
        File tmpPath = Files.createTempFile(connectionInfoPath.getParentFile().toPath(), "connection", ".info", new FileAttribute[0]).toFile();
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(tmpPath));
        dos.writeInt(boundPort);
        byte[] secretBytes = gatewayServer.secret().getBytes(StandardCharsets.UTF_8);
        dos.writeInt(secretBytes.length);
        dos.write(secretBytes, 0, secretBytes.length);
        dos.close();
        if (!tmpPath.renameTo(connectionInfoPath)) {
            this.logError((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(43).append("Unable to write connection information to ").append(connectionInfoPath).append(".").toString());
            System.exit(1);
        }
        while (System.in.read() != -1) {
        }
        this.logDebug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Exiting due to broken pipe from Python driver");
        System.exit(0);
    }

    private PythonGatewayServer$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.initializeLogIfNecessary(true);
    }
}

