/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.range;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.transforms.splittabledofn.ByteKeyRangeTracker;
import org.apache.beam.sdk.transforms.splittabledofn.HasDefaultTracker;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Verify;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ByteKeyRange
implements Serializable,
HasDefaultTracker<ByteKeyRange, ByteKeyRangeTracker> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ByteKeyRange.class);
    public static final @UnknownKeyFor @NonNull @Initialized ByteKeyRange ALL_KEYS = ByteKeyRange.of(ByteKey.EMPTY, ByteKey.EMPTY);
    private final @UnknownKeyFor @NonNull @Initialized ByteKey startKey;
    private final @UnknownKeyFor @NonNull @Initialized ByteKey endKey;

    public static @UnknownKeyFor @NonNull @Initialized ByteKeyRange of(@UnknownKeyFor @NonNull @Initialized ByteKey startKey, @UnknownKeyFor @NonNull @Initialized ByteKey endKey) {
        return new ByteKeyRange(startKey, endKey);
    }

    public @UnknownKeyFor @NonNull @Initialized ByteKey getStartKey() {
        return this.startKey;
    }

    public @UnknownKeyFor @NonNull @Initialized ByteKey getEndKey() {
        return this.endKey;
    }

    public @UnknownKeyFor @NonNull @Initialized Boolean containsKey(@UnknownKeyFor @NonNull @Initialized ByteKey key) {
        return key.compareTo(this.startKey) >= 0 && this.endsAfterKey(key);
    }

    public @UnknownKeyFor @NonNull @Initialized Boolean overlaps(@UnknownKeyFor @NonNull @Initialized ByteKeyRange other) {
        return this.endsAfterKey(other.startKey) && other.endsAfterKey(this.startKey);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteKey> split(@UnknownKeyFor @NonNull @Initialized int numSplits) {
        Preconditions.checkArgument((numSplits > 0 ? 1 : 0) != 0, (String)"numSplits %s must be a positive integer", (int)numSplits);
        try {
            ImmutableList.Builder ret = ImmutableList.builder();
            ret.add((Object)this.startKey);
            for (int i = 1; i < numSplits; ++i) {
                ret.add((Object)this.interpolateKey((double)i / (double)numSplits));
            }
            ret.add((Object)this.endKey);
            return ret.build();
        }
        catch (IllegalStateException e) {
            return ImmutableList.of((Object)this.startKey, (Object)this.endKey);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized double estimateFractionForKey(@UnknownKeyFor @NonNull @Initialized ByteKey key) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0, (Object)"Cannot compute fraction for an empty key");
        Preconditions.checkArgument((key.compareTo(this.startKey) >= 0 ? 1 : 0) != 0, (String)"Expected key %s >= range start key %s", (Object)key, (Object)this.startKey);
        if (key.equals(this.endKey)) {
            return 1.0;
        }
        Preconditions.checkArgument((boolean)this.containsKey(key), (String)"Cannot compute fraction for %s outside this %s", (Object)key, (Object)this);
        byte[] startBytes = this.startKey.getBytes();
        byte[] endBytes = this.endKey.getBytes();
        byte[] keyBytes = key.getBytes();
        if (this.endKey.isEmpty()) {
            startBytes = ByteKeyRange.addHeadByte(startBytes, (byte)0);
            endBytes = ByteKeyRange.addHeadByte(endBytes, (byte)1);
            keyBytes = ByteKeyRange.addHeadByte(keyBytes, (byte)0);
        }
        int paddedKeyLength = Math.max(Math.max(startBytes.length, endBytes.length), keyBytes.length);
        BigInteger rangeStartInt = ByteKeyRange.paddedPositiveInt(startBytes, paddedKeyLength);
        BigInteger rangeEndInt = ByteKeyRange.paddedPositiveInt(endBytes, paddedKeyLength);
        BigInteger keyInt = ByteKeyRange.paddedPositiveInt(keyBytes, paddedKeyLength);
        BigInteger range = rangeEndInt.subtract(rangeStartInt);
        if (range.equals(BigInteger.ZERO)) {
            LOG.warn("Using 0.0 as the default fraction for this near-empty range {} where start and end keys differ only by trailing zeros.", (Object)this);
            return 0.0;
        }
        BigInteger progressScaled = keyInt.subtract(rangeStartInt).shiftLeft(64);
        return progressScaled.divide(range).doubleValue() / Math.pow(2.0, 64.0);
    }

    public @UnknownKeyFor @NonNull @Initialized ByteKey interpolateKey(@UnknownKeyFor @NonNull @Initialized double fraction) {
        Preconditions.checkArgument((fraction >= 0.0 && fraction < 1.0 ? 1 : 0) != 0, (String)"Fraction %s must be in the range [0, 1)", (Object)fraction);
        byte[] startBytes = this.startKey.getBytes();
        byte[] endBytes = this.endKey.getBytes();
        if (this.endKey.isEmpty()) {
            startBytes = ByteKeyRange.addHeadByte(startBytes, (byte)0);
            endBytes = ByteKeyRange.addHeadByte(endBytes, (byte)1);
        }
        int paddedKeyLength = Math.max(startBytes.length, endBytes.length);
        BigInteger rangeStartInt = ByteKeyRange.paddedPositiveInt(startBytes, paddedKeyLength);
        BigInteger rangeEndInt = ByteKeyRange.paddedPositiveInt(endBytes, paddedKeyLength);
        BigInteger range = rangeEndInt.subtract(rangeStartInt);
        Preconditions.checkState((!range.equals(BigInteger.ZERO) ? 1 : 0) != 0, (String)"Refusing to interpolate for near-empty %s where start and end keys differ only by trailing zero bytes.", (Object)this);
        int bytesNeeded = (53 - range.bitLength() + 7) / 8;
        if (bytesNeeded > 0) {
            range = range.shiftLeft(bytesNeeded * 8);
            rangeStartInt = rangeStartInt.shiftLeft(bytesNeeded * 8);
            paddedKeyLength += bytesNeeded;
        }
        BigInteger interpolatedOffset = new BigDecimal(range).multiply(BigDecimal.valueOf(fraction)).toBigInteger();
        int outputKeyLength = this.endKey.isEmpty() ? paddedKeyLength - 1 : paddedKeyLength;
        return ByteKey.copyFrom(ByteKeyRange.fixupHeadZeros(rangeStartInt.add(interpolatedOffset).toByteArray(), outputKeyLength));
    }

    public @UnknownKeyFor @NonNull @Initialized ByteKeyRange withStartKey(@UnknownKeyFor @NonNull @Initialized ByteKey startKey) {
        return new ByteKeyRange(startKey, this.endKey);
    }

    public @UnknownKeyFor @NonNull @Initialized ByteKeyRange withEndKey(@UnknownKeyFor @NonNull @Initialized ByteKey endKey) {
        return new ByteKeyRange(this.startKey, endKey);
    }

    private ByteKeyRange(@UnknownKeyFor @NonNull @Initialized ByteKey startKey, @UnknownKeyFor @NonNull @Initialized ByteKey endKey) {
        this.startKey = (ByteKey)Preconditions.checkNotNull((Object)startKey, (Object)"startKey");
        this.endKey = (ByteKey)Preconditions.checkNotNull((Object)endKey, (Object)"endKey");
        Preconditions.checkArgument((endKey.isEmpty() || startKey.compareTo(endKey) <= 0 ? 1 : 0) != 0, (String)"Start %s must be less than or equal to end %s", (Object)startKey, (Object)endKey);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper(ByteKeyRange.class).add("startKey", (Object)this.startKey).add("endKey", (Object)this.endKey).toString();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteKeyRange)) {
            return false;
        }
        ByteKeyRange other = (ByteKeyRange)o;
        return Objects.equals(this.startKey, other.startKey) && Objects.equals(this.endKey, other.endKey);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.startKey, this.endKey);
    }

    private static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] addHeadByte(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] array, @UnknownKeyFor @NonNull @Initialized byte b) {
        byte[] ret = new byte[array.length + 1];
        ret[0] = b;
        System.arraycopy(array, 0, ret, 1, array.length);
        return ret;
    }

    private static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] fixupHeadZeros(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] array, @UnknownKeyFor @NonNull @Initialized int size) {
        int padding = size - array.length;
        if (padding == 0) {
            return array;
        }
        if (padding < 0) {
            Verify.verify((padding == -1 ? 1 : 0) != 0, (String)"key %s: expected length %s with exactly one byte of padding, found %s", (Object)ByteKey.copyFrom(array), (Object)size, (Object)(-padding));
            Verify.verify((array[0] == 0 && (array[1] & 0x80) == 128 ? 1 : 0) != 0, (String)"key %s: is 1 byte longer than expected, indicating BigInteger padding. Expect first byte to be zero with set MSB in second byte.", (Object)ByteKey.copyFrom(array));
            return Arrays.copyOfRange(array, 1, array.length);
        }
        byte[] ret = new byte[size];
        System.arraycopy(array, 0, ret, padding, array.length);
        return ret;
    }

    @UnknownKeyFor @NonNull @Initialized boolean endsAfterKey(@UnknownKeyFor @NonNull @Initialized ByteKey key) {
        return this.endKey.isEmpty() || key.compareTo(this.endKey) < 0;
    }

    private static @UnknownKeyFor @NonNull @Initialized BigInteger paddedPositiveInt(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes, @UnknownKeyFor @NonNull @Initialized int length) {
        int bytePaddingNeeded = length - bytes.length;
        Preconditions.checkArgument((bytePaddingNeeded >= 0 ? 1 : 0) != 0, (String)"Required bytes.length %s < length %s", (int)bytes.length, (int)length);
        BigInteger ret = new BigInteger(1, bytes);
        return bytePaddingNeeded == 0 ? ret : ret.shiftLeft(8 * bytePaddingNeeded);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ByteKeyRangeTracker newTracker() {
        return ByteKeyRangeTracker.of(this);
    }
}

