/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.Trace;
import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.Data;
import com.ibm.as400.util.commtrace.Dec;
import com.ibm.as400.util.commtrace.Field;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.Formatter;
import com.ibm.as400.util.commtrace.Header;
import com.ibm.as400.util.commtrace.Hex;
import com.ibm.as400.util.commtrace.Message;

public class ICMP6Header
extends Header {
    Field typeh;
    Field code;
    Field checksum;
    private static final String CLASS = "ICMP6Header";
    private static final String ICMPV6 = "ICMPv6";
    private static final String DATA = "Data";
    private static final String TYPE = "Type";
    private static final String CODE = "Code";
    private static final String CHKSUM = "Checksum";
    private static final String MSG = "Message";

    ICMP6Header(BitBuf bitBuf) {
        super(bitBuf);
        this.typeh = new Hex(this.rawheader.slice(0, 8));
        this.code = new Hex(this.rawheader.slice(8, 8));
        this.checksum = new Hex(this.rawheader.slice(16, 16));
        this.type = 58;
    }

    public int getHeaderLen() {
        return 32;
    }

    public Header getNextHeader() {
        return Message.createMessage(this.rawheader.slice(0, 8).toByte(), this.rawpayload);
    }

    public String toString(FormatProperties formatProperties) {
        if (this.rawheader.getBitSize() < this.getHeaderLen()) {
            return new Data(this.rawheader).toString();
        }
        if (formatProperties != null) {
            boolean bl = false;
            String string = formatProperties.getPort();
            if (string == null) {
                bl = true;
            }
            if (!bl) {
                if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                    Trace.log(3, "ICMP6Header.toString() Frame doesn't pass IP filter");
                }
                return "";
            }
        }
        Object[] objectArray = new Object[]{this.typeh, this.code, this.checksum, this.next.getName().substring(this.next.getName().lastIndexOf(36) + 1)};
        return Formatter.jsprintf("\t    ICMPv6 Data . : Type: {0} Code: {1} Checksum : {2}\n" + this.printHexHeader() + "\t    " + ICMPV6 + " {3} " + MSG + " :  ", objectArray) + this.printnext(formatProperties);
    }

    public String getTypeField() {
        return new Dec(this.typeh.getData()).toString();
    }

    public String getCode() {
        return new Dec(this.code.getData()).toString();
    }

    public String getChecksum() {
        return new Dec(this.checksum.getData()).toString();
    }
}

