/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;

class PxEventSupport {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private Hashtable idToListeners_ = new Hashtable();

    PxEventSupport() {
    }

    public boolean addListener(long l, EventListener eventListener) {
        boolean bl = true;
        Object object = PxEventSupport.toKey(l);
        if (this.idToListeners_.containsKey(object)) {
            Vector vector = (Vector)this.idToListeners_.get(object);
            Class<?> clazz = eventListener.getClass();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements() && bl) {
                if (!enumeration.nextElement().getClass().equals(clazz)) continue;
                bl = false;
            }
            vector.addElement(eventListener);
        } else {
            Vector<EventListener> vector = new Vector<EventListener>();
            vector.addElement(eventListener);
            this.idToListeners_.put(object, vector);
        }
        return bl;
    }

    public void fireEvent(long l, String string, String string2, EventObject eventObject) throws InvocationTargetException {
        Object object = PxEventSupport.toKey(l);
        if (this.idToListeners_.containsKey(object)) {
            Vector vector = (Vector)this.idToListeners_.get(object);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                try {
                    Class<?> clazz = Class.forName(string);
                    Method method = clazz.getMethod(string2, eventObject.getClass());
                    method.invoke(e, eventObject);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (Trace.isTraceErrorOn()) {
                        Trace.log(2, "ClassNotFoundException while firing event", (Throwable)classNotFoundException);
                    }
                    throw new ExtendedIllegalStateException(10);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (Trace.isTraceErrorOn()) {
                        Trace.log(2, "NoSuchMethodException while firing event", (Throwable)noSuchMethodException);
                    }
                    throw new ExtendedIllegalStateException(10);
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (Trace.isTraceErrorOn()) {
                        Trace.log(2, "IllegalAccessException while firing event", (Throwable)illegalAccessException);
                    }
                    throw new ExtendedIllegalStateException(10);
                }
            }
        }
    }

    public void removeAll(long l) {
        Object object = PxEventSupport.toKey(l);
        if (this.idToListeners_.containsKey(object)) {
            Vector vector = (Vector)this.idToListeners_.get(object);
            vector.removeAllElements();
            this.idToListeners_.remove(object);
        }
    }

    public boolean removeListener(long l, EventListener eventListener) {
        boolean bl = true;
        Object object = PxEventSupport.toKey(l);
        if (this.idToListeners_.containsKey(object)) {
            Vector vector = (Vector)this.idToListeners_.get(object);
            vector.removeElement(eventListener);
            Class<?> clazz = eventListener.getClass();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements() && bl) {
                if (!enumeration.nextElement().getClass().equals(clazz)) continue;
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private static Object toKey(long l) {
        return new Long(l);
    }
}

