/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hive.jdbc.HiveBaseResultSet;

public abstract class HiveMetaDataResultSet<M>
extends HiveBaseResultSet {
    protected List<M> data = Collections.emptyList();

    public HiveMetaDataResultSet(List<String> columnNames, List<String> columnTypes, List<M> data) throws SQLException {
        if (data != null) {
            this.data = new ArrayList<M>(data);
        }
        this.columnTypes = columnTypes != null ? new ArrayList<String>(columnTypes) : Collections.emptyList();
        if (columnNames != null) {
            this.columnNames = new ArrayList<String>(columnNames);
            this.normalizedColumnNames = this.normalizeColumnNames(columnNames);
        } else {
            this.columnNames = Collections.emptyList();
            this.normalizedColumnNames = Collections.emptyList();
        }
    }

    private List<String> normalizeColumnNames(List<String> columnNames) {
        ArrayList<String> result = new ArrayList<String>(columnNames.size());
        for (String colName : columnNames) {
            result.add(colName.toLowerCase());
        }
        return result;
    }

    @Override
    public void close() throws SQLException {
    }
}

