/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.cipher;

import com.trilead.ssh2.crypto.cipher.BlockCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class AES
implements BlockCipher {
    private final int AES_BLOCK_SIZE = 16;
    protected Cipher cipher;

    @Override
    public void init(boolean forEncryption, byte[] key, byte[] iv) {
        try {
            this.cipher.init(forEncryption ? 1 : 2, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new IllegalArgumentException("Cannot initialize " + this.cipher.getAlgorithm(), e);
        }
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public void transformBlock(byte[] src, int srcoff, byte[] dst, int dstoff) {
        try {
            this.cipher.update(src, srcoff, 16, dst, dstoff);
        }
        catch (ShortBufferException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static class CTR
    extends AES {
        public CTR() throws IllegalArgumentException {
            try {
                this.cipher = Cipher.getInstance("AES/CTR/NoPadding");
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new IllegalArgumentException("Cannot initialize AES/CBC/NoPadding", e);
            }
        }
    }

    public static class CBC
    extends AES {
        public CBC() throws IllegalArgumentException {
            try {
                this.cipher = Cipher.getInstance("AES/CBC/NoPadding");
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new IllegalArgumentException("Cannot initialize AES/CBC/NoPadding", e);
            }
        }
    }
}

