/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.java;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaContainerBlockDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaLexer;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaLocalDeclarationDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaParser;
import org.drools.core.base.EvaluatorWrapper;
import org.drools.mvel.java.JavaAnalysisResult;

public class JavaExprAnalyzer {
    public JavaAnalysisResult analyzeExpression(String expr, BoundIdentifiers availableIdentifiers) throws RecognitionException {
        JavaParser parser = this.parse(expr);
        parser.conditionalOrExpression();
        JavaAnalysisResult result = new JavaAnalysisResult(expr, parser.getIdentifiers());
        return this.analyze(result, availableIdentifiers);
    }

    public JavaAnalysisResult analyzeBlock(String expr, BoundIdentifiers availableIdentifiers) throws RecognitionException {
        JavaParser parser = this.parse("{" + expr + "}");
        parser.block();
        JavaAnalysisResult result = new JavaAnalysisResult(expr, parser.getIdentifiers());
        if (parser.getRootBlockDescr().getInScopeLocalVars() != null) {
            for (JavaLocalDeclarationDescr descr : parser.getRootBlockDescr().getInScopeLocalVars()) {
                for (JavaLocalDeclarationDescr.IdentifierDescr ident : descr.getIdentifiers()) {
                    result.addLocalVariable(ident.getIdentifier(), descr);
                }
            }
        }
        result.setBlockDescrs((JavaContainerBlockDescr)parser.getRootBlockDescr());
        result.setAssignedVariables(parser.getAssignedVariables());
        return this.analyze(result, availableIdentifiers);
    }

    private JavaParser parse(String expr) {
        ANTLRStringStream charStream = new ANTLRStringStream(expr);
        JavaLexer lexer = new JavaLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        return new JavaParser((TokenStream)tokenStream);
    }

    private JavaAnalysisResult analyze(JavaAnalysisResult result, BoundIdentifiers availableIdentifiers) {
        Set<String> identifiers = result.getIdentifiers();
        HashSet<String> notBound = new HashSet<String>(identifiers);
        HashMap<String, Class> usedDecls = new HashMap<String, Class>();
        HashMap<String, Class> usedGlobals = new HashMap<String, Class>();
        HashMap<String, EvaluatorWrapper> usedOperators = new HashMap<String, EvaluatorWrapper>();
        for (Map.Entry entry : availableIdentifiers.getDeclrClasses().entrySet()) {
            if (!identifiers.contains(entry.getKey())) continue;
            usedDecls.put((String)entry.getKey(), (Class)entry.getValue());
            notBound.remove(entry.getKey());
        }
        for (String string : identifiers) {
            Class type = availableIdentifiers.resolveVarType(string);
            if (type == null) continue;
            usedGlobals.put(string, type);
            notBound.remove(string);
        }
        for (Map.Entry entry : availableIdentifiers.getOperators().entrySet()) {
            if (!identifiers.contains(entry.getKey())) continue;
            usedOperators.put((String)entry.getKey(), (EvaluatorWrapper)entry.getValue());
            notBound.remove(entry.getKey());
        }
        BoundIdentifiers boundIdentifiers = new BoundIdentifiers(usedDecls, availableIdentifiers.getContext(), usedOperators, availableIdentifiers.getThisClass());
        boundIdentifiers.setGlobals(usedGlobals);
        result.setBoundIdentifiers(boundIdentifiers);
        result.setNotBoundedIdentifiers(notBound);
        return result;
    }
}

