/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinatorDeActivator;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureManager;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointPlan;
import org.apache.flink.runtime.checkpoint.CheckpointPlanCalculator;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRequestDecider;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.checkpoint.Checkpoints;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.ExecutionAttemptMappingProvider;
import org.apache.flink.runtime.checkpoint.FinishedTaskStateProvider;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.MasterTriggerRestoreHook;
import org.apache.flink.runtime.checkpoint.OperatorCoordinatorCheckpointContext;
import org.apache.flink.runtime.checkpoint.OperatorCoordinatorCheckpoints;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.PendingCheckpoint;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.apache.flink.runtime.checkpoint.RestoredCheckpointStats;
import org.apache.flink.runtime.checkpoint.SnapshotType;
import org.apache.flink.runtime.checkpoint.StateAssignmentOperation;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.checkpoint.VertexFinishedStateChecker;
import org.apache.flink.runtime.checkpoint.hooks.MasterHooks;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.checkpoint.AcknowledgeCheckpoint;
import org.apache.flink.runtime.messages.checkpoint.DeclineCheckpoint;
import org.apache.flink.runtime.operators.coordination.OperatorInfo;
import org.apache.flink.runtime.persistence.PossibleInconsistentStateException;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.CheckpointStorageCoordinatorView;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointCoordinator {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointCoordinator.class);
    private static final int NUM_GHOST_CHECKPOINT_IDS = 16;
    private final Object lock = new Object();
    private final JobID job;
    private final CheckpointProperties checkpointProperties;
    private final Executor executor;
    private final CheckpointsCleaner checkpointsCleaner;
    private final Collection<OperatorCoordinatorCheckpointContext> coordinatorsToCheckpoint;
    @GuardedBy(value="lock")
    private final Map<Long, PendingCheckpoint> pendingCheckpoints;
    private final CompletedCheckpointStore completedCheckpointStore;
    private final CheckpointStorageCoordinatorView checkpointStorageView;
    private final ArrayDeque<Long> recentPendingCheckpoints;
    private final CheckpointIDCounter checkpointIdCounter;
    private final long baseInterval;
    private final long checkpointTimeout;
    private final long minPauseBetweenCheckpoints;
    private final ScheduledExecutor timer;
    private final HashMap<String, MasterTriggerRestoreHook<?>> masterHooks;
    private final boolean unalignedCheckpointsEnabled;
    private final long alignedCheckpointTimeout;
    private JobStatusListener jobStatusListener;
    private ScheduledFuture<?> currentPeriodicTrigger;
    private long lastCheckpointCompletionRelativeTime;
    private boolean periodicScheduling;
    private volatile boolean shutdown;
    private final CheckpointStatsTracker statsTracker;
    private final BiFunction<Set<ExecutionJobVertex>, Map<OperatorID, OperatorState>, VertexFinishedStateChecker> vertexFinishedStateCheckerFactory;
    private final long checkpointIdOfIgnoredInFlightData;
    private final CheckpointFailureManager failureManager;
    private final Clock clock;
    private final boolean isExactlyOnceMode;
    private boolean isTriggering = false;
    private final CheckpointRequestDecider requestDecider;
    private final CheckpointPlanCalculator checkpointPlanCalculator;
    private final ExecutionAttemptMappingProvider attemptMappingProvider;
    private boolean baseLocationsForCheckpointInitialized = false;
    private boolean forceFullSnapshot;

    public CheckpointCoordinator(JobID job, CheckpointCoordinatorConfiguration chkConfig, Collection<OperatorCoordinatorCheckpointContext> coordinatorsToCheckpoint, CheckpointIDCounter checkpointIDCounter, CompletedCheckpointStore completedCheckpointStore, CheckpointStorage checkpointStorage, Executor executor, CheckpointsCleaner checkpointsCleaner, ScheduledExecutor timer, CheckpointFailureManager failureManager, CheckpointPlanCalculator checkpointPlanCalculator, ExecutionAttemptMappingProvider attemptMappingProvider, CheckpointStatsTracker statsTracker) {
        this(job, chkConfig, coordinatorsToCheckpoint, checkpointIDCounter, completedCheckpointStore, checkpointStorage, executor, checkpointsCleaner, timer, failureManager, checkpointPlanCalculator, attemptMappingProvider, (Clock)SystemClock.getInstance(), statsTracker, VertexFinishedStateChecker::new);
    }

    @VisibleForTesting
    public CheckpointCoordinator(JobID job, CheckpointCoordinatorConfiguration chkConfig, Collection<OperatorCoordinatorCheckpointContext> coordinatorsToCheckpoint, CheckpointIDCounter checkpointIDCounter, CompletedCheckpointStore completedCheckpointStore, CheckpointStorage checkpointStorage, Executor executor, CheckpointsCleaner checkpointsCleaner, ScheduledExecutor timer, CheckpointFailureManager failureManager, CheckpointPlanCalculator checkpointPlanCalculator, ExecutionAttemptMappingProvider attemptMappingProvider, Clock clock, CheckpointStatsTracker statsTracker, BiFunction<Set<ExecutionJobVertex>, Map<OperatorID, OperatorState>, VertexFinishedStateChecker> vertexFinishedStateCheckerFactory) {
        long baseInterval;
        Preconditions.checkNotNull((Object)checkpointStorage);
        long minPauseBetweenCheckpoints = chkConfig.getMinPauseBetweenCheckpoints();
        if (minPauseBetweenCheckpoints > 31536000000L) {
            minPauseBetweenCheckpoints = 31536000000L;
        }
        if ((baseInterval = chkConfig.getCheckpointInterval()) < minPauseBetweenCheckpoints) {
            baseInterval = minPauseBetweenCheckpoints;
        }
        this.job = (JobID)Preconditions.checkNotNull((Object)job);
        this.baseInterval = baseInterval;
        this.checkpointTimeout = chkConfig.getCheckpointTimeout();
        this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
        this.coordinatorsToCheckpoint = Collections.unmodifiableCollection(coordinatorsToCheckpoint);
        this.pendingCheckpoints = new LinkedHashMap<Long, PendingCheckpoint>();
        this.checkpointIdCounter = (CheckpointIDCounter)Preconditions.checkNotNull((Object)checkpointIDCounter);
        this.completedCheckpointStore = (CompletedCheckpointStore)Preconditions.checkNotNull((Object)completedCheckpointStore);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.checkpointsCleaner = (CheckpointsCleaner)Preconditions.checkNotNull((Object)checkpointsCleaner);
        this.failureManager = (CheckpointFailureManager)Preconditions.checkNotNull((Object)failureManager);
        this.checkpointPlanCalculator = (CheckpointPlanCalculator)Preconditions.checkNotNull((Object)checkpointPlanCalculator);
        this.attemptMappingProvider = (ExecutionAttemptMappingProvider)Preconditions.checkNotNull((Object)attemptMappingProvider);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.isExactlyOnceMode = chkConfig.isExactlyOnce();
        this.unalignedCheckpointsEnabled = chkConfig.isUnalignedCheckpointsEnabled();
        this.alignedCheckpointTimeout = chkConfig.getAlignedCheckpointTimeout();
        this.checkpointIdOfIgnoredInFlightData = chkConfig.getCheckpointIdOfIgnoredInFlightData();
        this.recentPendingCheckpoints = new ArrayDeque(16);
        this.masterHooks = new HashMap();
        this.timer = timer;
        this.checkpointProperties = CheckpointProperties.forCheckpoint(chkConfig.getCheckpointRetentionPolicy());
        try {
            this.checkpointStorageView = checkpointStorage.createCheckpointStorage(job);
            if (this.isPeriodicCheckpointingConfigured()) {
                this.checkpointStorageView.initializeBaseLocationsForCheckpoint();
                this.baseLocationsForCheckpointInitialized = true;
            }
        }
        catch (IOException e) {
            throw new FlinkRuntimeException("Failed to create checkpoint storage at checkpoint coordinator side.", (Throwable)e);
        }
        try {
            checkpointIDCounter.start();
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to start checkpoint ID counter: " + t.getMessage(), t);
        }
        this.requestDecider = new CheckpointRequestDecider(chkConfig.getMaxConcurrentCheckpoints(), this::rescheduleTrigger, this.clock, this.minPauseBetweenCheckpoints, this.pendingCheckpoints::size, this.checkpointsCleaner::getNumberOfCheckpointsToClean);
        this.statsTracker = (CheckpointStatsTracker)Preconditions.checkNotNull((Object)statsTracker, (String)"Statistic tracker can not be null");
        this.vertexFinishedStateCheckerFactory = (BiFunction)Preconditions.checkNotNull(vertexFinishedStateCheckerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMasterHook(MasterTriggerRestoreHook<?> hook) {
        Preconditions.checkNotNull(hook);
        String id = hook.getIdentifier();
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)id) ? 1 : 0) != 0, (Object)"The hook has a null or empty id");
        Object object = this.lock;
        synchronized (object) {
            if (!this.masterHooks.containsKey(id)) {
                this.masterHooks.put(id, hook);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfRegisteredMasterHooks() {
        Object object = this.lock;
        synchronized (object) {
            return this.masterHooks.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.shutdown) {
                this.shutdown = true;
                LOG.info("Stopping checkpoint coordinator for job {}.", (Object)this.job);
                this.periodicScheduling = false;
                MasterHooks.close(this.masterHooks.values(), LOG);
                this.masterHooks.clear();
                CheckpointException reason = new CheckpointException(CheckpointFailureReason.CHECKPOINT_COORDINATOR_SHUTDOWN);
                this.abortPendingAndQueuedCheckpoints(reason);
            }
        }
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public CompletableFuture<CompletedCheckpoint> triggerSavepoint(@Nullable String targetLocation, SavepointFormatType formatType) {
        CheckpointProperties properties = CheckpointProperties.forSavepoint(!this.unalignedCheckpointsEnabled, formatType);
        return this.triggerSavepointInternal(properties, targetLocation);
    }

    public CompletableFuture<CompletedCheckpoint> triggerSynchronousSavepoint(boolean terminate, @Nullable String targetLocation, SavepointFormatType formatType) {
        CheckpointProperties properties = CheckpointProperties.forSyncSavepoint(!this.unalignedCheckpointsEnabled, terminate, formatType);
        return this.triggerSavepointInternal(properties, targetLocation);
    }

    private CompletableFuture<CompletedCheckpoint> triggerSavepointInternal(CheckpointProperties checkpointProperties, @Nullable String targetLocation) {
        Preconditions.checkNotNull((Object)checkpointProperties);
        CompletableFuture<CompletedCheckpoint> resultFuture = new CompletableFuture<CompletedCheckpoint>();
        this.timer.execute(() -> this.triggerCheckpoint(checkpointProperties, targetLocation, false).whenComplete((completedCheckpoint, throwable) -> {
            if (throwable == null) {
                resultFuture.complete((CompletedCheckpoint)completedCheckpoint);
            } else {
                resultFuture.completeExceptionally((Throwable)throwable);
            }
        }));
        return resultFuture;
    }

    public CompletableFuture<CompletedCheckpoint> triggerCheckpoint(boolean isPeriodic) {
        return this.triggerCheckpoint(this.checkpointProperties, null, isPeriodic);
    }

    @VisibleForTesting
    public CompletableFuture<CompletedCheckpoint> triggerCheckpoint(CheckpointProperties props, @Nullable String externalSavepointLocation, boolean isPeriodic) {
        CheckpointTriggerRequest request = new CheckpointTriggerRequest(props, externalSavepointLocation, isPeriodic);
        this.chooseRequestToExecute(request).ifPresent(this::startTriggeringCheckpoint);
        return request.onCompletionPromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTriggeringCheckpoint(CheckpointTriggerRequest request) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.preCheckGlobalState(request.isPeriodic);
            }
            Preconditions.checkState((!this.isTriggering ? 1 : 0) != 0);
            this.isTriggering = true;
            long timestamp = System.currentTimeMillis();
            CompletableFuture<CheckpointPlan> checkpointPlanFuture = this.checkpointPlanCalculator.calculateCheckpointPlan();
            boolean initializeBaseLocations = !this.baseLocationsForCheckpointInitialized;
            this.baseLocationsForCheckpointInitialized = true;
            CompletionStage pendingCheckpointCompletableFuture = ((CompletableFuture)checkpointPlanFuture.thenApplyAsync(plan -> {
                try {
                    long checkpointID = this.checkpointIdCounter.getAndIncrement();
                    return new Tuple2(plan, (Object)checkpointID);
                }
                catch (Throwable e) {
                    throw new CompletionException(e);
                }
            }, this.executor)).thenApplyAsync(checkpointInfo -> this.createPendingCheckpoint(timestamp, request.props, (CheckpointPlan)checkpointInfo.f0, request.isPeriodic, (Long)checkpointInfo.f1, request.getOnCompletionFuture()), (Executor)this.timer);
            CompletionStage coordinatorCheckpointsComplete = ((CompletableFuture)((CompletableFuture)pendingCheckpointCompletableFuture).thenApplyAsync(pendingCheckpoint -> {
                try {
                    CheckpointStorageLocation checkpointStorageLocation = this.initializeCheckpointLocation(pendingCheckpoint.getCheckpointID(), request.props, request.externalSavepointLocation, initializeBaseLocations);
                    return Tuple2.of((Object)pendingCheckpoint, (Object)checkpointStorageLocation);
                }
                catch (Throwable e) {
                    throw new CompletionException(e);
                }
            }, this.executor)).thenComposeAsync(checkpointInfo -> {
                PendingCheckpoint pendingCheckpoint = (PendingCheckpoint)checkpointInfo.f0;
                Object object = this.lock;
                synchronized (object) {
                    pendingCheckpoint.setCheckpointTargetLocation((CheckpointStorageLocation)checkpointInfo.f1);
                }
                return OperatorCoordinatorCheckpoints.triggerAndAcknowledgeAllCoordinatorCheckpointsWithCompletion(this.coordinatorsToCheckpoint, pendingCheckpoint, (Executor)this.timer);
            }, (Executor)this.timer);
            CompletionStage masterStatesComplete = ((CompletableFuture)coordinatorCheckpointsComplete).thenComposeAsync(arg_0 -> this.lambda$startTriggeringCheckpoint$6((CompletableFuture)pendingCheckpointCompletableFuture, arg_0), (Executor)this.timer);
            FutureUtils.assertNoException((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(new CompletableFuture[]{masterStatesComplete, coordinatorCheckpointsComplete}).handleAsync((arg_0, arg_1) -> this.lambda$startTriggeringCheckpoint$7((CompletableFuture)pendingCheckpointCompletableFuture, request, timestamp, arg_0, arg_1), (Executor)this.timer)).exceptionally(error -> {
                if (!this.isShutdown()) {
                    throw new CompletionException((Throwable)error);
                }
                if (ExceptionUtils.findThrowable((Throwable)error, RejectedExecutionException.class).isPresent()) {
                    LOG.debug("Execution rejected during shutdown");
                } else {
                    LOG.warn("Error encountered during shutdown", error);
                }
                return null;
            }));
        }
        catch (Throwable throwable) {
            this.onTriggerFailure(request, throwable);
        }
    }

    private void triggerCheckpointRequest(CheckpointTriggerRequest request, long timestamp, PendingCheckpoint checkpoint) {
        if (checkpoint.isDisposed()) {
            this.onTriggerFailure(checkpoint, (Throwable)new CheckpointException(CheckpointFailureReason.TRIGGER_CHECKPOINT_FAILURE, (Throwable)checkpoint.getFailureCause()));
        } else {
            this.triggerTasks(request, timestamp, checkpoint).exceptionally(failure -> {
                LOG.info("Triggering Checkpoint {} for job {} failed due to {}", new Object[]{checkpoint.getCheckpointID(), this.job, failure});
                CheckpointException cause = failure instanceof CheckpointException ? (CheckpointException)failure : new CheckpointException(CheckpointFailureReason.TRIGGER_CHECKPOINT_FAILURE, (Throwable)failure);
                this.timer.execute(() -> {
                    Object object = this.lock;
                    synchronized (object) {
                        this.abortPendingCheckpoint(checkpoint, cause);
                    }
                });
                return null;
            });
            this.coordinatorsToCheckpoint.forEach(ctx -> ctx.afterSourceBarrierInjection(checkpoint.getCheckpointID()));
            if (this.maybeCompleteCheckpoint(checkpoint)) {
                this.onTriggerSuccess();
            }
        }
    }

    private CompletableFuture<Void> triggerTasks(CheckpointTriggerRequest request, long timestamp, PendingCheckpoint checkpoint) {
        long checkpointId = checkpoint.getCheckpointID();
        SnapshotType type = this.forceFullSnapshot && !request.props.isSavepoint() ? CheckpointType.FULL_CHECKPOINT : request.props.getCheckpointType();
        CheckpointOptions checkpointOptions = CheckpointOptions.forConfig(type, checkpoint.getCheckpointStorageLocation().getLocationReference(), this.isExactlyOnceMode, this.unalignedCheckpointsEnabled, this.alignedCheckpointTimeout);
        ArrayList<CompletableFuture<Acknowledge>> acks = new ArrayList<CompletableFuture<Acknowledge>>();
        for (Execution execution : checkpoint.getCheckpointPlan().getTasksToTrigger()) {
            if (request.props.isSynchronous()) {
                acks.add(execution.triggerSynchronousSavepoint(checkpointId, timestamp, checkpointOptions));
                continue;
            }
            acks.add(execution.triggerCheckpoint(checkpointId, timestamp, checkpointOptions));
        }
        return FutureUtils.waitForAll(acks);
    }

    private CheckpointStorageLocation initializeCheckpointLocation(long checkpointID, CheckpointProperties props, @Nullable String externalSavepointLocation, boolean initializeBaseLocations) throws Exception {
        CheckpointStorageLocation checkpointStorageLocation;
        if (props.isSavepoint()) {
            checkpointStorageLocation = this.checkpointStorageView.initializeLocationForSavepoint(checkpointID, externalSavepointLocation);
        } else {
            if (initializeBaseLocations) {
                this.checkpointStorageView.initializeBaseLocationsForCheckpoint();
            }
            checkpointStorageLocation = this.checkpointStorageView.initializeLocationForCheckpoint(checkpointID);
        }
        return checkpointStorageLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PendingCheckpoint createPendingCheckpoint(long timestamp, CheckpointProperties props, CheckpointPlan checkpointPlan, boolean isPeriodic, long checkpointID, CompletableFuture<CompletedCheckpoint> onCompletionPromise) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.preCheckGlobalState(isPeriodic);
            }
            catch (Throwable t) {
                throw new CompletionException(t);
            }
        }
        PendingCheckpointStats pendingCheckpointStats = this.trackPendingCheckpointStats(checkpointID, checkpointPlan, props, timestamp);
        PendingCheckpoint checkpoint = new PendingCheckpoint(this.job, checkpointID, timestamp, checkpointPlan, OperatorInfo.getIds(this.coordinatorsToCheckpoint), this.masterHooks.keySet(), props, onCompletionPromise, pendingCheckpointStats);
        Object object2 = this.lock;
        synchronized (object2) {
            this.pendingCheckpoints.put(checkpointID, checkpoint);
            ScheduledFuture cancellerHandle = this.timer.schedule((Runnable)new CheckpointCanceller(checkpoint), this.checkpointTimeout, TimeUnit.MILLISECONDS);
            if (!checkpoint.setCancellerHandle(cancellerHandle)) {
                cancellerHandle.cancel(false);
            }
        }
        LOG.info("Triggering checkpoint {} (type={}) @ {} for job {}.", new Object[]{checkpointID, checkpoint.getProps().getCheckpointType(), timestamp, this.job});
        return checkpoint;
    }

    private CompletableFuture<Void> snapshotMasterState(PendingCheckpoint checkpoint) {
        if (this.masterHooks.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        long checkpointID = checkpoint.getCheckpointId();
        long timestamp = checkpoint.getCheckpointTimestamp();
        CompletableFuture<Void> masterStateCompletableFuture = new CompletableFuture<Void>();
        for (MasterTriggerRestoreHook<?> masterHook : this.masterHooks.values()) {
            MasterHooks.triggerHook(masterHook, checkpointID, timestamp, this.executor).whenCompleteAsync((masterState, throwable) -> {
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        if (masterStateCompletableFuture.isDone()) {
                            return;
                        }
                        if (checkpoint.isDisposed()) {
                            throw new IllegalStateException("Checkpoint " + checkpointID + " has been discarded");
                        }
                        if (throwable == null) {
                            checkpoint.acknowledgeMasterState(masterHook.getIdentifier(), (MasterState)masterState);
                            if (checkpoint.areMasterStatesFullyAcknowledged()) {
                                masterStateCompletableFuture.complete(null);
                            }
                        } else {
                            masterStateCompletableFuture.completeExceptionally((Throwable)throwable);
                        }
                    }
                }
                catch (Throwable t) {
                    masterStateCompletableFuture.completeExceptionally(t);
                }
            }, (Executor)this.timer);
        }
        return masterStateCompletableFuture;
    }

    private void onTriggerSuccess() {
        this.isTriggering = false;
        this.executeQueuedRequest();
    }

    private void onTriggerFailure(CheckpointTriggerRequest onCompletionPromise, Throwable throwable) {
        CheckpointException checkpointException = CheckpointCoordinator.getCheckpointException(CheckpointFailureReason.TRIGGER_CHECKPOINT_FAILURE, throwable);
        onCompletionPromise.completeExceptionally(checkpointException);
        this.onTriggerFailure(null, onCompletionPromise.props, checkpointException);
    }

    private void onTriggerFailure(PendingCheckpoint checkpoint, Throwable throwable) {
        Preconditions.checkArgument((checkpoint != null ? 1 : 0) != 0, (Object)"Pending checkpoint can not be null.");
        this.onTriggerFailure(checkpoint, checkpoint.getProps(), throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTriggerFailure(@Nullable PendingCheckpoint checkpoint, CheckpointProperties checkpointProperties, Throwable throwable) {
        block7: {
            throwable = ExceptionUtils.stripCompletionException((Throwable)throwable);
            try {
                this.coordinatorsToCheckpoint.forEach(OperatorCoordinatorCheckpointContext::abortCurrentTriggering);
                CheckpointException cause = CheckpointCoordinator.getCheckpointException(CheckpointFailureReason.TRIGGER_CHECKPOINT_FAILURE, throwable);
                if (checkpoint != null && !checkpoint.isDisposed()) {
                    Object object = this.lock;
                    synchronized (object) {
                        this.abortPendingCheckpoint(checkpoint, cause);
                        break block7;
                    }
                }
                this.failureManager.handleCheckpointException(checkpoint, checkpointProperties, cause, null, this.job, null, this.statsTracker);
            }
            finally {
                this.isTriggering = false;
                this.executeQueuedRequest();
            }
        }
    }

    private void executeQueuedRequest() {
        this.chooseQueuedRequestToExecute().ifPresent(this::startTriggeringCheckpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<CheckpointTriggerRequest> chooseQueuedRequestToExecute() {
        Object object = this.lock;
        synchronized (object) {
            return this.requestDecider.chooseQueuedRequestToExecute(this.isTriggering, this.lastCheckpointCompletionRelativeTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<CheckpointTriggerRequest> chooseRequestToExecute(CheckpointTriggerRequest request) {
        Object object = this.lock;
        synchronized (object) {
            return this.requestDecider.chooseRequestToExecute(request, this.isTriggering, this.lastCheckpointCompletionRelativeTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maybeCompleteCheckpoint(PendingCheckpoint checkpoint) {
        Object object = this.lock;
        synchronized (object) {
            if (checkpoint.isFullyAcknowledged()) {
                try {
                    if (this.shutdown) {
                        return false;
                    }
                    this.completePendingCheckpoint(checkpoint);
                }
                catch (CheckpointException ce) {
                    this.onTriggerFailure(checkpoint, (Throwable)ce);
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveDeclineMessage(DeclineCheckpoint message, String taskManagerLocationInfo) {
        if (this.shutdown || message == null) {
            return;
        }
        if (!this.job.equals((Object)message.getJob())) {
            throw new IllegalArgumentException("Received DeclineCheckpoint message for job " + message.getJob() + " from " + taskManagerLocationInfo + " while this coordinator handles job " + this.job);
        }
        long checkpointId = message.getCheckpointId();
        CheckpointException checkpointException = message.getSerializedCheckpointException().unwrap();
        String reason = checkpointException.getMessage();
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            PendingCheckpoint checkpoint = this.pendingCheckpoints.get(checkpointId);
            if (checkpoint != null) {
                Preconditions.checkState((!checkpoint.isDisposed() ? 1 : 0) != 0, (Object)("Received message for discarded but non-removed checkpoint " + checkpointId));
                LOG.info("Decline checkpoint {} by task {} of job {} at {}.", new Object[]{checkpointId, message.getTaskExecutionId(), this.job, taskManagerLocationInfo, checkpointException.getCause()});
                this.abortPendingCheckpoint(checkpoint, checkpointException, message.getTaskExecutionId());
            } else if (LOG.isDebugEnabled()) {
                if (this.recentPendingCheckpoints.contains(checkpointId)) {
                    LOG.debug("Received another decline message for now expired checkpoint attempt {} from task {} of job {} at {} : {}", new Object[]{checkpointId, message.getTaskExecutionId(), this.job, taskManagerLocationInfo, reason});
                } else {
                    LOG.debug("Received decline message for unknown (too old?) checkpoint attempt {} from task {} of job {} at {} : {}", new Object[]{checkpointId, message.getTaskExecutionId(), this.job, taskManagerLocationInfo, reason});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receiveAcknowledgeMessage(AcknowledgeCheckpoint message, String taskManagerLocationInfo) throws CheckpointException {
        if (this.shutdown || message == null) {
            return false;
        }
        if (!this.job.equals((Object)message.getJob())) {
            LOG.error("Received wrong AcknowledgeCheckpoint message for job {} from {} : {}", new Object[]{this.job, taskManagerLocationInfo, message});
            return false;
        }
        long checkpointId = message.getCheckpointId();
        Object object = this.lock;
        synchronized (object) {
            boolean wasPendingCheckpoint;
            if (this.shutdown) {
                return false;
            }
            PendingCheckpoint checkpoint = this.pendingCheckpoints.get(checkpointId);
            if (!(message.getSubtaskState() == null || checkpoint != null && checkpoint.getProps().isSavepoint())) {
                message.getSubtaskState().registerSharedStates(this.completedCheckpointStore.getSharedStateRegistry(), checkpointId);
            }
            if (checkpoint != null && !checkpoint.isDisposed()) {
                switch (checkpoint.acknowledgeTask(message.getTaskExecutionId(), message.getSubtaskState(), message.getCheckpointMetrics())) {
                    case SUCCESS: {
                        LOG.debug("Received acknowledge message for checkpoint {} from task {} of job {} at {}.", new Object[]{checkpointId, message.getTaskExecutionId(), message.getJob(), taskManagerLocationInfo});
                        if (!checkpoint.isFullyAcknowledged()) break;
                        this.completePendingCheckpoint(checkpoint);
                        break;
                    }
                    case DUPLICATE: {
                        LOG.debug("Received a duplicate acknowledge message for checkpoint {}, task {}, job {}, location {}.", new Object[]{message.getCheckpointId(), message.getTaskExecutionId(), message.getJob(), taskManagerLocationInfo});
                        break;
                    }
                    case UNKNOWN: {
                        LOG.warn("Could not acknowledge the checkpoint {} for task {} of job {} at {}, because the task's execution attempt id was unknown. Discarding the state handle to avoid lingering state.", new Object[]{message.getCheckpointId(), message.getTaskExecutionId(), message.getJob(), taskManagerLocationInfo});
                        this.discardSubtaskState(message.getJob(), message.getTaskExecutionId(), message.getCheckpointId(), message.getSubtaskState());
                        break;
                    }
                    case DISCARDED: {
                        LOG.warn("Could not acknowledge the checkpoint {} for task {} of job {} at {}, because the pending checkpoint had been discarded. Discarding the state handle tp avoid lingering state.", new Object[]{message.getCheckpointId(), message.getTaskExecutionId(), message.getJob(), taskManagerLocationInfo});
                        this.discardSubtaskState(message.getJob(), message.getTaskExecutionId(), message.getCheckpointId(), message.getSubtaskState());
                    }
                }
                return true;
            }
            if (checkpoint != null) {
                throw new IllegalStateException("Received message for discarded but non-removed checkpoint " + checkpointId);
            }
            this.reportStats(message.getCheckpointId(), message.getTaskExecutionId(), message.getCheckpointMetrics());
            if (this.recentPendingCheckpoints.contains(checkpointId)) {
                wasPendingCheckpoint = true;
                LOG.warn("Received late message for now expired checkpoint attempt {} from task {} of job {} at {}.", new Object[]{checkpointId, message.getTaskExecutionId(), message.getJob(), taskManagerLocationInfo});
            } else {
                LOG.debug("Received message for an unknown checkpoint {} from task {} of job {} at {}.", new Object[]{checkpointId, message.getTaskExecutionId(), message.getJob(), taskManagerLocationInfo});
                wasPendingCheckpoint = false;
            }
            this.discardSubtaskState(message.getJob(), message.getTaskExecutionId(), message.getCheckpointId(), message.getSubtaskState());
            return wasPendingCheckpoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completePendingCheckpoint(PendingCheckpoint pendingCheckpoint) throws CheckpointException {
        CompletedCheckpoint lastSubsumed;
        CompletedCheckpoint completedCheckpoint;
        long checkpointId = pendingCheckpoint.getCheckpointID();
        CheckpointProperties props = pendingCheckpoint.getProps();
        this.completedCheckpointStore.getSharedStateRegistry().checkpointCompleted(checkpointId);
        try {
            completedCheckpoint = this.finalizeCheckpoint(pendingCheckpoint);
            Preconditions.checkState((pendingCheckpoint.isDisposed() && completedCheckpoint != null ? 1 : 0) != 0);
            lastSubsumed = !props.isSavepoint() ? this.addCompletedCheckpointToStoreAndSubsumeOldest(checkpointId, completedCheckpoint, pendingCheckpoint.getCheckpointPlan().getTasksToCommitTo()) : null;
            this.reportCompletedCheckpoint(completedCheckpoint);
        }
        finally {
            this.pendingCheckpoints.remove(checkpointId);
            this.scheduleTriggerRequest();
        }
        this.cleanupAfterCompletedCheckpoint(pendingCheckpoint, checkpointId, completedCheckpoint, lastSubsumed, props);
    }

    private void reportCompletedCheckpoint(CompletedCheckpoint completedCheckpoint) {
        CompletedCheckpointStats completedCheckpointStats = completedCheckpoint.getStatistic();
        if (completedCheckpointStats != null) {
            LOG.trace("Checkpoint {} size: {}Kb, duration: {}ms", new Object[]{completedCheckpoint.getCheckpointID(), completedCheckpointStats.getStateSize() == 0L ? 0L : completedCheckpointStats.getStateSize() / 1024L, completedCheckpointStats.getEndToEndDuration()});
            this.statsTracker.reportCompletedCheckpoint(completedCheckpointStats);
        }
    }

    private void cleanupAfterCompletedCheckpoint(PendingCheckpoint pendingCheckpoint, long checkpointId, CompletedCheckpoint completedCheckpoint, CompletedCheckpoint lastSubsumed, CheckpointProperties props) {
        this.rememberRecentCheckpointId(checkpointId);
        this.lastCheckpointCompletionRelativeTime = this.clock.relativeTimeMillis();
        this.logCheckpointInfo(completedCheckpoint);
        if (!props.isSavepoint() || props.isSynchronous()) {
            this.dropSubsumedCheckpoints(checkpointId);
            this.sendAcknowledgeMessages(pendingCheckpoint.getCheckpointPlan().getTasksToCommitTo(), checkpointId, completedCheckpoint.getTimestamp(), this.extractIdIfDiscardedOnSubsumed(lastSubsumed));
        }
    }

    private void logCheckpointInfo(CompletedCheckpoint completedCheckpoint) {
        LOG.info("Completed checkpoint {} for job {} ({} bytes, checkpointDuration={} ms, finalizationTime={} ms).", new Object[]{completedCheckpoint.getCheckpointID(), this.job, completedCheckpoint.getStateSize(), completedCheckpoint.getCompletionTimestamp() - completedCheckpoint.getTimestamp(), System.currentTimeMillis() - completedCheckpoint.getCompletionTimestamp()});
        if (LOG.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Checkpoint state: ");
            for (OperatorState state : completedCheckpoint.getOperatorStates().values()) {
                builder.append(state);
                builder.append(", ");
            }
            builder.setLength(builder.length() - 2);
            LOG.debug(builder.toString());
        }
    }

    private CompletedCheckpoint finalizeCheckpoint(PendingCheckpoint pendingCheckpoint) throws CheckpointException {
        try {
            CompletedCheckpoint completedCheckpoint = pendingCheckpoint.finalizeCheckpoint(this.checkpointsCleaner, this::scheduleTriggerRequest, this.executor);
            this.failureManager.handleCheckpointSuccess(pendingCheckpoint.getCheckpointID());
            return completedCheckpoint;
        }
        catch (Exception e1) {
            CheckpointFailureReason failureReason;
            CheckpointFailureReason checkpointFailureReason = failureReason = e1 instanceof FinishedTaskStateProvider.PartialFinishingNotSupportedByStateException ? CheckpointFailureReason.CHECKPOINT_DECLINED_TASK_CLOSING : CheckpointFailureReason.FINALIZE_CHECKPOINT_FAILURE;
            if (!pendingCheckpoint.isDisposed()) {
                this.abortPendingCheckpoint(pendingCheckpoint, new CheckpointException(failureReason, (Throwable)e1));
            }
            throw new CheckpointException("Could not finalize the pending checkpoint " + pendingCheckpoint.getCheckpointID() + '.', failureReason, e1);
        }
    }

    private long extractIdIfDiscardedOnSubsumed(CompletedCheckpoint lastSubsumed) {
        long lastSubsumedCheckpointId = lastSubsumed != null && lastSubsumed.getProperties().discardOnSubsumed() ? lastSubsumed.getCheckpointID() : -1L;
        return lastSubsumedCheckpointId;
    }

    private CompletedCheckpoint addCompletedCheckpointToStoreAndSubsumeOldest(long checkpointId, CompletedCheckpoint completedCheckpoint, List<ExecutionVertex> tasksToAbort) throws CheckpointException {
        try {
            CompletedCheckpoint subsumedCheckpoint = this.completedCheckpointStore.addCheckpointAndSubsumeOldestOne(completedCheckpoint, this.checkpointsCleaner, this::scheduleTriggerRequest);
            this.forceFullSnapshot = false;
            return subsumedCheckpoint;
        }
        catch (Exception exception) {
            if (exception instanceof PossibleInconsistentStateException) {
                LOG.warn("An error occurred while writing checkpoint {} to the underlying metadata store. Flink was not able to determine whether the metadata was successfully persisted. The corresponding state located at '{}' won't be discarded and needs to be cleaned up manually.", (Object)completedCheckpoint.getCheckpointID(), (Object)completedCheckpoint.getExternalPointer());
            } else {
                this.checkpointsCleaner.cleanCheckpointOnFailedStoring(completedCheckpoint, this.executor);
            }
            this.reportFailedCheckpoint(checkpointId, exception);
            this.sendAbortedMessages(tasksToAbort, checkpointId, completedCheckpoint.getTimestamp());
            throw new CheckpointException("Could not complete the pending checkpoint " + checkpointId + '.', CheckpointFailureReason.FINALIZE_CHECKPOINT_FAILURE, exception);
        }
    }

    private void reportFailedCheckpoint(long checkpointId, Exception exception) {
        PendingCheckpointStats pendingCheckpointStats = this.statsTracker.getPendingCheckpointStats(checkpointId);
        if (pendingCheckpointStats != null) {
            this.statsTracker.reportFailedCheckpoint(pendingCheckpointStats.toFailedCheckpoint(System.currentTimeMillis(), exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleTriggerRequest() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isShutdown()) {
                LOG.debug("Skip scheduling trigger request because the CheckpointCoordinator is shut down");
            } else {
                this.timer.execute(this::executeQueuedRequest);
            }
        }
    }

    @VisibleForTesting
    void sendAcknowledgeMessages(List<ExecutionVertex> tasksToCommit, long completedCheckpointId, long completedTimestamp, long lastSubsumedCheckpointId) {
        for (ExecutionVertex ev : tasksToCommit) {
            Execution ee = ev.getCurrentExecutionAttempt();
            if (ee == null) continue;
            ee.notifyCheckpointOnComplete(completedCheckpointId, completedTimestamp, lastSubsumedCheckpointId);
        }
        for (OperatorCoordinatorCheckpointContext coordinatorContext : this.coordinatorsToCheckpoint) {
            coordinatorContext.notifyCheckpointComplete(completedCheckpointId);
        }
    }

    private void sendAbortedMessages(List<ExecutionVertex> tasksToAbort, long checkpointId, long timeStamp) {
        assert (Thread.holdsLock(this.lock));
        long latestCompletedCheckpointId = this.completedCheckpointStore.getLatestCheckpointId();
        this.executor.execute(() -> {
            for (ExecutionVertex ev : tasksToAbort) {
                Execution ee = ev.getCurrentExecutionAttempt();
                if (ee == null) continue;
                ee.notifyCheckpointAborted(checkpointId, latestCompletedCheckpointId, timeStamp);
            }
        });
        for (OperatorCoordinatorCheckpointContext coordinatorContext : this.coordinatorsToCheckpoint) {
            coordinatorContext.notifyCheckpointAborted(checkpointId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failUnacknowledgedPendingCheckpointsFor(ExecutionAttemptID executionAttemptId, Throwable cause) {
        Object object = this.lock;
        synchronized (object) {
            this.abortPendingCheckpoints(checkpoint -> !checkpoint.isAcknowledgedBy(executionAttemptId), new CheckpointException(CheckpointFailureReason.TASK_FAILURE, cause));
        }
    }

    private void rememberRecentCheckpointId(long id) {
        if (this.recentPendingCheckpoints.size() >= 16) {
            this.recentPendingCheckpoints.removeFirst();
        }
        this.recentPendingCheckpoints.addLast(id);
    }

    private void dropSubsumedCheckpoints(long checkpointId) {
        this.abortPendingCheckpoints(checkpoint -> checkpoint.getCheckpointId() < checkpointId && checkpoint.canBeSubsumed(), new CheckpointException(CheckpointFailureReason.CHECKPOINT_SUBSUMED));
    }

    public OptionalLong restoreLatestCheckpointedStateToSubtasks(Set<ExecutionJobVertex> tasks) throws Exception {
        return this.restoreLatestCheckpointedStateInternal(tasks, OperatorCoordinatorRestoreBehavior.SKIP, false, true, false);
    }

    public boolean restoreLatestCheckpointedStateToAll(Set<ExecutionJobVertex> tasks, boolean allowNonRestoredState) throws Exception {
        OptionalLong restoredCheckpointId = this.restoreLatestCheckpointedStateInternal(tasks, OperatorCoordinatorRestoreBehavior.RESTORE_OR_RESET, false, allowNonRestoredState, false);
        return restoredCheckpointId.isPresent();
    }

    public boolean restoreInitialCheckpointIfPresent(Set<ExecutionJobVertex> tasks) throws Exception {
        OptionalLong restoredCheckpointId = this.restoreLatestCheckpointedStateInternal(tasks, OperatorCoordinatorRestoreBehavior.RESTORE_IF_CHECKPOINT_PRESENT, false, false, true);
        return restoredCheckpointId.isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OptionalLong restoreLatestCheckpointedStateInternal(Set<ExecutionJobVertex> tasks, OperatorCoordinatorRestoreBehavior operatorCoordinatorRestoreBehavior, boolean errorIfNoCheckpoint, boolean allowNonRestoredState, boolean checkForPartiallyFinishedOperators) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                throw new IllegalStateException("CheckpointCoordinator is shut down");
            }
            CompletedCheckpoint latest = this.completedCheckpointStore.getLatestCheckpoint();
            if (latest == null) {
                LOG.info("No checkpoint found during restore.");
                if (errorIfNoCheckpoint) {
                    throw new IllegalStateException("No completed checkpoint available");
                }
                LOG.debug("Resetting the master hooks.");
                MasterHooks.reset(this.masterHooks.values(), LOG);
                if (operatorCoordinatorRestoreBehavior == OperatorCoordinatorRestoreBehavior.RESTORE_OR_RESET) {
                    LOG.info("Resetting the Operator Coordinators to an empty state.");
                    this.restoreStateToCoordinators(-1L, Collections.emptyMap());
                }
                return OptionalLong.empty();
            }
            LOG.info("Restoring job {} from {}.", (Object)this.job, (Object)latest);
            this.forceFullSnapshot = latest.getProperties().isUnclaimed();
            Map<OperatorID, OperatorState> operatorStates = this.extractOperatorStates(latest);
            if (checkForPartiallyFinishedOperators) {
                VertexFinishedStateChecker vertexFinishedStateChecker = this.vertexFinishedStateCheckerFactory.apply(tasks, operatorStates);
                vertexFinishedStateChecker.validateOperatorsFinishedState();
            }
            StateAssignmentOperation stateAssignmentOperation = new StateAssignmentOperation(latest.getCheckpointID(), tasks, operatorStates, allowNonRestoredState);
            stateAssignmentOperation.assignStates();
            MasterHooks.restoreMasterHooks(this.masterHooks, latest.getMasterHookStates(), latest.getCheckpointID(), allowNonRestoredState, LOG);
            if (operatorCoordinatorRestoreBehavior != OperatorCoordinatorRestoreBehavior.SKIP) {
                this.restoreStateToCoordinators(latest.getCheckpointID(), operatorStates);
            }
            long restoreTimestamp = System.currentTimeMillis();
            RestoredCheckpointStats restored = new RestoredCheckpointStats(latest.getCheckpointID(), latest.getProperties(), restoreTimestamp, latest.getExternalPointer());
            this.statsTracker.reportRestoredCheckpoint(restored);
            return OptionalLong.of(latest.getCheckpointID());
        }
    }

    private Map<OperatorID, OperatorState> extractOperatorStates(CompletedCheckpoint checkpoint) {
        Map<OperatorID, OperatorState> originalOperatorStates = checkpoint.getOperatorStates();
        if (checkpoint.getCheckpointID() != this.checkpointIdOfIgnoredInFlightData) {
            return originalOperatorStates;
        }
        HashMap<OperatorID, OperatorState> newStates = new HashMap<OperatorID, OperatorState>();
        for (OperatorState originalOperatorState : originalOperatorStates.values()) {
            newStates.put(originalOperatorState.getOperatorID(), originalOperatorState.copyAndDiscardInFlightData());
        }
        return newStates;
    }

    public boolean restoreSavepoint(SavepointRestoreSettings restoreSettings, Map<JobVertexID, ExecutionJobVertex> tasks, ClassLoader userClassLoader) throws Exception {
        CheckpointProperties checkpointProperties;
        String savepointPointer = restoreSettings.getRestorePath();
        boolean allowNonRestored = restoreSettings.allowNonRestoredState();
        Preconditions.checkNotNull((Object)savepointPointer, (String)"The savepoint path cannot be null.");
        LOG.info("Starting job {} from savepoint {} ({})", new Object[]{this.job, savepointPointer, allowNonRestored ? "allowing non restored state" : ""});
        CompletedCheckpointStorageLocation checkpointLocation = this.checkpointStorageView.resolveCheckpoint(savepointPointer);
        switch (restoreSettings.getRestoreMode()) {
            case CLAIM: {
                checkpointProperties = this.checkpointProperties;
                break;
            }
            case LEGACY: {
                checkpointProperties = CheckpointProperties.forSavepoint(false, SavepointFormatType.CANONICAL);
                break;
            }
            case NO_CLAIM: {
                checkpointProperties = CheckpointProperties.forUnclaimedSnapshot();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown snapshot restore mode");
            }
        }
        CompletedCheckpoint savepoint = Checkpoints.loadAndValidateCheckpoint(this.job, tasks, checkpointLocation, userClassLoader, allowNonRestored, checkpointProperties, restoreSettings.getRestoreMode());
        savepoint.registerSharedStatesAfterRestored(this.completedCheckpointStore.getSharedStateRegistry(), restoreSettings.getRestoreMode());
        this.completedCheckpointStore.addCheckpointAndSubsumeOldestOne(savepoint, this.checkpointsCleaner, this::scheduleTriggerRequest);
        long nextCheckpointId = savepoint.getCheckpointID() + 1L;
        this.checkpointIdCounter.setCount(nextCheckpointId);
        LOG.info("Reset the checkpoint ID of job {} to {}.", (Object)this.job, (Object)nextCheckpointId);
        OptionalLong restoredCheckpointId = this.restoreLatestCheckpointedStateInternal(new HashSet<ExecutionJobVertex>(tasks.values()), OperatorCoordinatorRestoreBehavior.RESTORE_IF_CHECKPOINT_PRESENT, true, allowNonRestored, true);
        return restoredCheckpointId.isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfPendingCheckpoints() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingCheckpoints.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfRetainedSuccessfulCheckpoints() {
        Object object = this.lock;
        synchronized (object) {
            return this.completedCheckpointStore.getNumberOfRetainedCheckpoints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, PendingCheckpoint> getPendingCheckpoints() {
        Object object = this.lock;
        synchronized (object) {
            return new HashMap<Long, PendingCheckpoint>(this.pendingCheckpoints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CompletedCheckpoint> getSuccessfulCheckpoints() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            return this.completedCheckpointStore.getAllCheckpoints();
        }
    }

    public CheckpointStorageCoordinatorView getCheckpointStorage() {
        return this.checkpointStorageView;
    }

    public CompletedCheckpointStore getCheckpointStore() {
        return this.completedCheckpointStore;
    }

    public long getCheckpointTimeout() {
        return this.checkpointTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @VisibleForTesting
    PriorityQueue<CheckpointTriggerRequest> getTriggerRequestQueue() {
        Object object = this.lock;
        synchronized (object) {
            return this.requestDecider.getTriggerRequestQueue();
        }
    }

    public boolean isTriggering() {
        return this.isTriggering;
    }

    @VisibleForTesting
    boolean isCurrentPeriodicTriggerAvailable() {
        return this.currentPeriodicTrigger != null;
    }

    public boolean isPeriodicCheckpointingConfigured() {
        return this.baseInterval != Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCheckpointScheduler() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                throw new IllegalArgumentException("Checkpoint coordinator is shut down");
            }
            Preconditions.checkState((boolean)this.isPeriodicCheckpointingConfigured(), (Object)"Can not start checkpoint scheduler, if no periodic checkpointing is configured");
            this.stopCheckpointScheduler();
            this.periodicScheduling = true;
            this.currentPeriodicTrigger = this.scheduleTriggerWithDelay(this.getRandomInitDelay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCheckpointScheduler() {
        Object object = this.lock;
        synchronized (object) {
            this.periodicScheduling = false;
            this.cancelPeriodicTrigger();
            CheckpointException reason = new CheckpointException(CheckpointFailureReason.CHECKPOINT_COORDINATOR_SUSPEND);
            this.abortPendingAndQueuedCheckpoints(reason);
        }
    }

    public boolean isPeriodicCheckpointingStarted() {
        return this.periodicScheduling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortPendingCheckpoints(CheckpointException exception) {
        Object object = this.lock;
        synchronized (object) {
            this.abortPendingCheckpoints(ignored -> true, exception);
        }
    }

    private void abortPendingCheckpoints(Predicate<PendingCheckpoint> checkpointToFailPredicate, CheckpointException exception) {
        PendingCheckpoint[] pendingCheckpointsToFail;
        assert (Thread.holdsLock(this.lock));
        for (PendingCheckpoint pendingCheckpoint : pendingCheckpointsToFail = (PendingCheckpoint[])this.pendingCheckpoints.values().stream().filter(checkpointToFailPredicate).toArray(PendingCheckpoint[]::new)) {
            this.abortPendingCheckpoint(pendingCheckpoint, exception);
        }
    }

    private void rescheduleTrigger(long tillNextMillis) {
        this.cancelPeriodicTrigger();
        this.currentPeriodicTrigger = this.scheduleTriggerWithDelay(tillNextMillis);
    }

    private void cancelPeriodicTrigger() {
        if (this.currentPeriodicTrigger != null) {
            this.currentPeriodicTrigger.cancel(false);
            this.currentPeriodicTrigger = null;
        }
    }

    private long getRandomInitDelay() {
        return ThreadLocalRandom.current().nextLong(this.minPauseBetweenCheckpoints, this.baseInterval + 1L);
    }

    private ScheduledFuture<?> scheduleTriggerWithDelay(long initDelay) {
        return this.timer.scheduleAtFixedRate((Runnable)new ScheduledTrigger(), initDelay, this.baseInterval, TimeUnit.MILLISECONDS);
    }

    private void restoreStateToCoordinators(long checkpointId, Map<OperatorID, OperatorState> operatorStates) throws Exception {
        for (OperatorCoordinatorCheckpointContext coordContext : this.coordinatorsToCheckpoint) {
            OperatorState state = operatorStates.get((Object)coordContext.operatorId());
            ByteStreamStateHandle coordinatorState = state == null ? null : state.getCoordinatorState();
            byte[] bytes = coordinatorState == null ? null : coordinatorState.getData();
            coordContext.resetToCheckpoint(checkpointId, bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobStatusListener createActivatorDeactivator() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                throw new IllegalArgumentException("Checkpoint coordinator is shut down");
            }
            if (this.jobStatusListener == null) {
                this.jobStatusListener = new CheckpointCoordinatorDeActivator(this);
            }
            return this.jobStatusListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumQueuedRequests() {
        Object object = this.lock;
        synchronized (object) {
            return this.requestDecider.getNumQueuedRequests();
        }
    }

    public void reportStats(long id, ExecutionAttemptID attemptId, CheckpointMetrics metrics) throws CheckpointException {
        this.attemptMappingProvider.getVertex(attemptId).ifPresent(ev -> this.statsTracker.reportIncompleteStats(id, (ExecutionVertex)ev, metrics));
    }

    private void discardSubtaskState(final JobID jobId, final ExecutionAttemptID executionAttemptID, final long checkpointId, final TaskStateSnapshot subtaskState) {
        if (subtaskState != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        subtaskState.discardState();
                    }
                    catch (Throwable t2) {
                        LOG.warn("Could not properly discard state object of checkpoint {} belonging to task {} of job {}.", new Object[]{checkpointId, executionAttemptID, jobId, t2});
                    }
                }
            });
        }
    }

    private void abortPendingCheckpoint(PendingCheckpoint pendingCheckpoint, CheckpointException exception) {
        this.abortPendingCheckpoint(pendingCheckpoint, exception, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortPendingCheckpoint(PendingCheckpoint pendingCheckpoint, CheckpointException exception, @Nullable ExecutionAttemptID executionAttemptID) {
        assert (Thread.holdsLock(this.lock));
        if (!pendingCheckpoint.isDisposed()) {
            try {
                pendingCheckpoint.abort(exception.getCheckpointFailureReason(), exception.getCause(), this.checkpointsCleaner, this::scheduleTriggerRequest, this.executor, this.statsTracker);
                this.failureManager.handleCheckpointException(pendingCheckpoint, pendingCheckpoint.getProps(), exception, executionAttemptID, this.job, this.getStatsCallback(pendingCheckpoint), this.statsTracker);
            }
            finally {
                this.sendAbortedMessages(pendingCheckpoint.getCheckpointPlan().getTasksToCommitTo(), pendingCheckpoint.getCheckpointId(), pendingCheckpoint.getCheckpointTimestamp());
                this.pendingCheckpoints.remove(pendingCheckpoint.getCheckpointId());
                this.rememberRecentCheckpointId(pendingCheckpoint.getCheckpointId());
                this.scheduleTriggerRequest();
            }
        }
    }

    private void preCheckGlobalState(boolean isPeriodic) throws CheckpointException {
        if (this.shutdown) {
            throw new CheckpointException(CheckpointFailureReason.CHECKPOINT_COORDINATOR_SHUTDOWN);
        }
        if (isPeriodic && !this.periodicScheduling) {
            throw new CheckpointException(CheckpointFailureReason.PERIODIC_SCHEDULER_SHUTDOWN);
        }
    }

    private void abortPendingAndQueuedCheckpoints(CheckpointException exception) {
        assert (Thread.holdsLock(this.lock));
        this.requestDecider.abortAll(exception);
        this.abortPendingCheckpoints(exception);
    }

    private static CheckpointException getCheckpointException(CheckpointFailureReason defaultReason, Throwable throwable) {
        Optional ioExceptionOptional = ExceptionUtils.findThrowable((Throwable)throwable, IOException.class);
        if (ioExceptionOptional.isPresent()) {
            return new CheckpointException(CheckpointFailureReason.IO_EXCEPTION, throwable);
        }
        Optional checkpointExceptionOptional = ExceptionUtils.findThrowable((Throwable)throwable, CheckpointException.class);
        return checkpointExceptionOptional.orElseGet(() -> new CheckpointException(defaultReason, throwable));
    }

    private PendingCheckpointStats trackPendingCheckpointStats(long checkpointId, CheckpointPlan checkpointPlan, CheckpointProperties props, long checkpointTimestamp) {
        Map<JobVertexID, Integer> vertices = Stream.concat(checkpointPlan.getTasksToWaitFor().stream(), checkpointPlan.getFinishedTasks().stream()).map(Execution::getVertex).map(ExecutionVertex::getJobVertex).distinct().collect(Collectors.toMap(ExecutionJobVertex::getJobVertexId, ExecutionJobVertex::getParallelism));
        PendingCheckpointStats pendingCheckpointStats = this.statsTracker.reportPendingCheckpoint(checkpointId, checkpointTimestamp, props, vertices);
        this.reportFinishedTasks(pendingCheckpointStats, checkpointPlan.getFinishedTasks());
        return pendingCheckpointStats;
    }

    private void reportFinishedTasks(PendingCheckpointStats pendingCheckpointStats, List<Execution> finishedTasks) {
        long now = System.currentTimeMillis();
        finishedTasks.forEach(execution -> pendingCheckpointStats.reportSubtaskStats(execution.getVertex().getJobvertexId(), new SubtaskStateStats(execution.getParallelSubtaskIndex(), now)));
    }

    @Nullable
    private PendingCheckpointStats getStatsCallback(PendingCheckpoint pendingCheckpoint) {
        return this.statsTracker.getPendingCheckpointStats(pendingCheckpoint.getCheckpointID());
    }

    private /* synthetic */ Object lambda$startTriggeringCheckpoint$7(CompletableFuture pendingCheckpointCompletableFuture, CheckpointTriggerRequest request, long timestamp, Void ignored, Throwable throwable) {
        PendingCheckpoint checkpoint = (PendingCheckpoint)FutureUtils.getWithoutException((CompletableFuture)pendingCheckpointCompletableFuture);
        Preconditions.checkState((checkpoint != null || throwable != null ? 1 : 0) != 0, (Object)"Either the pending checkpoint needs to be created or an error must have occurred.");
        if (throwable != null) {
            if (checkpoint == null) {
                this.onTriggerFailure(request, throwable);
            } else {
                this.onTriggerFailure(checkpoint, throwable);
            }
        } else {
            this.triggerCheckpointRequest(request, timestamp, checkpoint);
        }
        return null;
    }

    private /* synthetic */ CompletionStage lambda$startTriggeringCheckpoint$6(CompletableFuture pendingCheckpointCompletableFuture, Object ignored) {
        PendingCheckpoint checkpoint = (PendingCheckpoint)FutureUtils.getWithoutException((CompletableFuture)pendingCheckpointCompletableFuture);
        return this.snapshotMasterState(checkpoint);
    }

    private static enum OperatorCoordinatorRestoreBehavior {
        RESTORE_OR_RESET,
        RESTORE_IF_CHECKPOINT_PRESENT,
        SKIP;

    }

    static class CheckpointTriggerRequest {
        final long timestamp;
        final CheckpointProperties props;
        @Nullable
        final String externalSavepointLocation;
        final boolean isPeriodic;
        private final CompletableFuture<CompletedCheckpoint> onCompletionPromise = new CompletableFuture();

        CheckpointTriggerRequest(CheckpointProperties props, @Nullable String externalSavepointLocation, boolean isPeriodic) {
            this.timestamp = System.currentTimeMillis();
            this.props = (CheckpointProperties)Preconditions.checkNotNull((Object)props);
            this.externalSavepointLocation = externalSavepointLocation;
            this.isPeriodic = isPeriodic;
        }

        CompletableFuture<CompletedCheckpoint> getOnCompletionFuture() {
            return this.onCompletionPromise;
        }

        public void completeExceptionally(CheckpointException exception) {
            this.onCompletionPromise.completeExceptionally(exception);
        }

        public boolean isForce() {
            return this.props.forceCheckpoint();
        }
    }

    private class CheckpointCanceller
    implements Runnable {
        private final PendingCheckpoint pendingCheckpoint;

        private CheckpointCanceller(PendingCheckpoint pendingCheckpoint) {
            this.pendingCheckpoint = (PendingCheckpoint)Preconditions.checkNotNull((Object)pendingCheckpoint);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = CheckpointCoordinator.this.lock;
            synchronized (object) {
                if (!this.pendingCheckpoint.isDisposed()) {
                    LOG.info("Checkpoint {} of job {} expired before completing.", (Object)this.pendingCheckpoint.getCheckpointId(), (Object)CheckpointCoordinator.this.job);
                    CheckpointCoordinator.this.abortPendingCheckpoint(this.pendingCheckpoint, new CheckpointException(CheckpointFailureReason.CHECKPOINT_EXPIRED));
                }
            }
        }
    }

    private final class ScheduledTrigger
    implements Runnable {
        private ScheduledTrigger() {
        }

        @Override
        public void run() {
            try {
                CheckpointCoordinator.this.triggerCheckpoint(true);
            }
            catch (Exception e) {
                LOG.error("Exception while triggering checkpoint for job {}.", (Object)CheckpointCoordinator.this.job, (Object)e);
            }
        }
    }
}

