/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.spanner.Dialect;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSchema;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableListMultimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableTable;

final class AutoValue_SpannerSchema
extends SpannerSchema {
    private final ImmutableList<String> tables;
    private final Dialect dialect;
    private final ImmutableListMultimap<String, SpannerSchema.Column> columns;
    private final ImmutableListMultimap<String, SpannerSchema.KeyPart> keyParts;
    private final ImmutableTable<String, String, Long> cellsMutatedPerColumn;
    private final ImmutableMap<String, Long> cellsMutatedPerRow;

    private AutoValue_SpannerSchema(ImmutableList<String> tables, Dialect dialect, ImmutableListMultimap<String, SpannerSchema.Column> columns, ImmutableListMultimap<String, SpannerSchema.KeyPart> keyParts, ImmutableTable<String, String, Long> cellsMutatedPerColumn, ImmutableMap<String, Long> cellsMutatedPerRow) {
        this.tables = tables;
        this.dialect = dialect;
        this.columns = columns;
        this.keyParts = keyParts;
        this.cellsMutatedPerColumn = cellsMutatedPerColumn;
        this.cellsMutatedPerRow = cellsMutatedPerRow;
    }

    @Override
    ImmutableList<String> tables() {
        return this.tables;
    }

    @Override
    Dialect dialect() {
        return this.dialect;
    }

    @Override
    ImmutableListMultimap<String, SpannerSchema.Column> columns() {
        return this.columns;
    }

    @Override
    ImmutableListMultimap<String, SpannerSchema.KeyPart> keyParts() {
        return this.keyParts;
    }

    @Override
    ImmutableTable<String, String, Long> cellsMutatedPerColumn() {
        return this.cellsMutatedPerColumn;
    }

    @Override
    ImmutableMap<String, Long> cellsMutatedPerRow() {
        return this.cellsMutatedPerRow;
    }

    public String toString() {
        return "SpannerSchema{tables=" + this.tables + ", dialect=" + this.dialect + ", columns=" + this.columns + ", keyParts=" + this.keyParts + ", cellsMutatedPerColumn=" + this.cellsMutatedPerColumn + ", cellsMutatedPerRow=" + this.cellsMutatedPerRow + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SpannerSchema) {
            SpannerSchema that = (SpannerSchema)o;
            return this.tables.equals(that.tables()) && this.dialect.equals((Object)that.dialect()) && this.columns.equals(that.columns()) && this.keyParts.equals(that.keyParts()) && this.cellsMutatedPerColumn.equals(that.cellsMutatedPerColumn()) && this.cellsMutatedPerRow.equals(that.cellsMutatedPerRow());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.tables.hashCode();
        h$ *= 1000003;
        h$ ^= this.dialect.hashCode();
        h$ *= 1000003;
        h$ ^= this.columns.hashCode();
        h$ *= 1000003;
        h$ ^= this.keyParts.hashCode();
        h$ *= 1000003;
        h$ ^= this.cellsMutatedPerColumn.hashCode();
        h$ *= 1000003;
        return h$ ^= this.cellsMutatedPerRow.hashCode();
    }

    static final class Builder
    extends SpannerSchema.Builder {
        private ImmutableList<String> tables;
        private Dialect dialect;
        private ImmutableListMultimap.Builder<String, SpannerSchema.Column> columnsBuilder$;
        private ImmutableListMultimap<String, SpannerSchema.Column> columns;
        private ImmutableListMultimap.Builder<String, SpannerSchema.KeyPart> keyPartsBuilder$;
        private ImmutableListMultimap<String, SpannerSchema.KeyPart> keyParts;
        private ImmutableTable.Builder<String, String, Long> cellsMutatedPerColumnBuilder$;
        private ImmutableTable<String, String, Long> cellsMutatedPerColumn;
        private ImmutableMap.Builder<String, Long> cellsMutatedPerRowBuilder$;
        private ImmutableMap<String, Long> cellsMutatedPerRow;

        Builder() {
        }

        @Override
        SpannerSchema.Builder setTables(ImmutableList<String> tables) {
            if (tables == null) {
                throw new NullPointerException("Null tables");
            }
            this.tables = tables;
            return this;
        }

        @Override
        SpannerSchema.Builder setDialect(Dialect dialect) {
            if (dialect == null) {
                throw new NullPointerException("Null dialect");
            }
            this.dialect = dialect;
            return this;
        }

        @Override
        Dialect dialect() {
            if (this.dialect == null) {
                throw new IllegalStateException("Property \"dialect\" has not been set");
            }
            return this.dialect;
        }

        @Override
        ImmutableListMultimap.Builder<String, SpannerSchema.Column> columnsBuilder() {
            if (this.columnsBuilder$ == null) {
                this.columnsBuilder$ = new ImmutableListMultimap.Builder();
            }
            return this.columnsBuilder$;
        }

        @Override
        ImmutableListMultimap<String, SpannerSchema.Column> columns() {
            if (this.columnsBuilder$ != null) {
                return this.columnsBuilder$.build();
            }
            if (this.columns == null) {
                this.columns = ImmutableListMultimap.of();
            }
            return this.columns;
        }

        @Override
        ImmutableListMultimap.Builder<String, SpannerSchema.KeyPart> keyPartsBuilder() {
            if (this.keyPartsBuilder$ == null) {
                this.keyPartsBuilder$ = new ImmutableListMultimap.Builder();
            }
            return this.keyPartsBuilder$;
        }

        @Override
        ImmutableTable.Builder<String, String, Long> cellsMutatedPerColumnBuilder() {
            if (this.cellsMutatedPerColumnBuilder$ == null) {
                this.cellsMutatedPerColumnBuilder$ = ImmutableTable.builder();
            }
            return this.cellsMutatedPerColumnBuilder$;
        }

        @Override
        ImmutableTable<String, String, Long> cellsMutatedPerColumn() {
            if (this.cellsMutatedPerColumnBuilder$ != null) {
                return this.cellsMutatedPerColumnBuilder$.build();
            }
            if (this.cellsMutatedPerColumn == null) {
                this.cellsMutatedPerColumn = ImmutableTable.of();
            }
            return this.cellsMutatedPerColumn;
        }

        @Override
        ImmutableMap.Builder<String, Long> cellsMutatedPerRowBuilder() {
            if (this.cellsMutatedPerRowBuilder$ == null) {
                this.cellsMutatedPerRowBuilder$ = ImmutableMap.builder();
            }
            return this.cellsMutatedPerRowBuilder$;
        }

        @Override
        SpannerSchema autoBuild() {
            if (this.columnsBuilder$ != null) {
                this.columns = this.columnsBuilder$.build();
            } else if (this.columns == null) {
                this.columns = ImmutableListMultimap.of();
            }
            if (this.keyPartsBuilder$ != null) {
                this.keyParts = this.keyPartsBuilder$.build();
            } else if (this.keyParts == null) {
                this.keyParts = ImmutableListMultimap.of();
            }
            if (this.cellsMutatedPerColumnBuilder$ != null) {
                this.cellsMutatedPerColumn = this.cellsMutatedPerColumnBuilder$.build();
            } else if (this.cellsMutatedPerColumn == null) {
                this.cellsMutatedPerColumn = ImmutableTable.of();
            }
            if (this.cellsMutatedPerRowBuilder$ != null) {
                this.cellsMutatedPerRow = this.cellsMutatedPerRowBuilder$.build();
            } else if (this.cellsMutatedPerRow == null) {
                this.cellsMutatedPerRow = ImmutableMap.of();
            }
            if (this.tables == null || this.dialect == null) {
                StringBuilder missing = new StringBuilder();
                if (this.tables == null) {
                    missing.append(" tables");
                }
                if (this.dialect == null) {
                    missing.append(" dialect");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SpannerSchema(this.tables, this.dialect, this.columns, this.keyParts, this.cellsMutatedPerColumn, this.cellsMutatedPerRow);
        }
    }
}

