/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import org.apache.beam.sdk.io.gcp.pubsublite.PublisherOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.PubsubLiteIO;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriberOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.UuidDeduplicationOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.ProtoFromBytes;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.ProtoToBytes;
import org.apache.beam.sdk.transforms.ExternalTransformBuilder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class ExternalTransformConfig {
    private ExternalTransformConfig() {
    }

    public static class ReadExternalBuilder
    implements ExternalTransformBuilder<ReadConfig, PBegin, PCollection<byte[]>> {
        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> buildExternal(@UnknownKeyFor @NonNull @Initialized ReadConfig configuration) {
            final SubscriberOptions options = configuration.builder.build();
            final boolean deduplicate = configuration.deduplicate;
            return new PTransform<PBegin, PCollection<byte[]>>(){

                public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
                    PCollection messages = (PCollection)input.apply(PubsubLiteIO.read(options));
                    if (deduplicate) {
                        messages = (PCollection)messages.apply(PubsubLiteIO.deduplicate(UuidDeduplicationOptions.newBuilder().build()));
                    }
                    return (PCollection)messages.apply(new ProtoToBytes());
                }
            };
        }
    }

    public static class ReadConfig {
        private final @UnknownKeyFor @NonNull @Initialized SubscriberOptions.Builder builder = SubscriberOptions.newBuilder();
        private @UnknownKeyFor @NonNull @Initialized boolean deduplicate = false;

        public void setSubscriptionPath(@UnknownKeyFor @NonNull @Initialized String path) {
            this.builder.setSubscriptionPath(SubscriptionPath.parse((String)path));
        }

        public void setDeduplicate(@UnknownKeyFor @NonNull @Initialized Boolean deduplicate) {
            this.deduplicate = deduplicate;
        }
    }

    public static class WriteExternalBuilder
    implements ExternalTransformBuilder<WriteConfig, PCollection<byte[]>, PDone> {
        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>, @UnknownKeyFor @NonNull @Initialized PDone> buildExternal(@UnknownKeyFor @NonNull @Initialized WriteConfig configuration) {
            final PublisherOptions options = configuration.builder.build();
            final boolean addUuids = configuration.addUuids;
            return new PTransform<PCollection<byte[]>, PDone>(){

                public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> input) {
                    PCollection messages = (PCollection)input.apply(new ProtoFromBytes<PubSubMessage>(PubSubMessage::parseFrom));
                    if (addUuids) {
                        messages = (PCollection)messages.apply(PubsubLiteIO.addUuids());
                    }
                    return (PDone)messages.apply(PubsubLiteIO.write(options));
                }
            };
        }
    }

    public static class WriteConfig {
        private final @UnknownKeyFor @NonNull @Initialized PublisherOptions.Builder builder = PublisherOptions.newBuilder();
        private @UnknownKeyFor @NonNull @Initialized boolean addUuids = false;

        public void setTopicPath(@UnknownKeyFor @NonNull @Initialized String path) {
            this.builder.setTopicPath(TopicPath.parse((String)path));
        }

        public void setAddUuids(@UnknownKeyFor @NonNull @Initialized Boolean addUuids) {
            this.addUuids = addUuids;
        }
    }
}

