/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mongodbinput;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mongo.metadata.MongoDbConnection;
import org.apache.hop.mongo.wrapper.MongoClientWrapper;
import org.apache.hop.mongo.wrapper.collection.MongoCollectionWrapper;
import org.apache.hop.mongo.wrapper.cursor.MongoCursorWrapper;
import org.apache.hop.mongo.wrapper.field.MongoArrayExpansion;
import org.apache.hop.mongo.wrapper.field.MongoField;
import org.apache.hop.pipeline.transform.BaseTransformData;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transforms.mongodbinput.MongoDbInputMeta;

public class MongoDbInputData
extends BaseTransformData
implements ITransformData {
    public static final int MONGO_DEFAULT_PORT = 27017;
    public IRowMeta outputRowMeta;
    public MongoClientWrapper clientWrapper;
    public MongoCollectionWrapper collection;
    public MongoCursorWrapper cursor;
    public MongoDbConnection connection;
    Iterator<DBObject> pipelineResult;
    private List<MongoField> userFields;
    private MongoArrayExpansion expansionHandler;

    protected static MongoArrayExpansion checkFieldPaths(List<MongoField> normalFields, IRowMeta outputRowMeta) throws HopException {
        String expansion = null;
        ArrayList<MongoField> normalList = new ArrayList<MongoField>();
        ArrayList<MongoField> expansionList = new ArrayList<MongoField>();
        for (MongoField mongoField : normalFields) {
            String string = mongoField.fieldPath;
            if (string != null && string.lastIndexOf("[*]") >= 0) {
                if (string.indexOf("[*]") != string.lastIndexOf("[*]")) {
                    throw new HopException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoInput.ErrorMessage.PathContainsMultipleExpansions", (String[])new String[]{string}));
                }
                String pathPart = string.substring(0, string.lastIndexOf("[*]") + 3);
                if (expansion == null) {
                    expansion = pathPart;
                } else if (!expansion.equals(pathPart)) {
                    throw new HopException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.MutipleDifferentExpansions", (String[])new String[0]));
                }
                expansionList.add(mongoField);
                continue;
            }
            normalList.add(mongoField);
        }
        normalFields.clear();
        for (MongoField mongoField : normalList) {
            normalFields.add(mongoField);
        }
        if (!expansionList.isEmpty()) {
            ArrayList<MongoField> subFields = new ArrayList<MongoField>();
            for (MongoField mongoField : expansionList) {
                MongoField subField = new MongoField();
                subField.fieldName = mongoField.fieldName;
                Object path = mongoField.fieldPath;
                if (((String)path).charAt(((String)path).length() - 2) == '*') {
                    path = "dummy";
                } else {
                    path = ((String)path).substring(((String)path).lastIndexOf("[*]") + 3, ((String)path).length());
                    path = "$" + (String)path;
                }
                subField.fieldPath = path;
                subField.indexedValues = mongoField.indexedValues;
                subField.hopType = mongoField.hopType;
                subFields.add(subField);
            }
            MongoArrayExpansion mongoArrayExpansion = new MongoArrayExpansion(subFields);
            mongoArrayExpansion.expansionPath = expansion;
            mongoArrayExpansion.outputRowMeta = outputRowMeta;
            return mongoArrayExpansion;
        }
        return null;
    }

    public void init() throws HopException {
        if (this.userFields != null) {
            this.expansionHandler = MongoDbInputData.checkFieldPaths(this.userFields, this.outputRowMeta);
            for (MongoField f : this.userFields) {
                int outputIndex = this.outputRowMeta.indexOfValue(f.fieldName);
                f.init(outputIndex);
            }
            if (this.expansionHandler != null) {
                this.expansionHandler.init();
            }
        }
    }

    public Object[][] mongoDocumentToHop(DBObject mongoObj, IVariables variables) throws HopException {
        Object[][] result = null;
        if (this.expansionHandler != null) {
            this.expansionHandler.reset(variables);
            if (mongoObj instanceof BasicDBObject) {
                BasicDBObject basicDBObject = (BasicDBObject)mongoObj;
                result = this.expansionHandler.convertToHopValue(basicDBObject, variables);
            } else {
                result = this.expansionHandler.convertToHopValue((BasicDBList)mongoObj, variables);
            }
        } else {
            result = new Object[1][];
        }
        Object[] normalData = RowDataUtil.allocateRowData((int)this.outputRowMeta.size());
        for (MongoField f : this.userFields) {
            Object value = null;
            f.reset(variables);
            if (mongoObj instanceof BasicDBObject) {
                BasicDBObject basicDBObject = (BasicDBObject)mongoObj;
                value = f.convertToHopValue(basicDBObject);
            } else if (mongoObj instanceof BasicDBList) {
                BasicDBList basicDBList = (BasicDBList)mongoObj;
                value = f.convertToHopValue(basicDBList);
            }
            normalData[f.outputIndex] = value;
        }
        if (this.expansionHandler == null) {
            result[0] = normalData;
        } else {
            for (int i = 0; i < result.length; ++i) {
                Object[] row = result[i];
                for (MongoField f : this.userFields) {
                    row[f.outputIndex] = normalData[f.outputIndex];
                }
            }
        }
        return result;
    }

    public static String cleansePath(String path) {
        String cleanKey;
        String key;
        int index = path.indexOf("${");
        int endIndex = 0;
        String tempStr = path;
        while (index >= 0 && (endIndex += tempStr.indexOf("}")) > 0 && endIndex > (index += 2) + 1 && endIndex + 1 < (path = path.replace(key = path.substring(index, endIndex), cleanKey = key.replace('.', '_'))).length()) {
            tempStr = path.substring(endIndex + 1, path.length());
            index = tempStr.indexOf("${");
            if (index <= 0) continue;
            index += endIndex;
        }
        return path;
    }

    public void setMongoFields(List<MongoField> fields) {
        this.userFields = new ArrayList<MongoField>();
        for (MongoField f : fields) {
            this.userFields.add(f.copy());
        }
    }

    public static String indexedValsList(List<String> indexedVals) {
        StringBuffer temp = new StringBuffer();
        for (int i = 0; i < indexedVals.size(); ++i) {
            temp.append(indexedVals.get(i));
            if (i >= indexedVals.size() - 1) continue;
            temp.append(",");
        }
        return temp.toString();
    }

    public static List<String> indexedValsList(String indexedVals) {
        String[] parts = indexedVals.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String s : parts) {
            list.add(s.trim());
        }
        return list;
    }
}

