/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.gencsv;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.neo4j.transforms.gencsv.GenerateCsvMeta;
import org.apache.hop.neo4j.transforms.gencsv.UniquenessStrategy;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GenerateCsvDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = GenerateCsvMeta.class;
    private Text wTransformName;
    private CCombo wGraphField;
    private TextVar wBaseFolder;
    private CCombo wStrategy;
    private TextVar wFilesPrefix;
    private TextVar wFilenameField;
    private TextVar wFileTypeField;
    private GenerateCsvMeta input;

    public GenerateCsvDialog(Shell parent, IVariables variables, GenerateCsvMeta inputMetadata, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)inputMetadata, pipelineMeta);
        this.input = inputMetadata;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout shellLayout = new FormLayout();
        this.shell.setLayout((Layout)shellLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"GenerateCsvMeta.name", (String[])new String[0]));
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        ScrolledComposite wScrolledComposite = new ScrolledComposite((Composite)this.shell, 768);
        FormLayout scFormLayout = new FormLayout();
        wScrolledComposite.setLayout((Layout)scFormLayout);
        FormData fdSComposite = new FormData();
        fdSComposite.left = new FormAttachment(0, 0);
        fdSComposite.right = new FormAttachment(100, 0);
        fdSComposite.top = new FormAttachment(0, 0);
        fdSComposite.bottom = new FormAttachment(100, 0);
        wScrolledComposite.setLayoutData((Object)fdSComposite);
        Composite wComposite = new Composite((Composite)wScrolledComposite, 0);
        PropsUi.setLook((Widget)wComposite);
        FormData fdComposite = new FormData();
        fdComposite.left = new FormAttachment(0, 0);
        fdComposite.right = new FormAttachment(100, 0);
        fdComposite.top = new FormAttachment(0, 0);
        fdComposite.bottom = new FormAttachment(100, 0);
        wComposite.setLayoutData((Object)fdComposite);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        wComposite.setLayout((Layout)formLayout);
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wlTransformName = new Label(wComposite, 131072);
        wlTransformName.setText("Transform name");
        PropsUi.setLook((Widget)wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text(wComposite, 18436);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        String[] fieldnames = new String[]{};
        try {
            fieldnames = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta).getFieldNames();
        }
        catch (HopTransformException e2) {
            this.log.logError("error getting input field names: ", (Throwable)e2);
        }
        Label wlGraphField = new Label(wComposite, 131072);
        wlGraphField.setText("Graph field ");
        PropsUi.setLook((Widget)wlGraphField);
        FormData fdlGraphField = new FormData();
        fdlGraphField.left = new FormAttachment(0, 0);
        fdlGraphField.right = new FormAttachment(middle, -margin);
        fdlGraphField.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlGraphField.setLayoutData((Object)fdlGraphField);
        this.wGraphField = new CCombo(wComposite, 0x800800);
        this.wGraphField.setItems(fieldnames);
        PropsUi.setLook((Widget)this.wGraphField);
        FormData fdGraphField = new FormData();
        fdGraphField.left = new FormAttachment(middle, 0);
        fdGraphField.right = new FormAttachment(100, 0);
        fdGraphField.top = new FormAttachment((Control)wlGraphField, 0, 0x1000000);
        this.wGraphField.setLayoutData((Object)fdGraphField);
        lastControl = this.wGraphField;
        Label wlBaseFolder = new Label(wComposite, 131072);
        wlBaseFolder.setText("Base folder (below import/ folder) ");
        PropsUi.setLook((Widget)wlBaseFolder);
        FormData fdlBaseFolder = new FormData();
        fdlBaseFolder.left = new FormAttachment(0, 0);
        fdlBaseFolder.right = new FormAttachment(middle, -margin);
        fdlBaseFolder.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlBaseFolder.setLayoutData((Object)fdlBaseFolder);
        this.wBaseFolder = new TextVar(this.variables, wComposite, 18436);
        PropsUi.setLook((Widget)this.wBaseFolder);
        this.wBaseFolder.addModifyListener(lsMod);
        FormData fdBaseFolder = new FormData();
        fdBaseFolder.left = new FormAttachment(middle, 0);
        fdBaseFolder.right = new FormAttachment(100, 0);
        fdBaseFolder.top = new FormAttachment((Control)wlBaseFolder, 0, 0x1000000);
        this.wBaseFolder.setLayoutData((Object)fdBaseFolder);
        lastControl = this.wBaseFolder;
        Label wlFilesPrefix = new Label(wComposite, 131072);
        wlFilesPrefix.setText("CSV files prefix ");
        PropsUi.setLook((Widget)wlFilesPrefix);
        FormData fdlFilesPrefix = new FormData();
        fdlFilesPrefix.left = new FormAttachment(0, 0);
        fdlFilesPrefix.right = new FormAttachment(middle, -margin);
        fdlFilesPrefix.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlFilesPrefix.setLayoutData((Object)fdlFilesPrefix);
        this.wFilesPrefix = new TextVar(this.variables, wComposite, 18436);
        PropsUi.setLook((Widget)this.wFilesPrefix);
        this.wFilesPrefix.addModifyListener(lsMod);
        FormData fdFilesPrefix = new FormData();
        fdFilesPrefix.left = new FormAttachment(middle, 0);
        fdFilesPrefix.right = new FormAttachment(100, 0);
        fdFilesPrefix.top = new FormAttachment((Control)wlFilesPrefix, 0, 0x1000000);
        this.wFilesPrefix.setLayoutData((Object)fdFilesPrefix);
        lastControl = this.wFilesPrefix;
        Label wlStrategy = new Label(wComposite, 131072);
        wlStrategy.setText("Node/Relationships Uniqueness strategy ");
        PropsUi.setLook((Widget)wlStrategy);
        FormData fdlStrategy = new FormData();
        fdlStrategy.left = new FormAttachment(0, 0);
        fdlStrategy.right = new FormAttachment(middle, -margin);
        fdlStrategy.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlStrategy.setLayoutData((Object)fdlStrategy);
        this.wStrategy = new CCombo(wComposite, 0x800800);
        this.wStrategy.setItems(UniquenessStrategy.getNames());
        PropsUi.setLook((Widget)this.wStrategy);
        FormData fdStrategy = new FormData();
        fdStrategy.left = new FormAttachment(middle, 0);
        fdStrategy.right = new FormAttachment(100, 0);
        fdStrategy.top = new FormAttachment((Control)wlStrategy, 0, 0x1000000);
        this.wStrategy.setLayoutData((Object)fdStrategy);
        lastControl = this.wStrategy;
        Label wlFilenameField = new Label(wComposite, 131072);
        wlFilenameField.setText("Filename field) ");
        PropsUi.setLook((Widget)wlFilenameField);
        FormData fdlFilenameField = new FormData();
        fdlFilenameField.left = new FormAttachment(0, 0);
        fdlFilenameField.right = new FormAttachment(middle, -margin);
        fdlFilenameField.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlFilenameField.setLayoutData((Object)fdlFilenameField);
        this.wFilenameField = new TextVar(this.variables, wComposite, 18436);
        PropsUi.setLook((Widget)this.wFilenameField);
        this.wFilenameField.addModifyListener(lsMod);
        FormData fdFilenameField = new FormData();
        fdFilenameField.left = new FormAttachment(middle, 0);
        fdFilenameField.right = new FormAttachment(100, 0);
        fdFilenameField.top = new FormAttachment((Control)wlFilenameField, 0, 0x1000000);
        this.wFilenameField.setLayoutData((Object)fdFilenameField);
        lastControl = this.wFilenameField;
        Label wlFileTypeField = new Label(wComposite, 131072);
        wlFileTypeField.setText("File type field ");
        PropsUi.setLook((Widget)wlFileTypeField);
        FormData fdlFileTypeField = new FormData();
        fdlFileTypeField.left = new FormAttachment(0, 0);
        fdlFileTypeField.right = new FormAttachment(middle, -margin);
        fdlFileTypeField.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlFileTypeField.setLayoutData((Object)fdlFileTypeField);
        this.wFileTypeField = new TextVar(this.variables, wComposite, 18436);
        PropsUi.setLook((Widget)this.wFileTypeField);
        this.wFileTypeField.addModifyListener(lsMod);
        FormData fdFileTypeField = new FormData();
        fdFileTypeField.left = new FormAttachment(middle, 0);
        fdFileTypeField.right = new FormAttachment(100, 0);
        fdFileTypeField.top = new FormAttachment((Control)wlFileTypeField, 0, 0x1000000);
        this.wFileTypeField.setLayoutData((Object)fdFileTypeField);
        lastControl = this.wFileTypeField;
        this.wOk = new Button(wComposite, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button(wComposite, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)lastControl);
        wComposite.pack();
        Rectangle bounds = wComposite.getBounds();
        wScrolledComposite.setContent((Control)wComposite);
        wScrolledComposite.setExpandHorizontal(true);
        wScrolledComposite.setExpandVertical(true);
        wScrolledComposite.setMinWidth(bounds.width);
        wScrolledComposite.setMinHeight(bounds.height);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    public void getData() {
        this.wTransformName.setText(Const.NVL((String)this.transformName, (String)""));
        this.wGraphField.setText(Const.NVL((String)this.input.getGraphFieldName(), (String)""));
        this.wBaseFolder.setText(Const.NVL((String)this.input.getBaseFolder(), (String)""));
        if (this.input.getUniquenessStrategy() != null) {
            int idx = Const.indexOfString((String)this.input.getUniquenessStrategy().name(), (String[])UniquenessStrategy.getNames());
            this.wStrategy.select(idx);
        }
        this.wFilesPrefix.setText(Const.NVL((String)this.input.getFilesPrefix(), (String)""));
        this.wFilenameField.setText(Const.NVL((String)this.input.getFilenameField(), (String)""));
        this.wFileTypeField.setText(Const.NVL((String)this.input.getFileTypeField(), (String)""));
    }

    private void ok() {
        if (StringUtils.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(GenerateCsvMeta meta) {
        meta.setGraphFieldName(this.wGraphField.getText());
        meta.setBaseFolder(this.wBaseFolder.getText());
        meta.setUniquenessStrategy(UniquenessStrategy.getStrategyFromName(this.wStrategy.getText()));
        meta.setFilesPrefix(this.wFilesPrefix.getText());
        meta.setFilenameField(this.wFilenameField.getText());
        meta.setFileTypeField(this.wFileTypeField.getText());
    }
}

