/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.event;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import org.gridkit.jvmtool.event.Event;
import org.gridkit.jvmtool.event.EventMorpher;
import org.gridkit.jvmtool.event.EventReader;
import org.gridkit.jvmtool.event.MorphingEventReader;
import org.gridkit.jvmtool.event.SimpleErrorEvent;
import org.gridkit.jvmtool.event.SingleEventReader;

public abstract class ChainedEventReader<T extends Event>
implements EventReader<T> {
    private boolean init;
    private EventReader<T> current;

    public static <T extends Event> EventReader<T> chain(final EventReader<T> ... readers) {
        return new ChainedEventReader<T>(){
            int next;

            @Override
            protected EventReader<T> produceNext() {
                return this.next < readers.length ? readers[this.next++] : null;
            }
        };
    }

    public static <T extends Event> EventReader<T> chain(final EventReader<T> reader, final Callable<T> producer) {
        return new ChainedEventReader<T>(){
            boolean first;
            boolean done;

            @Override
            protected EventReader<T> produceNext() {
                if (!this.first) {
                    this.first = true;
                    return reader;
                }
                if (this.done) {
                    return null;
                }
                this.done = true;
                try {
                    return (EventReader)producer.call();
                }
                catch (Exception e) {
                    return new SingleEventReader<SimpleErrorEvent>(new SimpleErrorEvent(e));
                }
            }
        };
    }

    @Override
    public <M extends Event> EventReader<M> morph(EventMorpher<T, M> morpher) {
        return MorphingEventReader.morph(this, morpher);
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (!this.init) {
            this.init = true;
            this.current = this.produceNext();
        }
        if (this.current == null) {
            return false;
        }
        do {
            if (this.current.hasNext()) {
                return true;
            }
            this.current.dispose();
            this.current = this.produceNext();
        } while (this.current != null);
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (T)((Event)this.current.next());
    }

    @Override
    public T peekNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.current.peekNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
        if (this.current != null) {
            this.current.dispose();
        }
    }

    protected abstract EventReader<T> produceNext();
}

