/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.evalfilesmetrics;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.w3c.dom.Node;

@Action(id="EVAL_FILES_METRICS", name="i18n::ActionEvalFilesMetrics.Name", description="i18n::ActionEvalFilesMetrics.Description", image="EvalFilesMetrics.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Conditions", keywords={"i18n::ActionEvalFilesMetrics.keyword"}, documentationUrl="/workflow/actions/evalfilesmetrics.html")
public class ActionEvalFilesMetrics
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionEvalFilesMetrics.class;
    public static final int SUCCESS_NUMBER_CONDITION_EQUAL = 0;
    public static final int SUCCESS_NUMBER_CONDITION_DIFFERENT = 1;
    public static final int SUCCESS_NUMBER_CONDITION_SMALLER = 2;
    public static final int SUCCESS_NUMBER_CONDITION_SMALLER_EQUAL = 3;
    public static final int SUCCESS_NUMBER_CONDITION_GREATER = 4;
    public static final int SUCCESS_NUMBER_CONDITION_GREATER_EQUAL = 5;
    public static final int SUCCESS_NUMBER_CONDITION_BETWEEN = 6;
    public static final int SUCCESS_NUMBER_CONDITION_IN_LIST = 7;
    public static final int SUCCESS_NUMBER_CONDITION_NOT_IN_LIST = 8;
    private static final String CONST_SPACE = "          ";
    private static final String CONST_SPACE_SHORT = "      ";
    private static final String CONST_CAN_NOT_FIND_FIELD = "ActionEvalFilesMetrics.Error.CanNotFindField";
    private static final String CONST_COMPARE_WITH_VALUE = "ActionEvalFilesMetrics.Log.CompareWithValue";
    public static final String[] successNumberConditionCode = new String[]{"equal", "different", "smaller", "smallequal", "greater", "greaterequal", "between", "inlist", "notinlist"};
    public static final String[] successNumberConditionDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.SuccessWhenEqual.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.SuccessWhenDifferent.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.SuccessWhenSmallThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.SuccessWhenSmallOrEqualThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.SuccessWhenGreaterThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.SuccessWhenGreaterOrEqualThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.SuccessBetween.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.SuccessWhenInList.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.SuccessWhenNotInList.Label", (String[])new String[0])};
    public static final BigDecimal ONE = new BigDecimal(1);
    public static final String[] IncludeSubFoldersDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] IncludeSubFoldersCodes = new String[]{"N", "Y"};
    private static final String YES = "Y";
    private static final String NO = "N";
    public static final String[] scaleDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Bytes.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.KBytes.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.MBytes.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.GBytes.Label", (String[])new String[0])};
    public static final String[] scaleCodes = new String[]{"bytes", "kbytes", "mbytes", "gbytes"};
    public static final int SCALE_BYTES = 0;
    public static final int SCALE_KBYTES = 1;
    public static final int SCALE_MBYTES = 2;
    public static final int SCALE_GBYTES = 3;
    public int scale = 0;
    public static final String[] SourceFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.SourceFiles.Files.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.SourceFiles.FilenamesResult.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.SourceFiles.PreviousResult.Label", (String[])new String[0])};
    public static final String[] SourceFilesCodes = new String[]{"files", "filenamesresult", "previousresult"};
    public static final int SOURCE_FILES_FILES = 0;
    public static final int SOURCE_FILES_FILENAMES_RESULT = 1;
    public static final int SOURCE_FILES_PREVIOUS_RESULT = 2;
    public int sourceFiles = 0;
    public static final String[] EvaluationTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.EvaluationType.Size.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.EvaluationType.Count.Label", (String[])new String[0])};
    public static final String[] EvaluationTypeCodes = new String[]{"size", "count"};
    public static final int EVALUATE_TYPE_SIZE = 0;
    public static final int EVALUATE_TYPE_COUNT = 1;
    public int evaluationType = 0;
    private String comparevalue;
    private String minvalue;
    private String maxvalue;
    private int successConditionType = 4;
    private String resultFilenamesWildcard = null;
    public boolean argFromPrevious;
    private String[] sourceFileFolder = null;
    private String[] sourceWildcard = null;
    private String[] sourceIncludeSubfolders = null;
    private BigDecimal evaluationValue;
    private BigDecimal filesCount;
    private long nrErrors;
    private String resultFieldFile = null;
    private String resultFieldWildcard = null;
    private String resultFieldIncludesubFolders = null;
    private BigDecimal compareValue;
    private BigDecimal minValue;
    private BigDecimal maxValue;

    public ActionEvalFilesMetrics(String n) {
        super(n, "");
    }

    public ActionEvalFilesMetrics() {
        this("");
    }

    public void allocate(int nrFields) {
        this.sourceFileFolder = new String[nrFields];
        this.sourceWildcard = new String[nrFields];
        this.sourceIncludeSubfolders = new String[nrFields];
    }

    public Object clone() {
        ActionEvalFilesMetrics je = (ActionEvalFilesMetrics)super.clone();
        if (this.sourceFileFolder != null) {
            int nrFields = this.sourceFileFolder.length;
            je.allocate(nrFields);
            System.arraycopy(this.sourceFileFolder, 0, je.sourceFileFolder, 0, nrFields);
            System.arraycopy(this.sourceWildcard, 0, je.sourceWildcard, 0, nrFields);
            System.arraycopy(this.sourceIncludeSubfolders, 0, je.sourceIncludeSubfolders, 0, nrFields);
        }
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append(super.getXml());
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"result_filenames_wildcard", (String)this.resultFilenamesWildcard));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"Result_field_file", (String)this.resultFieldFile));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"Result_field_wildcard", (String)this.resultFieldWildcard));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"Result_field_includesubfolders", (String)this.resultFieldIncludesubFolders));
        retval.append("      <fields>").append(Const.CR);
        if (this.sourceFileFolder != null) {
            for (int i = 0; i < this.sourceFileFolder.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"source_filefolder", (String)this.sourceFileFolder[i]));
                retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"wildcard", (String)this.sourceWildcard[i]));
                retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"include_subFolders", (String)this.sourceIncludeSubfolders[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"comparevalue", (String)this.comparevalue));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"minvalue", (String)this.minvalue));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"maxvalue", (String)this.maxvalue));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"successnumbercondition", (String)ActionEvalFilesMetrics.getSuccessNumberConditionCode(this.successConditionType)));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"source_files", (String)ActionEvalFilesMetrics.getSourceFilesCode(this.sourceFiles)));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"evaluation_type", (String)ActionEvalFilesMetrics.getEvaluationTypeCode(this.evaluationType)));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"scale", (String)ActionEvalFilesMetrics.getScaleCode(this.scale)));
        return retval.toString();
    }

    public static String getIncludeSubFolders(String tt) {
        if (tt == null) {
            return IncludeSubFoldersCodes[0];
        }
        if (tt.equals(IncludeSubFoldersDesc[1])) {
            return IncludeSubFoldersCodes[1];
        }
        return IncludeSubFoldersCodes[0];
    }

    public static String getIncludeSubFoldersDesc(String tt) {
        if (tt == null) {
            return IncludeSubFoldersDesc[0];
        }
        if (tt.equals(IncludeSubFoldersCodes[1])) {
            return IncludeSubFoldersDesc[1];
        }
        return IncludeSubFoldersDesc[0];
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            Node fields = XmlHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.sourceFileFolder[i] = XmlHandler.getTagValue((Node)fnode, (String)"source_filefolder");
                this.sourceWildcard[i] = XmlHandler.getTagValue((Node)fnode, (String)"wildcard");
                this.sourceIncludeSubfolders[i] = XmlHandler.getTagValue((Node)fnode, (String)"include_subFolders");
            }
            this.resultFilenamesWildcard = XmlHandler.getTagValue((Node)entrynode, (String)"result_filenames_wildcard");
            this.resultFieldFile = XmlHandler.getTagValue((Node)entrynode, (String)"result_field_file");
            this.resultFieldWildcard = XmlHandler.getTagValue((Node)entrynode, (String)"result_field_wildcard");
            this.resultFieldIncludesubFolders = XmlHandler.getTagValue((Node)entrynode, (String)"result_field_includesubfolders");
            this.comparevalue = XmlHandler.getTagValue((Node)entrynode, (String)"comparevalue");
            this.minvalue = XmlHandler.getTagValue((Node)entrynode, (String)"minvalue");
            this.maxvalue = XmlHandler.getTagValue((Node)entrynode, (String)"maxvalue");
            this.successConditionType = ActionEvalFilesMetrics.getSuccessNumberConditionByCode(Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"successnumbercondition"), (String)""));
            this.sourceFiles = ActionEvalFilesMetrics.getSourceFilesByCode(Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"source_files"), (String)""));
            this.evaluationType = ActionEvalFilesMetrics.getEvaluationTypeByCode(Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"evaluation_type"), (String)""));
            this.scale = ActionEvalFilesMetrics.getScaleByCode(Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"scale"), (String)""));
        }
        catch (HopXmlException xe) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Error.Exception.UnableLoadXML", (String[])new String[0]), (Throwable)xe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) throws HopException {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        List rows = result.getRows();
        RowMetaAndData resultRow = null;
        try {
            this.initMetrics();
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Error.Init", (String[])new String[]{e.toString()}));
            return result;
        }
        String[] vSourceFileFolder = this.sourceFileFolder;
        String[] vwildcard = this.sourceWildcard;
        String[] vincludeSubFolders = this.sourceIncludeSubfolders;
        switch (this.getSourceFiles()) {
            case 2: {
                String realResultFieldFile = this.resolve(this.getResultFieldFile());
                String realResultFieldWildcard = this.resolve(this.getResultFieldWildcard());
                String realResultFieldIncluseSubfolders = this.resolve(this.getResultFieldIncludeSubfolders());
                int indexOfResultFieldFile = -1;
                if (Utils.isEmpty((CharSequence)realResultFieldFile)) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Error.ResultFieldsFileMissing", (String[])new String[0]));
                    return result;
                }
                int indexOfResultFieldWildcard = -1;
                int indexOfResultFieldIncludeSubfolders = -1;
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Log.ArgFromPrevious.Found", (String[])new String[]{"" + (rows != null ? rows.size() : 0)}));
                }
                if (rows == null || rows.isEmpty()) break;
                RowMetaAndData firstRow = (RowMetaAndData)rows.get(0);
                indexOfResultFieldFile = firstRow.getRowMeta().indexOfValue(realResultFieldFile);
                if (indexOfResultFieldFile == -1) {
                    this.logError(BaseMessages.getString(PKG, (String)CONST_CAN_NOT_FIND_FIELD, (String[])new String[]{realResultFieldFile}));
                    return result;
                }
                if (!Utils.isEmpty((CharSequence)realResultFieldWildcard) && (indexOfResultFieldWildcard = firstRow.getRowMeta().indexOfValue(realResultFieldWildcard)) == -1) {
                    this.logError(BaseMessages.getString(PKG, (String)CONST_CAN_NOT_FIND_FIELD, (String[])new String[]{realResultFieldWildcard}));
                    return result;
                }
                if (!Utils.isEmpty((CharSequence)realResultFieldIncluseSubfolders) && (indexOfResultFieldIncludeSubfolders = firstRow.getRowMeta().indexOfValue(realResultFieldIncluseSubfolders)) == -1) {
                    this.logError(BaseMessages.getString(PKG, (String)CONST_CAN_NOT_FIND_FIELD, (String[])new String[]{realResultFieldIncluseSubfolders}));
                    return result;
                }
                for (int iteration = 0; iteration < rows.size() && !this.parentWorkflow.isStopped(); ++iteration) {
                    resultRow = (RowMetaAndData)rows.get(iteration);
                    String vSourceFileFolderPrevious = resultRow.getString(indexOfResultFieldFile, null);
                    String vWildcardPrevious = null;
                    if (indexOfResultFieldWildcard > -1) {
                        vWildcardPrevious = resultRow.getString(indexOfResultFieldWildcard, null);
                    }
                    String vincludeSubFoldersPrevious = NO;
                    if (indexOfResultFieldIncludeSubfolders > -1) {
                        vincludeSubFoldersPrevious = resultRow.getString(indexOfResultFieldIncludeSubfolders, NO);
                    }
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Log.ProcessingRow", (String[])new String[]{vSourceFileFolderPrevious, vWildcardPrevious}));
                    }
                    this.processFileFolder(vSourceFileFolderPrevious, vWildcardPrevious, vincludeSubFoldersPrevious, (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, result);
                }
                break;
            }
            case 1: {
                List resultFiles = result.getResultFilesList();
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Log.ResultFilenames.Found", (String[])new String[]{"" + (resultFiles != null ? resultFiles.size() : 0)}));
                }
                if (resultFiles == null || resultFiles.isEmpty()) break;
                Pattern pattern = null;
                String realPattern = this.resolve(this.getResultFilenamesWildcard());
                if (!Utils.isEmpty((CharSequence)realPattern)) {
                    pattern = Pattern.compile(realPattern);
                }
                Iterator it = resultFiles.iterator();
                while (it.hasNext() && !this.parentWorkflow.isStopped()) {
                    ResultFile resultFile = (ResultFile)it.next();
                    FileObject file = resultFile.getFile();
                    try {
                        if (file == null || !file.exists()) continue;
                        boolean getIt = true;
                        if (pattern != null) {
                            Matcher matcher = pattern.matcher(file.getName().getBaseName());
                            getIt = matcher.matches();
                        }
                        if (!getIt) continue;
                        this.getFileSize(file, result, (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow);
                    }
                    catch (Exception e) {
                        this.incrementErrors();
                        this.logError(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Error.GettingFileFromResultFilenames", (String[])new String[]{file.toString(), e.toString()}));
                    }
                    finally {
                        if (file == null) continue;
                        try {
                            file.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                break;
            }
            default: {
                if (vSourceFileFolder != null && vSourceFileFolder.length > 0) {
                    for (int i = 0; i < vSourceFileFolder.length && !this.parentWorkflow.isStopped(); ++i) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Log.ProcessingRow", (String[])new String[]{vSourceFileFolder[i], vwildcard[i]}));
                        }
                        this.processFileFolder(vSourceFileFolder[i], vwildcard[i], vincludeSubFolders[i], (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, result);
                    }
                    break;
                }
                this.logError(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Error.FilesGridEmpty", (String[])new String[0]));
                return result;
            }
        }
        result.setResult(this.isSuccess());
        result.setNrErrors(this.getNrError());
        this.displayResults();
        return result;
    }

    private void displayResults() {
        if (this.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Log.Info.FilesCount", (String[])new String[]{String.valueOf(this.getFilesCount())}));
            if (this.evaluationType == 0) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Log.Info.FilesSize", (String[])new String[]{String.valueOf(this.getEvaluationValue())}));
            }
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Log.Info.NrErrors", (String[])new String[]{String.valueOf(this.getNrError())}));
            this.logDetailed("=======================================");
        }
    }

    private long getNrError() {
        return this.nrErrors;
    }

    private BigDecimal getEvaluationValue() {
        return this.evaluationValue;
    }

    private BigDecimal getFilesCount() {
        return this.filesCount;
    }

    public int getSuccessConditionType() {
        return this.successConditionType;
    }

    public void setSuccessConditionType(int successConditionType) {
        this.successConditionType = successConditionType;
    }

    private boolean isSuccess() {
        boolean retval = false;
        switch (this.successConditionType) {
            case 0: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)CONST_COMPARE_WITH_VALUE, (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.compareValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.compareValue) == 0;
                break;
            }
            case 1: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)CONST_COMPARE_WITH_VALUE, (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.compareValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.compareValue) != 0;
                break;
            }
            case 2: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)CONST_COMPARE_WITH_VALUE, (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.compareValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.compareValue) < 0;
                break;
            }
            case 3: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)CONST_COMPARE_WITH_VALUE, (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.compareValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.compareValue) <= 0;
                break;
            }
            case 4: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)CONST_COMPARE_WITH_VALUE, (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.compareValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.compareValue) > 0;
                break;
            }
            case 5: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)CONST_COMPARE_WITH_VALUE, (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.compareValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.compareValue) >= 0;
                break;
            }
            case 6: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Log.CompareWithValues", (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.minValue), String.valueOf(this.maxValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.minValue) >= 0 && this.getEvaluationValue().compareTo(this.maxValue) <= 0;
                break;
            }
        }
        return retval;
    }

    private void initMetrics() {
        this.evaluationValue = new BigDecimal(0);
        this.filesCount = new BigDecimal(0);
        this.nrErrors = 0L;
        if (this.successConditionType == 6) {
            this.minValue = new BigDecimal(this.resolve(this.getMinValue()));
            this.maxValue = new BigDecimal(this.resolve(this.getMaxValue()));
        } else {
            this.compareValue = new BigDecimal(this.resolve(this.getCompareValue()));
        }
        if (this.evaluationType == 0) {
            int multyply = 1;
            switch (this.getScale()) {
                case 1: {
                    multyply = 1024;
                    break;
                }
                case 2: {
                    multyply = 0x100000;
                    break;
                }
                case 3: {
                    multyply = 0x40000000;
                    break;
                }
            }
            if (this.successConditionType == 6) {
                this.minValue = this.minValue.multiply(BigDecimal.valueOf(multyply));
                this.maxValue = this.maxValue.multiply(BigDecimal.valueOf(multyply));
            } else {
                this.compareValue = this.compareValue.multiply(BigDecimal.valueOf(multyply));
            }
        }
        this.argFromPrevious = this.getSourceFiles() == 2;
    }

    private void incrementErrors() {
        ++this.nrErrors;
    }

    public int getSourceFiles() {
        return this.sourceFiles;
    }

    private void incrementFilesCount() {
        this.filesCount = this.filesCount.add(ONE);
    }

    public String[] getSourceFileFolder() {
        return this.sourceFileFolder;
    }

    public void setSourceFileFolder(String[] sourceFileFolder) {
        this.sourceFileFolder = sourceFileFolder;
    }

    public String[] getSourceWildcard() {
        return this.sourceWildcard;
    }

    public void setSourceWildcard(String[] sourceWildcard) {
        this.sourceWildcard = sourceWildcard;
    }

    public String[] getSourceIncludeSubfolders() {
        return this.sourceIncludeSubfolders;
    }

    public void setSourceIncludeSubfolders(String[] sourceIncludeSubfolders) {
        this.sourceIncludeSubfolders = sourceIncludeSubfolders;
    }

    public void setSourceFiles(int sourceFiles) {
        this.sourceFiles = sourceFiles;
    }

    public String getResultFieldFile() {
        return this.resultFieldFile;
    }

    public void setResultFieldFile(String field) {
        this.resultFieldFile = field;
    }

    public String getResultFieldWildcard() {
        return this.resultFieldWildcard;
    }

    public void setResultFieldWildcard(String field) {
        this.resultFieldWildcard = field;
    }

    public String getResultFieldIncludeSubfolders() {
        return this.resultFieldIncludesubFolders;
    }

    public void setResultFieldIncludeSubfolders(String field) {
        this.resultFieldIncludesubFolders = field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFileFolder(String sourcefilefoldername, String wildcard, String includeSubfolders, IWorkflowEngine<WorkflowMeta> parentWorkflow, Result result) {
        FileObject sourcefilefolder = null;
        FileObject currentFile = null;
        String realSourceFilefoldername = this.resolve(sourcefilefoldername);
        if (Utils.isEmpty((CharSequence)realSourceFilefoldername)) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.log.FileFolderEmpty", (String[])new String[0]));
            this.incrementErrors();
            return;
        }
        String realWildcard = this.resolve(wildcard);
        final boolean includeSubFolders = YES.equalsIgnoreCase(includeSubfolders);
        try {
            sourcefilefolder = HopVfs.getFileObject((String)realSourceFilefoldername, (IVariables)this.getVariables());
            if (sourcefilefolder.exists()) {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Log.FileExists", (String[])new String[]{sourcefilefolder.toString()}));
                }
                if (sourcefilefolder.getType() == FileType.FILE) {
                    this.getFileSize(sourcefilefolder, result, parentWorkflow);
                } else if (sourcefilefolder.getType() == FileType.FOLDER) {
                    FileObject[] fileObjects = sourcefilefolder.findFiles((FileSelector)new AllFileSelector(){

                        public boolean traverseDescendents(FileSelectInfo info) {
                            return info.getDepth() == 0 || includeSubFolders;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public boolean includeFile(FileSelectInfo info) {
                            block18: {
                                boolean bl;
                                FileObject fileObject = info.getFile();
                                try {
                                    if (fileObject == null) {
                                        boolean bl2 = false;
                                        return bl2;
                                    }
                                    if (fileObject.getType() == FileType.FILE) break block18;
                                    bl = false;
                                }
                                catch (Exception ex) {
                                    boolean bl3 = false;
                                    return bl3;
                                }
                                finally {
                                    if (fileObject != null) {
                                        try {
                                            fileObject.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                }
                                return bl;
                            }
                            return true;
                        }
                    });
                    if (fileObjects != null) {
                        for (int j = 0; j < fileObjects.length && !parentWorkflow.isStopped(); ++j) {
                            currentFile = fileObjects[j];
                            if (!currentFile.getParent().toString().equals(sourcefilefolder.toString())) {
                                if (!includeSubFolders || !this.getFileWildcard(currentFile.getName().getBaseName(), realWildcard)) continue;
                                this.getFileSize(currentFile, result, parentWorkflow);
                                continue;
                            }
                            if (!this.getFileWildcard(currentFile.getName().getBaseName(), realWildcard)) continue;
                            this.getFileSize(currentFile, result, parentWorkflow);
                        }
                    }
                } else {
                    this.incrementErrors();
                    this.logError(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Error.UnknowFileFormat", (String[])new String[]{sourcefilefolder.toString()}));
                }
            } else {
                this.incrementErrors();
                this.logError(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Error.SourceFileNotExists", (String[])new String[]{realSourceFilefoldername}));
            }
        }
        catch (Exception e) {
            this.incrementErrors();
            this.logError(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Error.Exception.Processing", (String[])new String[]{realSourceFilefoldername, e.getMessage()}));
        }
        finally {
            if (sourcefilefolder != null) {
                try {
                    sourcefilefolder.close();
                }
                catch (IOException iOException) {}
            }
            if (currentFile != null) {
                try {
                    currentFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void getFileSize(FileObject file, Result result, IWorkflowEngine<WorkflowMeta> parentWorkflow) {
        try {
            this.incrementFilesCount();
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Log.GetFile", (String[])new String[]{file.toString(), String.valueOf(this.getFilesCount())}));
            }
            switch (this.evaluationType) {
                case 0: {
                    BigDecimal fileSize = BigDecimal.valueOf(file.getContent().getSize());
                    this.evaluationValue = this.evaluationValue.add(fileSize);
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Log.AddedFileSize", (String[])new String[]{String.valueOf(fileSize), file.toString()}));
                    }
                    break;
                }
                default: {
                    this.evaluationValue = this.evaluationValue.add(ONE);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.incrementErrors();
            this.logError(BaseMessages.getString(PKG, (String)"ActionEvalFilesMetrics.Error.GettingFileSize", (String[])new String[]{file.toString(), e.toString()}));
        }
    }

    private boolean getFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Utils.isEmpty((CharSequence)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public void setMinValue(String minvalue) {
        this.minvalue = minvalue;
    }

    public String getMinValue() {
        return this.minvalue;
    }

    public void setCompareValue(String comparevalue) {
        this.comparevalue = comparevalue;
    }

    public String getCompareValue() {
        return this.comparevalue;
    }

    public void setResultFilenamesWildcard(String resultwildcard) {
        this.resultFilenamesWildcard = resultwildcard;
    }

    public String getResultFilenamesWildcard() {
        return this.resultFilenamesWildcard;
    }

    public void setMaxValue(String maxvalue) {
        this.maxvalue = maxvalue;
    }

    public String getMaxValue() {
        return this.maxvalue;
    }

    public static String getSuccessNumberConditionCode(int i) {
        if (i < 0 || i >= successNumberConditionCode.length) {
            return successNumberConditionCode[0];
        }
        return successNumberConditionCode[i];
    }

    public static int getSuccessNumberConditionByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successNumberConditionCode.length; ++i) {
            if (!successNumberConditionCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static String getSuccessNumberConditionDesc(int i) {
        if (i < 0 || i >= successNumberConditionDesc.length) {
            return successNumberConditionDesc[0];
        }
        return successNumberConditionDesc[i];
    }

    public static int getSuccessNumberConditionByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successNumberConditionDesc.length; ++i) {
            if (!successNumberConditionDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ActionEvalFilesMetrics.getSuccessNumberByCode(tt);
    }

    private static int getSuccessNumberByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successNumberConditionCode.length; ++i) {
            if (!successNumberConditionCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static int getScaleByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < scaleDesc.length; ++i) {
            if (!scaleDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ActionEvalFilesMetrics.getScaleByCode(tt);
    }

    public static int getSourceFilesByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < SourceFilesDesc.length; ++i) {
            if (!SourceFilesDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ActionEvalFilesMetrics.getSourceFilesByCode(tt);
    }

    public static int getEvaluationTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < EvaluationTypeDesc.length; ++i) {
            if (!EvaluationTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ActionEvalFilesMetrics.getEvaluationTypeByCode(tt);
    }

    private static int getScaleByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < scaleCodes.length; ++i) {
            if (!scaleCodes[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getSourceFilesByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < SourceFilesCodes.length; ++i) {
            if (!SourceFilesCodes[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getEvaluationTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < EvaluationTypeCodes.length; ++i) {
            if (!EvaluationTypeCodes[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static String getScaleDesc(int i) {
        if (i < 0 || i >= scaleDesc.length) {
            return scaleDesc[0];
        }
        return scaleDesc[i];
    }

    public static String getEvaluationTypeDesc(int i) {
        if (i < 0 || i >= EvaluationTypeDesc.length) {
            return EvaluationTypeDesc[0];
        }
        return EvaluationTypeDesc[i];
    }

    public static String getSourceFilesDesc(int i) {
        if (i < 0 || i >= SourceFilesDesc.length) {
            return SourceFilesDesc[0];
        }
        return SourceFilesDesc[i];
    }

    public static String getScaleCode(int i) {
        if (i < 0 || i >= scaleCodes.length) {
            return scaleCodes[0];
        }
        return scaleCodes[i];
    }

    public static String getSourceFilesCode(int i) {
        if (i < 0 || i >= SourceFilesCodes.length) {
            return SourceFilesCodes[0];
        }
        return SourceFilesCodes[i];
    }

    public static String getEvaluationTypeCode(int i) {
        if (i < 0 || i >= EvaluationTypeCodes.length) {
            return EvaluationTypeCodes[0];
        }
        return EvaluationTypeCodes[i];
    }

    public int getScale() {
        return this.scale;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        boolean res = ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "arguments", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileExistsValidator()});
        for (int i = 0; i < this.sourceFileFolder.length; ++i) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    public boolean isEvaluation() {
        return true;
    }
}

