/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.TagObject;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class PathToTags {
    @Nonnull
    protected final String path;
    @Nonnull
    protected final List<TagObject> tags;

    public PathToTags(@Nonnull String path, @Nonnull List<TagObject> tags) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("/(.|[\\r\\n])*", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        if (tags == null) {
            throw new IllegalArgumentException("Required value for 'tags' is null");
        }
        for (TagObject x : tags) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'tags' is null");
        }
        this.tags = tags;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public List<TagObject> getTags() {
        return this.tags;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.tags});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            PathToTags other = (PathToTags)obj;
            return !(this.path != other.path && !this.path.equals(other.path) || this.tags != other.tags && !this.tags.equals(other.tags));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<PathToTags> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PathToTags value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("path");
            StoneSerializers.string().serialize(value.path, g);
            g.writeFieldName("tags");
            StoneSerializers.list(TagObject.Serializer.INSTANCE).serialize(value.tags, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public PathToTags deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<TagObject> f_tags;
            String f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_tags = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("tags".equals(field)) {
                        f_tags = StoneSerializers.list(TagObject.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
                if (f_tags == null) {
                    throw new JsonParseException(p, "Required field \"tags\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            PathToTags value = new PathToTags(f_path, f_tags);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

