/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.html2text;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.html2text.Html2Text;
import org.apache.hop.pipeline.transforms.html2text.Html2TextData;
import org.w3c.dom.Node;

@Transform(id="Html2Text", image="html2text.svg", name="i18n::BaseTransform.TypeLongDesc.Html2Text", description="i18n::BaseTransform.TypeTooltipDesc.Html2Text", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", documentationUrl="/pipeline/transforms/html2text.html")
public class Html2TextMeta
extends BaseTransformMeta<Html2Text, Html2TextData> {
    private static final Class<?> PKG = Html2TextMeta.class;
    private String htmlField;
    private String outputField = "html2text_output";
    private String safelistType = SafelistType.basic.getCode();
    private boolean parallelism = false;
    private boolean normalisedText = false;
    private boolean cleanOnly = false;

    public void setDefault() {
        this.normalisedText = false;
        this.parallelism = false;
        this.cleanOnly = false;
        this.outputField = "html2text_output";
        this.safelistType = SafelistType.basic.getCode();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.htmlField = XmlHandler.getTagValue((Node)transformNode, (String)"htmlField");
            this.outputField = XmlHandler.getTagValue((Node)transformNode, (String)"outputField");
            this.safelistType = XmlHandler.getTagValue((Node)transformNode, (String)"safelistType");
            this.cleanOnly = StringUtils.equalsIgnoreCase((CharSequence)"Y", (CharSequence)XmlHandler.getTagValue((Node)transformNode, (String)"cleanOnly"));
            this.parallelism = StringUtils.equalsIgnoreCase((CharSequence)"Y", (CharSequence)XmlHandler.getTagValue((Node)transformNode, (String)"parallelism"));
            this.normalisedText = StringUtils.equalsIgnoreCase((CharSequence)"Y", (CharSequence)XmlHandler.getTagValue((Node)transformNode, (String)"normalisedText"));
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"Html2TextMeta.Exception.UnableToReadTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        this.valueMetaString(r, name, this.outputField);
    }

    private void valueMetaString(IRowMeta r, String name, String metaName) {
        ValueMetaString sText = new ValueMetaString(metaName);
        sText.setOrigin(name);
        r.addValueMeta((IValueMeta)sText);
    }

    private void valueMetaBoolean(IRowMeta r, String name, String metaName) {
        ValueMetaBoolean sText = new ValueMetaBoolean(metaName);
        sText.setOrigin(name);
        r.addValueMeta((IValueMeta)sText);
    }

    private void valueMetaInteger(IRowMeta r, String name, String metaName) {
        ValueMetaInteger sText = new ValueMetaInteger(metaName);
        sText.setOrigin(name);
        r.addValueMeta((IValueMeta)sText);
    }

    public String getXml() {
        return "    " + XmlHandler.addTagValue((String)"htmlField", (String)this.htmlField) + "    " + XmlHandler.addTagValue((String)"outputField", (String)this.outputField) + "    " + XmlHandler.addTagValue((String)"safelistType", (String)this.safelistType) + "    " + XmlHandler.addTagValue((String)"cleanOnly", (boolean)this.cleanOnly) + "    " + XmlHandler.addTagValue((String)"normalisedText", (boolean)this.normalisedText) + "    " + XmlHandler.addTagValue((String)"parallelism", (boolean)this.parallelism);
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = Utils.isEmpty((CharSequence)this.htmlField) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"Html2TextMeta.CheckResult.HtmlFieldMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"Html2TextMeta.CheckResult.HtmlFieldOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = Utils.isEmpty((CharSequence)this.outputField) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"Html2TextMeta.CheckResult.OutputFieldMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"Html2TextMeta.CheckResult.OutputFieldOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"Html2TextMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"Html2TextMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String getHtmlField() {
        return this.htmlField;
    }

    public void setHtmlField(String htmlField) {
        this.htmlField = htmlField;
    }

    public String getOutputField() {
        return this.outputField;
    }

    public void setOutputField(String outputField) {
        this.outputField = outputField;
    }

    public boolean isParallelism() {
        return this.parallelism;
    }

    public void setParallelism(boolean parallelism) {
        this.parallelism = parallelism;
    }

    public String getSafelistType() {
        return this.safelistType;
    }

    public void setSafelistType(String safelistType) {
        this.safelistType = safelistType;
    }

    public boolean isCleanOnly() {
        return this.cleanOnly;
    }

    public void setCleanOnly(boolean cleanOnly) {
        this.cleanOnly = cleanOnly;
    }

    public boolean isNormalisedText() {
        return this.normalisedText;
    }

    public void setNormalisedText(boolean normalisedText) {
        this.normalisedText = normalisedText;
    }

    public static enum SafelistType {
        none("none", BaseMessages.getString(PKG, (String)"Html2TextDialog.SafelistType.none", (String[])new String[0])),
        relaxed("relaxed", BaseMessages.getString(PKG, (String)"Html2TextDialog.SafelistType.relaxed", (String[])new String[0])),
        basic("basic", BaseMessages.getString(PKG, (String)"Html2TextDialog.SafelistType.basic", (String[])new String[0])),
        simpleText("simpleText", BaseMessages.getString(PKG, (String)"Html2TextDialog.SafelistType.simpleText", (String[])new String[0])),
        basicWithImages("basicWithImages", BaseMessages.getString(PKG, (String)"Html2TextDialog.SafelistType.basicWithImages", (String[])new String[0]));

        private final String code;
        private final String description;

        private SafelistType(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public static SafelistType getTypeFromDescription(String description) {
            for (SafelistType type : SafelistType.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)type.description, (CharSequence)description)) continue;
                return type;
            }
            return basic;
        }

        public static String[] getDescriptions() {
            SafelistType[] types = SafelistType.values();
            String[] descriptions = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                descriptions[i] = types[i].description;
            }
            return descriptions;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

