/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.engines.remote;

import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.pipeline.config.IPipelineEngineRunConfiguration;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engines.EmptyPipelineRunConfiguration;
import org.apache.hop.server.HopServerMeta;

@GuiPlugin(description="Remote pipeline run configuration widgets")
public class RemotePipelineRunConfiguration
extends EmptyPipelineRunConfiguration
implements IPipelineEngineRunConfiguration {
    @GuiWidgetElement(order="10", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.METADATA, label="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.HopServer.Label", metadata=HopServerMeta.class)
    @HopMetadataProperty(key="hop_server")
    protected String hopServerName;
    @GuiWidgetElement(order="20", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.METADATA, label="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.RunConfiguration.Label", metadata=PipelineRunConfiguration.class)
    @HopMetadataProperty(key="run_config")
    protected String runConfigurationName;
    @GuiWidgetElement(order="30", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.ServerPollDelay.Label")
    @HopMetadataProperty(key="server_poll_delay")
    protected String serverPollDelay;
    @GuiWidgetElement(order="40", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.ServerPollInterval.Label")
    @HopMetadataProperty(key="server_poll_interval")
    protected String serverPollInterval;
    @GuiWidgetElement(order="50", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.CHECKBOX, label="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.ExportResources.Label", toolTip="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.ExportResources.ToolTip")
    @HopMetadataProperty(key="export_resources")
    protected boolean exportingResources;
    @GuiWidgetElement(order="60", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.NamedResourceSourceFolder.Label", toolTip="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.NamedResourceSourceFolder.ToolTip")
    @HopMetadataProperty(key="resources_source_folder")
    protected String namedResourcesSourceFolder;
    @GuiWidgetElement(order="70", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.NamedResourceTargetFolder.Label", toolTip="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.NamedResourceTargetFolder.ToolTip")
    @HopMetadataProperty(key="resources_target_folder")
    protected String namedResourcesTargetFolder;

    public RemotePipelineRunConfiguration() {
    }

    public RemotePipelineRunConfiguration(RemotePipelineRunConfiguration config) {
        super(config);
        this.hopServerName = config.hopServerName;
        this.runConfigurationName = config.runConfigurationName;
        this.serverPollDelay = config.serverPollDelay;
        this.serverPollInterval = config.serverPollInterval;
        this.exportingResources = config.exportingResources;
        this.namedResourcesSourceFolder = config.namedResourcesSourceFolder;
        this.namedResourcesTargetFolder = config.namedResourcesTargetFolder;
    }

    @Override
    public RemotePipelineRunConfiguration clone() {
        return new RemotePipelineRunConfiguration(this);
    }

    public String getHopServerName() {
        return this.hopServerName;
    }

    public void setHopServerName(String hopServerName) {
        this.hopServerName = hopServerName;
    }

    public String getRunConfigurationName() {
        return this.runConfigurationName;
    }

    public void setRunConfigurationName(String runConfigurationName) {
        this.runConfigurationName = runConfigurationName;
    }

    public String getServerPollDelay() {
        return this.serverPollDelay;
    }

    public void setServerPollDelay(String serverPollDelay) {
        this.serverPollDelay = serverPollDelay;
    }

    public String getServerPollInterval() {
        return this.serverPollInterval;
    }

    public void setServerPollInterval(String serverPollInterval) {
        this.serverPollInterval = serverPollInterval;
    }

    public boolean isExportingResources() {
        return this.exportingResources;
    }

    public void setExportingResources(boolean exportingResources) {
        this.exportingResources = exportingResources;
    }

    public String getNamedResourcesSourceFolder() {
        return this.namedResourcesSourceFolder;
    }

    public void setNamedResourcesSourceFolder(String namedResourcesSourceFolder) {
        this.namedResourcesSourceFolder = namedResourcesSourceFolder;
    }

    public String getNamedResourcesTargetFolder() {
        return this.namedResourcesTargetFolder;
    }

    public void setNamedResourcesTargetFolder(String namedResourcesTargetFolder) {
        this.namedResourcesTargetFolder = namedResourcesTargetFolder;
    }
}

