/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.code;

import dev.langchain4j.agent.tool.P;
import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.code.JavaScriptCodeFixer;
import dev.langchain4j.code.Judge0JavaScriptEngine;
import dev.langchain4j.internal.Utils;
import java.time.Duration;

public class Judge0JavaScriptExecutionTool {
    private static final int JAVASCRIPT = 93;
    private final Judge0JavaScriptEngine engine;
    private final boolean fixCodeIfNeeded;

    public Judge0JavaScriptExecutionTool(String apiKey) {
        this(apiKey, true, Duration.ofSeconds(10L));
    }

    public Judge0JavaScriptExecutionTool(String apiKey, boolean fixCodeIfNeeded, Duration timeout) {
        if (Utils.isNullOrBlank((String)apiKey)) {
            throw new IllegalArgumentException("Please provide a valid Rapid API key");
        }
        this.engine = new Judge0JavaScriptEngine(apiKey, 93, timeout);
        this.fixCodeIfNeeded = fixCodeIfNeeded;
    }

    @Tool(value={"MUST be used for accurate calculations: math, sorting, filtering, aggregating, string processing, etc"})
    public String executeJavaScriptCode(@P(value="JavaScript code to execute, result MUST be printed to console") String javaScriptCode) {
        if (this.fixCodeIfNeeded) {
            javaScriptCode = JavaScriptCodeFixer.fixIfNoLogToConsole(javaScriptCode);
        }
        return this.engine.execute(javaScriptCode);
    }
}

