/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.JavaApplicationCall;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.commtrace.CommTrace;
import com.ibm.as400.util.commtrace.OutputThread;
import com.ibm.as400.util.commtrace.ResourceBundleLoader_ct;
import com.ibm.as400.vaccess.FileFilter;
import com.ibm.as400.vaccess.IFSFileDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

class FormatRemote
implements Runnable {
    private String classpath_;
    private Thread fmtThread;
    private JavaApplicationCall jaCall;
    public static final String EXT = ".bin";
    public static final String CLASS = "FormatRemote";
    private AS400 sys;
    private String file;
    private String path;
    private String filterIPaddr_;
    private String filterIPaddr2_;
    private String filterPort_;
    private String filterBdcst_;
    private String verbose_;
    private CommTrace com_;

    public FormatRemote(AS400 sys, String verbose, String filterIPaddr, String filterIPaddr2, String filterPort, String filterBdcst, CommTrace com) {
        block2: {
            this.classpath_ = "/QIBM/ProdData/OS400/JT400/lib/JT400Native.jar";
            this.file = null;
            this.path = null;
            this.filterIPaddr_ = null;
            this.filterIPaddr2_ = null;
            this.filterPort_ = null;
            this.filterBdcst_ = null;
            try {
                this.sys = sys;
                this.filterIPaddr_ = filterIPaddr;
                this.filterIPaddr2_ = filterIPaddr2;
                this.filterPort_ = filterPort;
                this.filterBdcst_ = filterBdcst;
                this.verbose_ = verbose;
                this.com_ = com;
                this.jaCall = new JavaApplicationCall(sys);
                this.jaCall.setJavaApplication("com.ibm.as400.util.commtrace.Format");
                this.jaCall.setClassPath(this.classpath_);
            }
            catch (Exception e) {
                if (!Trace.isTraceOn() || !Trace.isTraceErrorOn()) break block2;
                Trace.log(2, "FormatRemote.FormatRemote() Exception in FormatRemote", (Throwable)e);
            }
        }
    }

    public Thread getThread() {
        return this.fmtThread;
    }

    public void setThread(Thread tr) {
        this.fmtThread = tr;
    }

    public String getFile() {
        return this.file;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public void run() {
        Thread myThread = Thread.currentThread();
        while (this.fmtThread == myThread) {
            block12: {
                IFSFileDialog fd = new IFSFileDialog((Frame)new JFrame(), "Pick file to Format", this.sys);
                FileFilter[] filterList = new FileFilter[]{new FileFilter(ResourceBundleLoader_ct.getText("AllFiles"), "*.*")};
                fd.setFileFilter(filterList, 0);
                String fullpath = "";
                try {
                    if (fd.showDialog() == 1) {
                        String host = this.sys.getSystemName();
                        fullpath = fd.getAbsolutePath();
                        this.file = fd.getFileName();
                        this.path = fd.getDirectory();
                        String[] args2 = new String[]{"-c", "true", "-v", this.verbose_, "-t", fullpath, "-o", fullpath + EXT, "-ip", this.filterIPaddr_, "-ip2", this.filterIPaddr2_, "-port", this.filterPort_, "-broadcast", this.filterBdcst_};
                        this.jaCall.setParameters(args2);
                        if (this.verbose_.equals("true")) {
                            OutputThread ot = new OutputThread(this.jaCall);
                            Thread otThread = new Thread((Runnable)ot, "OutputThread");
                            ot.setThread(otThread);
                            otThread.start();
                        }
                        if (this.com_ != null) {
                            ((Component)CommTrace.getMainFrame()).setCursor(new Cursor(3));
                        }
                        if (!this.jaCall.run()) {
                            AS400Message[] messageList = this.jaCall.getMessageList();
                            for (int msg = 0; msg < messageList.length; ++msg) {
                                Trace.log(2, "FormatRemote.run() " + messageList[msg].toString());
                            }
                        }
                        if (this.com_ != null) {
                            ((Component)CommTrace.getMainFrame()).setCursor(new Cursor(0));
                            JOptionPane.showMessageDialog(CommTrace.getMainFrame(), "Format of " + fullpath + " on " + host + " compeleted", "Format Complete", 1);
                        }
                    }
                }
                catch (Exception e) {
                    if (!Trace.isTraceOn() || !Trace.isTraceErrorOn()) break block12;
                    Trace.log(2, "FormatRemote.run() Exception in FormatRemote", (Throwable)e);
                }
            }
            this.fmtThread = null;
            if (this.com_ != null) {
                this.com_.open();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

