/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.ParseException;
import com.ibm.as400.data.PcmlAttribute;
import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlData;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlDocument;
import com.ibm.as400.data.PcmlNode;
import com.ibm.as400.data.PcmlProgram;
import com.ibm.as400.data.PcmlSpecificationException;
import com.ibm.as400.data.PcmlStruct;
import com.ibm.as400.data.SystemResourceFinder;
import com.ibm.as400.data.XMLErrorHandler;
import com.ibm.as400.data.XPCMLHelper;
import com.ibm.as400.data.XmlException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

class PcmlSAXParser
extends DefaultHandler {
    private transient PcmlDocument m_rootNode = null;
    private transient PcmlDocNode m_currentNode = null;
    private transient String m_docName;
    private transient XMLErrorHandler m_xh;
    private transient boolean exceptionIfParseError_;
    Vector curAttrs = new Vector();
    Vector curQName = new Vector();
    int curDim = -1;
    String lastQName = "";
    int[] dimArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    PcmlDimensions dimensions = new PcmlDimensions(this.dimArray);
    private String initValue = "";
    private boolean docIsXPCML = false;
    private boolean firstInstance = true;
    ByteArrayOutputStream xmlOut = new ByteArrayOutputStream();
    ByteArrayInputStream xmlIn;
    private InputStream xsdFileStream;
    private static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    private static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    private static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    private static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    private static HashSet knownTypes_ = null;
    private static HashSet knownArrayTypes_ = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PcmlSAXParser(String docName, InputStream docStream, InputStream xsdStream, boolean docIsXPCML, boolean exceptionIfParseError) throws MissingResourceException, IOException, ParseException, PcmlSpecificationException, FactoryConfigurationError, ParserConfigurationException, SAXException {
        this.exceptionIfParseError_ = exceptionIfParseError;
        this.xsdFileStream = xsdStream;
        this.docIsXPCML = docIsXPCML;
        this.curAttrs.add(0, new AttributesImpl());
        this.curQName.add(0, "");
        String qualDocName = docName.endsWith(".pcml") || docName.endsWith(".pcmlsrc") || docName.endsWith(".xpcml") || docName.endsWith(".xpcmlsrc") ? docName.substring(0, docName.lastIndexOf(46)) : docName;
        this.m_docName = qualDocName.substring(qualDocName.lastIndexOf(46) + 1);
        InputStream isHeader = null;
        InputStream instream = null;
        try {
            SAXParser parser;
            if (docIsXPCML) {
                if (this.xsdFileStream != null) {
                    try {
                        XPCMLHelper.doSimplifyXSDTransform(this.xsdFileStream, this.xmlOut);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (SAXException e) {
                        throw e;
                    }
                    this.xmlIn = new ByteArrayInputStream(this.xmlOut.toByteArray());
                    if (this.xmlIn == null) {
                        throw new MissingResourceException(SystemResourceFinder.format("PCML_DTD_NOT_FOUND", new Object[]{"xmlOut"}), "xmlOut", "");
                    }
                }
                instream = new BufferedInputStream(docStream);
            } else {
                isHeader = SystemResourceFinder.getPCMLHeader();
                instream = new SequenceInputStream(isHeader, docStream);
            }
            this.m_xh = new XMLErrorHandler(this.m_docName, SystemResourceFinder.getHeaderLineCount());
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(false);
            if (docIsXPCML) {
                PcmlSAXParser.setFeatures(factory);
            }
            try {
                parser = factory.newSAXParser();
            }
            catch (ParserConfigurationException pce) {
                factory.setValidating(false);
                parser = factory.newSAXParser();
            }
            try {
                XMLReader reader = parser.getXMLReader();
                reader.setErrorHandler(this.m_xh);
                parser.parse(new InputSource(instream), (DefaultHandler)this);
                instream.close();
                instream = null;
            }
            catch (SAXException e) {
                Trace.log(7, e);
                ParseException pe = new ParseException(SystemResourceFinder.format("FAILED_TO_PARSE", new Object[]{this.m_docName}));
                pe.addMessage(e.getMessage());
                throw pe;
            }
            ParseException exc = this.m_xh.getException();
            if (exc != null) {
                exc.reportErrors();
                throw exc;
            }
            this.augmentTree(this.m_rootNode, new Stack());
            this.checkAttributes(this.m_rootNode);
            try {
                if (docIsXPCML) {
                    this.m_rootNode.copyValues(this.m_rootNode, this.m_rootNode);
                }
            }
            catch (XmlException e) {
                Trace.log(7, "All data values may not have been copied to struct parm refs.", (Throwable)e);
                throw new SAXException(e);
            }
            if (this.m_rootNode != null && this.m_rootNode.getPcmlSpecificationException() != null) {
                throw this.m_rootNode.getPcmlSpecificationException();
            }
        }
        finally {
            if (isHeader != null) {
                try {
                    isHeader.close();
                }
                catch (Exception exception) {}
            }
            if (instream != null) {
                try {
                    instream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    static void setFeatures(SAXParserFactory factory) throws SAXException, SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException {
        factory.setFeature(NAMESPACES_FEATURE_ID, true);
        factory.setFeature(NAMESPACE_PREFIXES_FEATURE_ID, true);
        factory.setFeature(VALIDATION_FEATURE_ID, true);
        factory.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        factory.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
        factory.setFeature(DYNAMIC_VALIDATION_FEATURE_ID, false);
    }

    PcmlDocument getPcmlDocument() {
        return this.m_rootNode;
    }

    private void augmentTree(PcmlDocNode pcmlElem, Stack recursionStack) {
        Enumeration children = pcmlElem.getChildren();
        if (children == null) {
            return;
        }
        while (children.hasMoreElements()) {
            String structName;
            PcmlData dataNode;
            PcmlDocNode child = (PcmlDocNode)children.nextElement();
            if (child instanceof PcmlData && (dataNode = (PcmlData)child).getDataType() == 7 && dataNode.getNbrChildren() == 0 && (structName = dataNode.getStruct()) != null) {
                PcmlDocNode structNode = (PcmlDocNode)this.m_rootNode.getElement(structName);
                if (structNode instanceof PcmlStruct) {
                    if (recursionStack.search(structNode) != -1) {
                        this.m_rootNode.addPcmlSpecificationError("CIRCULAR_REFERENCE", new Object[]{structName, dataNode.getBracketedTagName(), dataNode.getNameForException()});
                    } else {
                        Enumeration structChildren = structNode.getChildren();
                        while (structChildren.hasMoreElements()) {
                            PcmlDocNode structChild = (PcmlDocNode)structChildren.nextElement();
                            PcmlDocNode newChild = (PcmlDocNode)structChild.clone();
                            dataNode.addChild(newChild);
                            this.m_rootNode.addToHashtable(newChild);
                        }
                    }
                } else if (structNode == null) {
                    this.m_rootNode.addPcmlSpecificationError("REF_NOT_FOUND", new Object[]{structName, "<struct>", dataNode.getBracketedTagName(), dataNode.getNameForException()});
                } else {
                    this.m_rootNode.addPcmlSpecificationError("REF_WRONG_TYPE", new Object[]{structName, "<struct>", dataNode.getBracketedTagName(), dataNode.getNameForException()});
                }
            }
            recursionStack.push(child);
            this.augmentTree(child, recursionStack);
            recursionStack.pop();
        }
    }

    private void checkAttributes(PcmlDocNode pcmlElem) {
        Enumeration children = pcmlElem.getChildren();
        if (children == null) {
            return;
        }
        while (children.hasMoreElements()) {
            PcmlDocNode child = (PcmlDocNode)children.nextElement();
            child.checkAttributes();
            this.checkAttributes(child);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes xmlAttrs) {
        String tagName = qName;
        PcmlDocNode newNode = null;
        String equivQName = qName;
        AttributesImpl uAttrs = new AttributesImpl();
        boolean uDefinedQName = false;
        boolean extendedType = false;
        this.initValue = "";
        if (!this.docIsXPCML) {
            PcmlAttributeList attrs = new PcmlAttributeList(xmlAttrs.getLength());
            for (int attr = 0; attr < xmlAttrs.getLength(); ++attr) {
                attrs.addAttribute(new PcmlAttribute(xmlAttrs.getQName(attr), xmlAttrs.getValue(attr), true));
            }
            if (tagName.equals("pcml")) {
                newNode = new PcmlDocument(attrs, this.m_docName);
            } else if (tagName.equals("program")) {
                newNode = new PcmlProgram(attrs);
            } else if (tagName.equals("struct")) {
                newNode = new PcmlStruct(attrs);
            } else if (tagName.equals("data")) {
                newNode = new PcmlData(attrs);
            } else {
                newNode = null;
                if (this.m_rootNode != null) {
                    this.m_rootNode.addPcmlSpecificationError("BAD_TAG", new Object[]{tagName, PcmlSAXParser.getBracketedTagName(tagName)});
                } else {
                    PcmlSpecificationException pse = new PcmlSpecificationException(SystemResourceFinder.format("BAD_TAG", new Object[]{tagName, PcmlSAXParser.getBracketedTagName(tagName)}));
                    throw new RuntimeException(pse);
                }
            }
            if (newNode != null) {
                if (this.m_rootNode == null) {
                    this.m_rootNode = newNode;
                    this.m_currentNode = newNode;
                } else {
                    this.m_currentNode.addChild(newNode);
                    this.m_currentNode = newNode;
                }
            }
        }
        if (this.docIsXPCML) {
            int attr;
            boolean isInTree;
            String curName;
            AttributesImpl curList;
            if (this.xsdFileStream != null && !PcmlSAXParser.getKnownTypes().contains(qName)) {
                uDefinedQName = true;
                ByteArrayInputStream xmlIn1 = new ByteArrayInputStream(this.xmlOut.toByteArray());
                if (xmlIn1 == null) {
                    throw new MissingResourceException(SystemResourceFinder.format("PCML_DTD_NOT_FOUND", new Object[]{"xmlOut"}), "xmlOut", "");
                }
                LineNumberReader lnr = new LineNumberReader(new InputStreamReader(xmlIn1));
                try {
                    String line = lnr.readLine();
                    boolean found = false;
                    while (line != null && !found) {
                        if (line.indexOf("name=\"" + qName + "\"") != -1 && line.indexOf("parm type=") != -1) {
                            if (line.indexOf("parm type=string") != -1) {
                                equivQName = "stringParm";
                                found = true;
                            } else if (line.indexOf("parm type=int") != -1) {
                                equivQName = "intParm";
                                found = true;
                            } else if (line.indexOf("parm type=uint") != -1) {
                                equivQName = "unsignedIntParm";
                                found = true;
                            } else if (line.indexOf("parm type=hexBinary") != -1) {
                                equivQName = "hexBinaryParm";
                                found = true;
                            } else if (line.indexOf("parm type=byte") != -1) {
                                equivQName = "byteParm";
                                found = true;
                            } else if (line.indexOf("parm type=ubyte") != -1) {
                                equivQName = "unsignedByteParm";
                                found = true;
                            } else if (line.indexOf("parm type=short") != -1) {
                                equivQName = "shortParm";
                                found = true;
                            } else if (line.indexOf("parm type=ushort") != -1) {
                                equivQName = "unsignedShortParm";
                                found = true;
                            } else if (line.indexOf("parm type=long") != -1) {
                                equivQName = "longParm";
                                found = true;
                            } else if (line.indexOf("parm type=ulong") != -1) {
                                equivQName = "unsignedLongParm";
                                found = true;
                            } else if (line.indexOf("parm type=float") != -1) {
                                equivQName = "floatParm";
                                found = true;
                            } else if (line.indexOf("parm type=double") != -1) {
                                equivQName = "doubleParm";
                                found = true;
                            } else if (line.indexOf("parm type=packed") != -1) {
                                equivQName = "packedDecimalParm";
                                found = true;
                            } else if (line.indexOf("parm type=zoned") != -1) {
                                equivQName = "zonedDecimalParm";
                                found = true;
                            } else if (line.indexOf("parm type=date") != -1) {
                                equivQName = "dateParm";
                                found = true;
                            } else if (line.indexOf("parm type=time") != -1) {
                                equivQName = "timeParm";
                                found = true;
                            } else if (line.indexOf("parm type=timestamp") != -1) {
                                equivQName = "timestampParm";
                                found = true;
                            } else if (line.indexOf("parm type=structParm") != -1) {
                                equivQName = "structParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfString") != -1) {
                                equivQName = "arrayOfStringParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfInt") != -1) {
                                equivQName = "arrayOfIntParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfUInt") != -1) {
                                equivQName = "arrayOfUnsignedIntParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfHexBinary") != -1) {
                                equivQName = "arrayOfHexBinaryParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfShort") != -1) {
                                equivQName = "arrayOfShortParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfUShort") != -1) {
                                equivQName = "arrayOfUnsignedShortParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfLong") != -1) {
                                equivQName = "arrayOfLongParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfULong") != -1) {
                                equivQName = "arrayOfUnsignedLongParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfFloat") != -1) {
                                equivQName = "arrayOfFloatParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfDouble") != -1) {
                                equivQName = "arrayOfDoubleParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfPacked") != -1) {
                                equivQName = "arrayOfPackedDecimalParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfZoned") != -1) {
                                equivQName = "arrayOfZonedDecimalParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfDate") != -1) {
                                equivQName = "arrayOfDateParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfTime") != -1) {
                                equivQName = "arrayOfTimeParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfTimestamp") != -1) {
                                equivQName = "arrayOfTimestampParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfStructParm") != -1) {
                                equivQName = "arrayOfStructParm";
                                found = true;
                            } else if (line.indexOf("parm type=structArray") != -1) {
                                equivQName = "arrayOfStruct";
                                found = true;
                            } else {
                                Trace.log(4, "User defined type passed in not found in xsd stream");
                            }
                            if (found) {
                                line = lnr.readLine();
                                while (line != null && line.indexOf("parm type=") == -1) {
                                    String attrName = "";
                                    String attrVal = "";
                                    if (line.indexOf("attributeName=") != -1) {
                                        attrName = line.substring(line.indexOf("attributeName=") + 14, line.indexOf("attributeValue=")).trim();
                                    }
                                    if (line.indexOf("attributeValue=") != -1) {
                                        attrVal = line.substring(line.indexOf("attributeValue=") + 15).trim();
                                    }
                                    uAttrs.addAttribute("", "", attrName, "", attrVal);
                                    line = lnr.readLine();
                                }
                            }
                        }
                        if (found) continue;
                        line = lnr.readLine();
                    }
                }
                catch (IOException e) {
                    Trace.log(7, "Error reading xsd stream in startElement.", (Throwable)e);
                }
            }
            if (PcmlSAXParser.getKnownArrayTypes().contains(equivQName)) {
                ++this.curDim;
                if (uDefinedQName) {
                    if (this.curAttrs.size() > this.curDim) {
                        this.curAttrs.set(this.curDim, uAttrs);
                    } else {
                        this.curAttrs.add(this.curDim, uAttrs);
                    }
                } else if (this.curAttrs.size() > this.curDim) {
                    this.curAttrs.set(this.curDim, new AttributesImpl(xmlAttrs));
                } else {
                    this.curAttrs.add(this.curDim, new AttributesImpl(xmlAttrs));
                }
                if (this.curQName.size() > this.curDim) {
                    this.curQName.set(this.curDim, equivQName);
                } else {
                    this.curQName.add(this.curDim, equivQName);
                }
                this.lastQName = equivQName;
            }
            if (equivQName.equals("i") || equivQName.equals("struct_i")) {
                if (this.lastQName.indexOf("arrayOf") == -1) {
                    this.dimensions.set(this.curDim, this.dimensions.at(this.curDim) + 1);
                }
                curList = new AttributesImpl((AttributesImpl)this.curAttrs.elementAt(this.curDim));
                curName = (String)this.curQName.elementAt(this.curDim);
            } else {
                if (uDefinedQName) {
                    curList = uAttrs;
                    for (int attr2 = 0; attr2 < xmlAttrs.getLength(); ++attr2) {
                        if (curList.getIndex(xmlAttrs.getQName(attr2)) != -1) continue;
                        extendedType = true;
                        curList.addAttribute(xmlAttrs.getURI(attr2), xmlAttrs.getLocalName(attr2), xmlAttrs.getQName(attr2), xmlAttrs.getType(attr2), xmlAttrs.getValue(attr2));
                    }
                } else {
                    curList = new AttributesImpl(xmlAttrs);
                }
                curName = equivQName;
            }
            this.firstInstance = true;
            if (this.m_currentNode != null && this.m_currentNode.getNodeType() == 3 && !equivQName.equals("struct_i") && !equivQName.equals("struct") && !equivQName.equals("xpcml") && (isInTree = this.inTree(equivQName, curList))) {
                this.firstInstance = false;
            }
            for (int i = 0; i <= this.curDim; ++i) {
                if (this.dimensions.at(i) <= 0) continue;
                this.firstInstance = false;
            }
            if (equivQName.equals("i") || equivQName.equals("struct_i")) {
                for (int attr3 = 0; attr3 < xmlAttrs.getLength(); ++attr3) {
                    if (!xmlAttrs.getQName(attr3).equals("index")) continue;
                    Integer indexInt = Integer.valueOf(xmlAttrs.getValue(attr3));
                    this.dimensions.set(this.curDim, indexInt);
                }
            }
            this.lastQName = equivQName;
            if (this.firstInstance && !equivQName.equals("i") && !equivQName.equals("struct_i")) {
                PcmlAttributeList attrs = new PcmlAttributeList(curList.getLength() + 2);
                for (attr = 0; attr < curList.getLength(); ++attr) {
                    if (curList.getQName(attr).equals("passDirection")) {
                        if (curList.getValue(attr).equals("in")) {
                            attrs.addAttribute(new PcmlAttribute("usage", "input", true));
                            continue;
                        }
                        if (curList.getValue(attr).equals("inout")) {
                            attrs.addAttribute(new PcmlAttribute("usage", "inputoutput", true));
                            continue;
                        }
                        if (curList.getValue(attr).equals("out")) {
                            attrs.addAttribute(new PcmlAttribute("usage", "output", true));
                            continue;
                        }
                        if (!curList.getValue(attr).equals("inherit")) continue;
                        attrs.addAttribute(new PcmlAttribute("usage", "inherit", true));
                        continue;
                    }
                    if (curList.getQName(attr).equals("passMode")) {
                        attrs.addAttribute(new PcmlAttribute("passby", curList.getValue(attr), true));
                        continue;
                    }
                    if (curList.getQName(attr).equals("bytesPerChar")) {
                        attrs.addAttribute(new PcmlAttribute("chartype", curList.getValue(attr), true));
                        continue;
                    }
                    if (curList.getQName(attr).equals("totalBytes")) {
                        attrs.addAttribute(new PcmlAttribute("length", curList.getValue(attr), true));
                        continue;
                    }
                    if (curList.getQName(attr).equals("outputSize")) {
                        attrs.addAttribute(new PcmlAttribute("outputsize", curList.getValue(attr), true));
                        continue;
                    }
                    if (curList.getQName(attr).equals("entryPoint")) {
                        attrs.addAttribute(new PcmlAttribute("entrypoint", curList.getValue(attr), true));
                        continue;
                    }
                    if (curList.getQName(attr).equals("returnValue")) {
                        attrs.addAttribute(new PcmlAttribute("returnvalue", curList.getValue(attr), true));
                        continue;
                    }
                    if (curList.getQName(attr).equals("threadSafe")) {
                        attrs.addAttribute(new PcmlAttribute("threadsafe", curList.getValue(attr), true));
                        continue;
                    }
                    if (curList.getQName(attr).equals("offsetFrom")) {
                        attrs.addAttribute(new PcmlAttribute("offsetfrom", curList.getValue(attr), true));
                        continue;
                    }
                    if (curList.getQName(attr).equals("totalDigits")) {
                        attrs.addAttribute(new PcmlAttribute("length", curList.getValue(attr), true));
                        continue;
                    }
                    if (curList.getQName(attr).equals("fractionDigits")) {
                        attrs.addAttribute(new PcmlAttribute("precision", curList.getValue(attr), true));
                        continue;
                    }
                    if (curList.getQName(attr).equals("parseOrder")) {
                        attrs.addAttribute(new PcmlAttribute("parseorder", curList.getValue(attr), true));
                        continue;
                    }
                    if (curList.getQName(attr).equals("bidiStringType")) {
                        attrs.addAttribute(new PcmlAttribute("bidistringtype", curList.getValue(attr), true));
                        continue;
                    }
                    if (curList.getQName(attr).equals("isEmptyString")) {
                        attrs.addAttribute(new PcmlAttribute("init", "", true));
                        continue;
                    }
                    if (curList.getQName(attr).equals("dateFormat")) {
                        attrs.addAttribute(new PcmlAttribute("dateformat", curList.getValue(attr), true));
                        continue;
                    }
                    if (curList.getQName(attr).equals("dateSeparator")) {
                        attrs.addAttribute(new PcmlAttribute("dateseparator", curList.getValue(attr), true));
                        continue;
                    }
                    if (curList.getQName(attr).equals("timeFormat")) {
                        attrs.addAttribute(new PcmlAttribute("timeformat", curList.getValue(attr), true));
                        continue;
                    }
                    if (curList.getQName(attr).equals("timeSeparator")) {
                        attrs.addAttribute(new PcmlAttribute("timeseparator", curList.getValue(attr), true));
                        continue;
                    }
                    if (qName.equals("xpcml") && (!qName.equals("xpcml") || !curList.getQName(attr).equals("version"))) continue;
                    attrs.addAttribute(new PcmlAttribute(curList.getQName(attr), curList.getValue(attr), true));
                }
                if (tagName.equals("program")) {
                    newNode = new PcmlProgram(attrs);
                    for (int i = 0; i < this.dimensions.size(); ++i) {
                        this.dimensions.set(i, 0);
                    }
                } else if (tagName.equals("struct")) {
                    newNode = new PcmlStruct(attrs);
                } else if (tagName.equals("arrayOfStruct")) {
                    newNode = new PcmlStruct(attrs);
                    if (uDefinedQName) {
                        newNode.setCondensedName(qName);
                    }
                } else if (equivQName.equals("arrayOfStructParm")) {
                    attrs.addAttribute(new PcmlAttribute("type", "struct", true));
                    newNode = new PcmlData(attrs);
                    if (uDefinedQName) {
                        newNode.setCondensedName(qName);
                    }
                } else if (tagName.equals("xpcml")) {
                    newNode = new PcmlDocument(attrs, this.m_docName);
                } else if (equivQName.equals("stringParm") || equivQName.equals("arrayOfStringParm")) {
                    attrs.addAttribute(new PcmlAttribute("type", "char", true));
                    newNode = new PcmlData(attrs);
                    if (uDefinedQName) {
                        newNode.setCondensedName(qName);
                    }
                } else if (equivQName.equals("hexBinaryParm") || equivQName.equals("arrayOfHexBinaryParm")) {
                    attrs.addAttribute(new PcmlAttribute("type", "byte", true));
                    newNode = new PcmlData(attrs);
                    if (uDefinedQName) {
                        newNode.setCondensedName(qName);
                    }
                } else if (equivQName.equals("intParm") || equivQName.equals("arrayOfIntParm")) {
                    attrs.addAttribute(new PcmlAttribute("type", "int", true));
                    attrs.addAttribute(new PcmlAttribute("length", "4", true));
                    newNode = new PcmlData(attrs);
                    if (uDefinedQName) {
                        newNode.setCondensedName(qName);
                    }
                } else if (equivQName.equals("unsignedIntParm") || equivQName.equals("arrayOfUnsignedIntParm")) {
                    attrs.addAttribute(new PcmlAttribute("type", "int", true));
                    attrs.addAttribute(new PcmlAttribute("length", "4", true));
                    attrs.addAttribute(new PcmlAttribute("precision", "32", true));
                    newNode = new PcmlData(attrs);
                    if (uDefinedQName) {
                        newNode.setCondensedName(qName);
                    }
                } else if (equivQName.equals("byteParm") || equivQName.equals("arrayOfByteParm")) {
                    attrs.addAttribute(new PcmlAttribute("type", "int", true));
                    attrs.addAttribute(new PcmlAttribute("length", "1", true));
                    newNode = new PcmlData(attrs);
                    if (uDefinedQName) {
                        newNode.setCondensedName(qName);
                    }
                } else if (equivQName.equals("unsignedByteParm") || equivQName.equals("arrayOfUnsignedByteParm")) {
                    attrs.addAttribute(new PcmlAttribute("type", "int", true));
                    attrs.addAttribute(new PcmlAttribute("length", "1", true));
                    attrs.addAttribute(new PcmlAttribute("precision", "8", true));
                    newNode = new PcmlData(attrs);
                    if (uDefinedQName) {
                        newNode.setCondensedName(qName);
                    }
                } else if (equivQName.equals("shortParm") || equivQName.equals("arrayOfShortParm")) {
                    attrs.addAttribute(new PcmlAttribute("type", "int", true));
                    attrs.addAttribute(new PcmlAttribute("length", "2", true));
                    newNode = new PcmlData(attrs);
                    if (uDefinedQName) {
                        newNode.setCondensedName(qName);
                    }
                } else if (equivQName.equals("unsignedShortParm") || equivQName.equals("arrayOfUnsignedShortParm")) {
                    attrs.addAttribute(new PcmlAttribute("type", "int", true));
                    attrs.addAttribute(new PcmlAttribute("length", "2", true));
                    attrs.addAttribute(new PcmlAttribute("precision", "16", true));
                    newNode = new PcmlData(attrs);
                    if (uDefinedQName) {
                        newNode.setCondensedName(qName);
                    }
                } else if (equivQName.equals("longParm") || equivQName.equals("arrayOfLongParm")) {
                    attrs.addAttribute(new PcmlAttribute("type", "int", true));
                    attrs.addAttribute(new PcmlAttribute("length", "8", true));
                    newNode = new PcmlData(attrs);
                    if (uDefinedQName) {
                        newNode.setCondensedName(qName);
                    }
                } else if (equivQName.equals("unsignedLongParm") || equivQName.equals("arrayOfUnsignedLongParm")) {
                    attrs.addAttribute(new PcmlAttribute("type", "int", true));
                    attrs.addAttribute(new PcmlAttribute("length", "8", true));
                    attrs.addAttribute(new PcmlAttribute("precision", "64", true));
                    newNode = new PcmlData(attrs);
                    if (uDefinedQName) {
                        newNode.setCondensedName(qName);
                    }
                } else if (equivQName.equals("floatParm") || equivQName.equals("arrayOfFloatParm")) {
                    attrs.addAttribute(new PcmlAttribute("type", "float", true));
                    attrs.addAttribute(new PcmlAttribute("length", "4", true));
                    newNode = new PcmlData(attrs);
                    if (uDefinedQName) {
                        newNode.setCondensedName(qName);
                    }
                } else if (equivQName.equals("doubleParm") || equivQName.equals("arrayOfDoubleParm")) {
                    attrs.addAttribute(new PcmlAttribute("type", "float", true));
                    attrs.addAttribute(new PcmlAttribute("length", "8", true));
                    newNode = new PcmlData(attrs);
                    if (uDefinedQName) {
                        newNode.setCondensedName(qName);
                    }
                } else if (equivQName.equals("zonedDecimalParm") || equivQName.equals("arrayOfZonedDecimalParm")) {
                    attrs.addAttribute(new PcmlAttribute("type", "zoned", true));
                    newNode = new PcmlData(attrs);
                    if (uDefinedQName) {
                        newNode.setCondensedName(qName);
                    }
                } else if (equivQName.equals("packedDecimalParm") || equivQName.equals("arrayOfPackedDecimalParm")) {
                    attrs.addAttribute(new PcmlAttribute("type", "packed", true));
                    newNode = new PcmlData(attrs);
                    if (uDefinedQName) {
                        newNode.setCondensedName(qName);
                    }
                } else if (equivQName.equals("dateParm") || equivQName.equals("arrayOfDateParm")) {
                    attrs.addAttribute(new PcmlAttribute("type", "date", true));
                    newNode = new PcmlData(attrs);
                    if (uDefinedQName) {
                        newNode.setCondensedName(qName);
                    }
                } else if (equivQName.equals("timeParm") || equivQName.equals("arrayOfTimeParm")) {
                    attrs.addAttribute(new PcmlAttribute("type", "time", true));
                    newNode = new PcmlData(attrs);
                    if (uDefinedQName) {
                        newNode.setCondensedName(qName);
                    }
                } else if (equivQName.equals("timestampParm") || equivQName.equals("arrayOfTimestampParm")) {
                    attrs.addAttribute(new PcmlAttribute("type", "timestamp", true));
                    newNode = new PcmlData(attrs);
                    if (uDefinedQName) {
                        newNode.setCondensedName(qName);
                    }
                } else if (equivQName.equals("structParm")) {
                    attrs.addAttribute(new PcmlAttribute("type", "struct", true));
                    newNode = new PcmlData(attrs);
                    if (uDefinedQName) {
                        newNode.setCondensedName(qName);
                    }
                } else {
                    newNode = null;
                }
                if (newNode != null) {
                    if (extendedType) {
                        newNode.setIsExtendedType(true);
                    }
                    if (this.m_rootNode == null) {
                        this.m_rootNode = (PcmlDocument)newNode;
                        this.m_currentNode = newNode;
                    } else {
                        if (this.m_currentNode != null) {
                            this.m_currentNode.addChild(newNode);
                        }
                        this.m_currentNode = newNode;
                    }
                }
            } else if (this.m_currentNode.getNodeType() == 3 && !equivQName.equals("struct_i") || this.m_currentNode.getNodeType() == 4 && this.m_currentNode.getAttributeValue("type").equals("struct") && !equivQName.equals("struct_i")) {
                String pName = "";
                for (attr = 0; attr < curList.getLength(); ++attr) {
                    if (!curList.getQName(attr).equals("name")) continue;
                    pName = curList.getValue(attr);
                }
                PcmlNode child = null;
                Enumeration items = this.m_currentNode.getChildren();
                if (items == null) {
                    return;
                }
                boolean found = false;
                while (items.hasMoreElements() && !found) {
                    child = (PcmlNode)items.nextElement();
                    if (!child.getName().equals(pName)) continue;
                    found = true;
                }
                this.m_currentNode = (PcmlDocNode)child;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!(this.m_currentNode == null || this.m_currentNode.getNodeType() != 4 || this.m_currentNode.getAttributeValue("type") != null && this.m_currentNode.getAttributeValue("type").equals("struct"))) {
            String str = new String(ch, start, length);
            if (!PcmlSAXParser.getKnownArrayTypes().contains(this.lastQName)) {
                this.initValue = this.lastQName.equals("i") ? (str.indexOf(10) != -1 ? this.initValue + str.substring(0, str.indexOf(10)) : this.initValue + str) : this.initValue + str;
                try {
                    if (this.m_currentNode.getAttributeValue("type").equals("byte")) {
                        byte[] byteA = BinaryConverter.stringToBytes(this.initValue);
                        ((PcmlData)this.m_currentNode).setValue(byteA, this.dimensions);
                    } else if (this.m_currentNode.getAttributeValue("type").equals("char") && this.m_currentNode.getAttributeValue("isEmptyString") != null && this.m_currentNode.getAttributeValue("isEmptyString").equals("true")) {
                        Trace.log(7, "Setting an empty string");
                        ((PcmlData)this.m_currentNode).setValue("", new PcmlDimensions(this.dimensions));
                    } else if (this.initValue.trim().length() > 0 || this.m_currentNode.getAttributeValue("type").equals("char")) {
                        ((PcmlData)this.m_currentNode).setInit(this.initValue);
                        ((PcmlData)this.m_currentNode).setValue(this.initValue, this.dimensions);
                    }
                    if (!this.firstInstance || this.lastQName.equals("i") || this.lastQName.equals("struct_i")) {
                        ((PcmlData)this.m_currentNode).setInit(null);
                    }
                }
                catch (Exception e) {
                    Trace.log(7, "Exception when doing setValue.", (Throwable)e);
                    Trace.log(7, "current node=" + this.m_currentNode.getQualifiedName());
                    Trace.log(7, "initial value=" + this.initValue + "..");
                    try {
                        int length2 = ((PcmlData)this.m_currentNode).getLength(this.dimensions);
                        Trace.log(7, "length2 is " + length2);
                    }
                    catch (Exception e1) {
                        Trace.log(7, "Exception due to length not being set when doing setValue.", (Throwable)e);
                        Trace.log(7, "setValue not done but init attribute set.");
                        return;
                    }
                    throw new SAXException(e);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        String equivQName = qName;
        if (!this.docIsXPCML) {
            this.m_currentNode = (PcmlDocNode)this.m_currentNode.getParent();
        }
        if (this.docIsXPCML) {
            if (this.xsdFileStream != null && !PcmlSAXParser.getKnownTypes().contains(qName)) {
                ByteArrayInputStream xmlIn1 = new ByteArrayInputStream(this.xmlOut.toByteArray());
                LineNumberReader lnr = new LineNumberReader(new InputStreamReader(xmlIn1));
                try {
                    String line = lnr.readLine();
                    boolean found = false;
                    while (line != null && !found) {
                        if (line.indexOf("name=\"" + qName + "\"") != -1 && line.indexOf("parm type=") != -1) {
                            if (line.indexOf("parm type=string") != -1) {
                                equivQName = "stringParm";
                                found = true;
                            } else if (line.indexOf("parm type=int") != -1) {
                                equivQName = "intParm";
                                found = true;
                            } else if (line.indexOf("parm type=uint") != -1) {
                                equivQName = "unsignedIntParm";
                                found = true;
                            } else if (line.indexOf("parm type=hexBinary") != -1) {
                                equivQName = "hexBinaryParm";
                                found = true;
                            } else if (line.indexOf("parm type=byte") != -1) {
                                equivQName = "byteParm";
                                found = true;
                            } else if (line.indexOf("parm type=ubyte") != -1) {
                                equivQName = "unsignedByteParm";
                                found = true;
                            } else if (line.indexOf("parm type=short") != -1) {
                                equivQName = "shortParm";
                                found = true;
                            } else if (line.indexOf("parm type=ushort") != -1) {
                                equivQName = "unsignedShortParm";
                                found = true;
                            } else if (line.indexOf("parm type=long") != -1) {
                                equivQName = "longParm";
                                found = true;
                            } else if (line.indexOf("parm type=ulong") != -1) {
                                equivQName = "unsignedLongParm";
                                found = true;
                            } else if (line.indexOf("parm type=float") != -1) {
                                equivQName = "floatParm";
                                found = true;
                            } else if (line.indexOf("parm type=double") != -1) {
                                equivQName = "doubleParm";
                                found = true;
                            } else if (line.indexOf("parm type=packed") != -1) {
                                equivQName = "packedDecimalParm";
                                found = true;
                            } else if (line.indexOf("parm type=zoned") != -1) {
                                equivQName = "zonedDecimalParm";
                                found = true;
                            } else if (line.indexOf("parm type=date") != -1) {
                                equivQName = "dateParm";
                                found = true;
                            } else if (line.indexOf("parm type=time") != -1) {
                                equivQName = "timeParm";
                                found = true;
                            } else if (line.indexOf("parm type=timestamp") != -1) {
                                equivQName = "timestampParm";
                                found = true;
                            } else if (line.indexOf("parm type=structParm") != -1) {
                                equivQName = "structParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfString") != -1) {
                                equivQName = "arrayOfStringParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfInt") != -1) {
                                equivQName = "arrayOfIntParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfUInt") != -1) {
                                equivQName = "arrayOfUnsignedIntParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfHexBinary") != -1) {
                                equivQName = "arrayOfHexBinaryParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfByte") != -1) {
                                equivQName = "arrayOfByteParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfUByte") != -1) {
                                equivQName = "arrayOfUnsignedByteParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfShort") != -1) {
                                equivQName = "arrayOfShortParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfUShort") != -1) {
                                equivQName = "arrayOfUnsignedShortParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfLong") != -1) {
                                equivQName = "arrayOfLongParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfULong") != -1) {
                                equivQName = "arrayOfUnsignedLongParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfFloat") != -1) {
                                equivQName = "arrayOfFloatParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfDouble") != -1) {
                                equivQName = "arrayOfDoubleParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfPacked") != -1) {
                                equivQName = "arrayOfPackedDecimalParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfZoned") != -1) {
                                equivQName = "arrayOfZonedDecimalParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfDate") != -1) {
                                equivQName = "arrayOfDateParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfTime") != -1) {
                                equivQName = "arrayOfTimeParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfTimestamp") != -1) {
                                equivQName = "arrayOfTimestampParm";
                                found = true;
                            } else if (line.indexOf("parm type=arrayOfStructParm") != -1) {
                                equivQName = "arrayOfStructParm";
                                found = true;
                            } else if (line.indexOf("parm type=structArray") != -1) {
                                equivQName = "arrayOfStruct";
                                found = true;
                            }
                            Trace.log(7, "Error parsing xsd stream in endElement:", line);
                        }
                        line = lnr.readLine();
                    }
                }
                catch (IOException e) {
                    Trace.log(7, "Error reading xsd stream in endElement.", (Throwable)e);
                }
            }
            if (!(equivQName.equals("parameterList") || equivQName.equals("i") || equivQName.equals("struct_i"))) {
                this.m_currentNode = (PcmlDocNode)this.m_currentNode.getParent();
            }
            if (PcmlSAXParser.getKnownArrayTypes().contains(equivQName)) {
                this.dimensions.set(this.curDim, 0);
                --this.curDim;
            }
        }
    }

    private static final String getBracketedTagName(String tagName) {
        return "<" + tagName + ">";
    }

    boolean inTree(String equivQName, AttributesImpl curList) {
        boolean found = false;
        String pName = "";
        for (int attr = 0; attr < curList.getLength(); ++attr) {
            if (!curList.getQName(attr).equals("name")) continue;
            pName = curList.getValue(attr);
        }
        PcmlNode child = null;
        Enumeration items = this.m_currentNode.getChildren();
        if (items != null) {
            while (items.hasMoreElements() && !found) {
                child = (PcmlNode)items.nextElement();
                if (!child.getName().equals(pName) || pName.length() <= 0) continue;
                found = true;
            }
        }
        return found;
    }

    @Override
    public void warning(SAXParseException spe) throws SAXException {
        if (this.exceptionIfParseError_) {
            if (this.m_xh == null) {
                throw spe;
            }
            this.m_xh.warning(spe);
        } else {
            Trace.log(7, "[Warning]: " + spe.getMessage());
        }
    }

    @Override
    public void error(SAXParseException spe) throws SAXException {
        if (this.exceptionIfParseError_) {
            if (this.m_xh == null) {
                throw spe;
            }
            this.m_xh.error(spe);
        } else {
            Trace.log(7, "[Error]: " + spe.getMessage());
        }
    }

    @Override
    public void fatalError(SAXParseException spe) throws SAXException {
        if (this.m_xh == null) {
            throw spe;
        }
        this.m_xh.error(spe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashSet getKnownTypes() {
        if (knownTypes_ != null) return knownTypes_;
        Class<PcmlSAXParser> clazz = PcmlSAXParser.class;
        synchronized (PcmlSAXParser.class) {
            if (knownTypes_ != null) return knownTypes_;
            knownTypes_ = new HashSet(50);
            knownTypes_.addAll(PcmlSAXParser.getKnownArrayTypes());
            String[] types = new String[]{"byteParm", "dateParm", "doubleParm", "floatParm", "hexBinaryParm", "intParm", "longParm", "packedDecimalParm", "parameterList", "program", "shortParm", "stringParm", "struct", "structParm", "timeParm", "timestampParm", "unsignedByteParm", "unsignedIntParm", "unsignedLongParm", "unsignedShortParm", "xpcml", "zonedDecimalParm"};
            for (int i = 0; i < types.length; ++i) {
                knownTypes_.add(types[i]);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return knownTypes_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashSet getKnownArrayTypes() {
        if (knownArrayTypes_ != null) return knownArrayTypes_;
        Class<PcmlSAXParser> clazz = PcmlSAXParser.class;
        synchronized (PcmlSAXParser.class) {
            if (knownArrayTypes_ != null) return knownArrayTypes_;
            knownArrayTypes_ = new HashSet(25);
            String[] types = new String[]{"arrayOfByteParm", "arrayOfDateParm", "arrayOfDoubleParm", "arrayOfFloatParm", "arrayOfHexBinaryParm", "arrayOfIntParm", "arrayOfLongParm", "arrayOfPackedDecimalParm", "arrayOfShortParm", "arrayOfStringParm", "arrayOfStruct", "arrayOfStructParm", "arrayOfTimeParm", "arrayOfTimestampParm", "arrayOfUnsignedByteParm", "arrayOfUnsignedIntParm", "arrayOfUnsignedLongParm", "arrayOfUnsignedShortParm", "arrayOfZonedDecimalParm"};
            for (int i = 0; i < types.length; ++i) {
                knownArrayTypes_.add(types[i]);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return knownArrayTypes_;
        }
    }
}

