/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.doris;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.databases.mysql.MySqlDatabaseMeta;

@DatabaseMetaPlugin(type="DORIS", typeDescription="Apache Doris", image="doris.svg", documentationUrl="/database/databases/doris.html")
@GuiPlugin(id="GUI-DorisDatabaseMeta")
public class DorisDatabaseMeta
extends MySqlDatabaseMeta {
    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCR) {
        Object retval = "";
        String fieldname = v.getName();
        if (v.getLength() == 9999999) {
            v.setLength(this.getMaxTextFieldLength());
        }
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = (String)retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = (String)retval + "DATETIME";
                break;
            }
            case 4: {
                if (this.isSupportsBooleanDataType()) {
                    retval = (String)retval + "BOOLEAN";
                    break;
                }
                retval = (String)retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (useAutoinc) {
                        retval = (String)retval + "BIGINT AUTO_INCREMENT NOT NULL PRIMARY KEY";
                        break;
                    }
                    retval = (String)retval + "BIGINT NOT NULL PRIMARY KEY";
                    break;
                }
                if (type == 5) {
                    if (length < 3) {
                        retval = (String)retval + "TINYINT";
                        break;
                    }
                    if (length < 5) {
                        retval = (String)retval + "SMALLINT";
                        break;
                    }
                    if (length < 10) {
                        retval = (String)retval + "INT";
                        break;
                    }
                    if (length < 20) {
                        retval = (String)retval + "BIGINT";
                        break;
                    }
                    retval = (String)retval + "DECIMAL(" + length + ")";
                    break;
                }
                if (type == 6) {
                    if (length < 1) {
                        length = 16;
                    }
                    if (precision < 1) {
                        precision = 16;
                    }
                    retval = (String)retval + "DECIMAL(" + length + "," + precision + ")";
                    break;
                }
                retval = (String)retval + "DOUBLE";
                break;
            }
            case 2: {
                if (length > 0) {
                    if (length == 1) {
                        retval = (String)retval + "CHAR(1)";
                        break;
                    }
                    if (length < 65533) {
                        retval = (String)retval + "VARCHAR(" + length + ")";
                        break;
                    }
                    retval = (String)retval + "STRING";
                    break;
                }
                retval = (String)retval + "STRING";
                break;
            }
            case 8: {
                retval = (String)retval + "BITMAP";
                break;
            }
            default: {
                retval = (String)retval + " UNKNOWN";
            }
        }
        if (addCR) {
            retval = (String)retval + Const.CR;
        }
        return retval;
    }
}

