/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.direct;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.derbyTesting.system.oe.model.Address;

class StatementHelper {
    protected final Connection conn;
    private Map<String, PreparedStatement> statements = new IdentityHashMap<String, PreparedStatement>();

    StatementHelper(Connection connection, boolean bl, int n) throws SQLException {
        this.conn = connection;
        connection.setAutoCommit(bl);
        connection.setTransactionIsolation(n);
    }

    protected PreparedStatement prepareStatement(String string) throws SQLException {
        PreparedStatement preparedStatement = this.statements.get(string);
        if (preparedStatement != null) {
            return preparedStatement;
        }
        preparedStatement = this.conn.prepareStatement(string, 1003, 1007, 2);
        this.statements.put(string, preparedStatement);
        return preparedStatement;
    }

    public void close() throws SQLException {
        for (PreparedStatement preparedStatement : this.statements.values()) {
            preparedStatement.close();
        }
    }

    protected void reset(PreparedStatement preparedStatement) throws SQLException {
        ResultSet resultSet = preparedStatement.getResultSet();
        if (resultSet != null) {
            resultSet.close();
        }
        preparedStatement.clearParameters();
    }

    protected Address getAddress(ResultSet resultSet, String string) throws SQLException {
        return this.getAddress(new Address(), resultSet, string);
    }

    protected Address getAddress(Address address, ResultSet resultSet, String string) throws SQLException {
        address.clear();
        int n = resultSet.findColumn(string);
        address.setStreet1(resultSet.getString(n++));
        address.setStreet2(resultSet.getString(n++));
        address.setCity(resultSet.getString(n++));
        address.setState(resultSet.getString(n++));
        address.setZip(resultSet.getString(n));
        return address;
    }
}

