/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memory;

import java.io.IOException;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class MultiByteClobTest
extends BaseJDBCTestCase {
    private static final int LONG_CLOB_LENGTH = 9000000;
    private static final int SHORT_CLOB_LENGTH = 100;
    private static final String LONG_CLOB_LENGTH_STRING = "9000000";
    private static final String SHORT_CLOB_LENGTH_STRING = "100";

    public MultiByteClobTest(String string) {
        super(string);
    }

    public void testSmallMultiByteCharLob() throws SQLException, IOException {
        int n;
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO MB_CLOBTABLE VALUES(?,?)");
        preparedStatement.setInt(1, 1);
        LoopingAlphabetReader loopingAlphabetReader = new LoopingAlphabetReader(100L, CharAlphabet.cjkSubset());
        preparedStatement.setCharacterStream(2, (Reader)loopingAlphabetReader, 100);
        preparedStatement.executeUpdate();
        ResultSet resultSet = statement.executeQuery("SELECT K, LENGTH(C), C FROM MB_CLOBTABLE-- DERBY-PROPERTIES constraint=pk\n ORDER BY K");
        resultSet.next();
        MultiByteClobTest.assertEquals((String)SHORT_CLOB_LENGTH_STRING, (String)resultSet.getString(2));
        Reader reader = resultSet.getCharacterStream(3);
        int n2 = 0;
        char[] cArray = new char[32672];
        while ((n = reader.read(cArray)) != -1) {
            int n3 = ((n2 += n) - 1) % 12 + 19968;
            if (n == 0) continue;
            MultiByteClobTest.assertEquals((int)n3, (int)cArray[n - 1]);
        }
        MultiByteClobTest.assertEquals((int)100, (int)n2);
        resultSet.close();
        resultSet = statement.executeQuery("SELECT K, LENGTH(C)  FROM MB_CLOBTABLE ORDER BY K");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", SHORT_CLOB_LENGTH_STRING}});
    }

    public void testLargeMultiByteCharLob() throws SQLException, IOException {
        int n;
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO MB_CLOBTABLE VALUES(?,?)");
        preparedStatement.setInt(1, 1);
        LoopingAlphabetReader loopingAlphabetReader = new LoopingAlphabetReader(9000000L, CharAlphabet.cjkSubset());
        preparedStatement.setCharacterStream(2, (Reader)loopingAlphabetReader, 9000000);
        preparedStatement.executeUpdate();
        ResultSet resultSet = statement.executeQuery("SELECT K, LENGTH(C), C FROM MB_CLOBTABLE-- DERBY-PROPERTIES constraint=pk\n ORDER BY K");
        resultSet.next();
        MultiByteClobTest.assertEquals((String)LONG_CLOB_LENGTH_STRING, (String)resultSet.getString(2));
        Reader reader = resultSet.getCharacterStream(3);
        int n2 = 0;
        char[] cArray = new char[32672];
        while ((n = reader.read(cArray)) != -1) {
            int n3 = ((n2 += n) - 1) % 12 + 19968;
            if (n == 0) continue;
            MultiByteClobTest.assertEquals((int)n3, (int)cArray[n - 1]);
        }
        MultiByteClobTest.assertEquals((int)9000000, (int)n2);
        resultSet.close();
        resultSet = statement.executeQuery("SELECT K, LENGTH(C)  FROM MB_CLOBTABLE ORDER BY K");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", LONG_CLOB_LENGTH_STRING}});
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("MultiByteClobTest");
        baseTestSuite.addTest(MultiByteClobTest.baseSuite("MultiByteClobTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(MultiByteClobTest.baseSuite("MultiByteClobTest:client")));
        Properties properties = new Properties();
        properties.setProperty("derby.storage.pageCacheSize", SHORT_CLOB_LENGTH_STRING);
        return new SystemPropertyTestSetup((Test)baseTestSuite, properties);
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(MultiByteClobTest.class);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)baseTestSuite, 2, 4)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("CREATE TABLE MB_CLOBTABLE (K INT CONSTRAINT PK PRIMARY KEY, C CLOB(9000000))");
            }
        };
    }
}

