/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class NestedWhereSubqueryTest
extends BaseJDBCTestCase {
    public NestedWhereSubqueryTest(String string) {
        super(string);
    }

    public void testBasicOperations() throws SQLException {
        Statement statement = this.createStatement();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE departments ( ");
        stringBuffer.append("ID INTEGER NOT NULL, ");
        stringBuffer.append("NAME VARCHAR(32) NOT NULL, ");
        stringBuffer.append("COMPANYID INTEGER, ");
        stringBuffer.append("CONSTRAINT DEPTS_PK PRIMARY KEY (ID) ");
        stringBuffer.append(")");
        statement.executeUpdate(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE employees ( ");
        stringBuffer.append("EMPID INTEGER NOT NULL, ");
        stringBuffer.append("FIRSTNAME VARCHAR(32) NOT NULL, ");
        stringBuffer.append("DEPARTMENT INTEGER, ");
        stringBuffer.append("CONSTRAINT PERS_DEPT_FK FOREIGN KEY (DEPARTMENT) REFERENCES departments, ");
        stringBuffer.append("CONSTRAINT EMPS_PK PRIMARY KEY (EMPID) ");
        stringBuffer.append(")");
        statement.executeUpdate(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE projects ( ");
        stringBuffer.append("PROJID INTEGER NOT NULL, ");
        stringBuffer.append("NAME VARCHAR(32) NOT NULL, ");
        stringBuffer.append("CONSTRAINT PROJS_PK PRIMARY KEY (PROJID) ");
        stringBuffer.append(")");
        statement.executeUpdate(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE project_employees ( ");
        stringBuffer.append("PROJID INTEGER REFERENCES projects NOT NULL, ");
        stringBuffer.append("EMPID INTEGER REFERENCES employees NOT NULL ");
        stringBuffer.append(")");
        statement.executeUpdate(stringBuffer.toString());
        statement.executeUpdate("INSERT INTO departments VALUES (1, 'Research', 1)");
        statement.executeUpdate("INSERT INTO departments VALUES (2, 'Marketing', 1)");
        statement.executeUpdate("INSERT INTO employees VALUES (11, 'Alex', 1)");
        statement.executeUpdate("INSERT INTO employees VALUES (12, 'Bill', 1)");
        statement.executeUpdate("INSERT INTO employees VALUES (13, 'Charles', 1)");
        statement.executeUpdate("INSERT INTO employees VALUES (14, 'David', 2)");
        statement.executeUpdate("INSERT INTO employees VALUES (15, 'Earl', 2)");
        statement.executeUpdate("INSERT INTO projects VALUES (101, 'red')");
        statement.executeUpdate("INSERT INTO projects VALUES (102, 'orange')");
        statement.executeUpdate("INSERT INTO projects VALUES (103, 'yellow')");
        statement.executeUpdate("INSERT INTO project_employees VALUES (102, 13)");
        statement.executeUpdate("INSERT INTO project_employees VALUES (101, 13)");
        statement.executeUpdate("INSERT INTO project_employees VALUES (102, 12)");
        statement.executeUpdate("INSERT INTO project_employees VALUES (103, 15)");
        statement.executeUpdate("INSERT INTO project_employees VALUES (103, 14)");
        statement.executeUpdate("INSERT INTO project_employees VALUES (101, 12)");
        statement.executeUpdate("INSERT INTO project_employees VALUES (101, 11)");
        ResultSet resultSet = statement.executeQuery("select * from employees");
        String[][] stringArray = new String[][]{{"11", "Alex", "1"}, {"12", "Bill", "1"}, {"13", "Charles", "1"}, {"14", "David", "2"}, {"15", "Earl", "2"}};
        JDBC.assertUnorderedResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from departments");
        stringArray = new String[][]{{"1", "Research", "1"}, {"2", "Marketing", "1"}};
        JDBC.assertUnorderedResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from projects");
        stringArray = new String[][]{{"101", "red"}, {"102", "orange"}, {"103", "yellow"}};
        JDBC.assertUnorderedResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from project_employees");
        stringArray = new String[][]{{"102", "13"}, {"101", "13"}, {"102", "12"}, {"103", "15"}, {"103", "14"}, {"101", "12"}, {"101", "11"}};
        JDBC.assertUnorderedResultSet(resultSet, stringArray);
        stringBuffer = new StringBuffer();
        stringBuffer.append("select unbound_e.empid, unbound_p.projid ");
        stringBuffer.append("from departments this, ");
        stringBuffer.append("     employees unbound_e, ");
        stringBuffer.append("     projects unbound_p ");
        stringBuffer.append("where exists ( ");
        stringBuffer.append("  select 1 from employees this_employees_e ");
        stringBuffer.append("  where exists ( ");
        stringBuffer.append("    select 1 from project_employees this_employees_e_projects_p ");
        stringBuffer.append("    where this_employees_e_projects_p.empid = this_employees_e.empid ");
        stringBuffer.append("    and this_employees_e.department = this.id ");
        stringBuffer.append("    and unbound_p.projid = this_employees_e_projects_p.projid ");
        stringBuffer.append("    and unbound_e.empid = this_employees_e.empid) ");
        stringBuffer.append(" )");
        resultSet = statement.executeQuery(stringBuffer.toString());
        stringArray = new String[][]{{"13", "101"}, {"12", "101"}, {"11", "101"}, {"13", "102"}, {"12", "102"}, {"15", "103"}, {"14", "103"}};
        JDBC.assertUnorderedResultSet(resultSet, stringArray);
        stringBuffer = new StringBuffer();
        stringBuffer.append("select unbound_e.empid, unbound_p.projid ");
        stringBuffer.append("from departments this, ");
        stringBuffer.append("     employees unbound_e, ");
        stringBuffer.append("     projects unbound_p ");
        stringBuffer.append("where exists ( ");
        stringBuffer.append(" select 1 from employees this_employees_e ");
        stringBuffer.append("     where this_employees_e.empid in ( ");
        stringBuffer.append("         select this_employees_e_projects_p.empid ");
        stringBuffer.append("           from project_employees this_employees_e_projects_p ");
        stringBuffer.append("         where this_employees_e_projects_p.empid = this_employees_e.empid ");
        stringBuffer.append("         and this_employees_e.department = this.id ");
        stringBuffer.append("         and unbound_p.projid = this_employees_e_projects_p.projid ");
        stringBuffer.append("         and unbound_e.empid = this_employees_e.empid) ");
        stringBuffer.append("     )");
        resultSet = statement.executeQuery(stringBuffer.toString());
        JDBC.assertUnorderedResultSet(resultSet, stringArray);
        stringBuffer = new StringBuffer();
        stringBuffer.append("select unbound_e.empid, unbound_p.projid ");
        stringBuffer.append("from departments this, ");
        stringBuffer.append("     employees unbound_e, ");
        stringBuffer.append("     projects unbound_p ");
        stringBuffer.append("where exists ( ");
        stringBuffer.append(" select 1 from employees this_employees_e ");
        stringBuffer.append("     where this_employees_e.empid = any ( ");
        stringBuffer.append("         select this_employees_e_projects_p.empid ");
        stringBuffer.append("           from project_employees this_employees_e_projects_p ");
        stringBuffer.append("         where this_employees_e_projects_p.empid = this_employees_e.empid ");
        stringBuffer.append("         and this_employees_e.department = this.id ");
        stringBuffer.append("         and unbound_p.projid = this_employees_e_projects_p.projid ");
        stringBuffer.append("         and unbound_e.empid = this_employees_e.empid) ");
        stringBuffer.append("     )");
        resultSet = statement.executeQuery(stringBuffer.toString());
        JDBC.assertUnorderedResultSet(resultSet, stringArray);
        stringBuffer = new StringBuffer();
        stringBuffer.append("select unbound_e.empid from departments this, employees unbound_e ");
        stringBuffer.append("where exists ( ");
        stringBuffer.append("   select 1 from employees this_employees_e ");
        stringBuffer.append("      where this_employees_e.department = this.id and ");
        stringBuffer.append("            unbound_e.empid = this_employees_e.empid and this.id = 2)");
        resultSet = statement.executeQuery(stringBuffer.toString());
        stringArray = new String[][]{{"14"}, {"15"}};
        JDBC.assertUnorderedResultSet(resultSet, stringArray);
        stringBuffer = new StringBuffer();
        stringBuffer.append("select this.id,unbound_e.empid,unbound_p.projid from departments this, ");
        stringBuffer.append("        employees unbound_e, projects unbound_p ");
        stringBuffer.append("where exists ( ");
        stringBuffer.append("   select 1 from employees this_employees_e ");
        stringBuffer.append("   where exists ( ");
        stringBuffer.append("      select 1 from project_employees this_employees_e_projects_p ");
        stringBuffer.append("      where this_employees_e_projects_p.\"EMPID\" = this_employees_e.empid and ");
        stringBuffer.append("         unbound_p.projid = this_employees_e_projects_p.projid and ");
        stringBuffer.append("         this_employees_e.department = this.id and ");
        stringBuffer.append("         unbound_e.empid = this_employees_e.empid ");
        stringBuffer.append(" )) ");
        resultSet = statement.executeQuery(stringBuffer.toString());
        stringArray = new String[][]{{"1", "11", "101"}, {"1", "12", "101"}, {"1", "13", "101"}, {"1", "12", "102"}, {"1", "13", "102"}, {"2", "14", "103"}, {"2", "15", "103"}};
        JDBC.assertUnorderedResultSet(resultSet, stringArray);
        stringBuffer = new StringBuffer();
        stringBuffer.append("select unbound_e.empid,unbound_p.projid from departments this, ");
        stringBuffer.append("       employees unbound_e, projects unbound_p ");
        stringBuffer.append("where exists ( ");
        stringBuffer.append("   select 1 from employees this_employees_e ");
        stringBuffer.append("   where exists ( ");
        stringBuffer.append("      select 1 from project_employees this_employees_e_projects_p ");
        stringBuffer.append("      where this_employees_e_projects_p.\"EMPID\" = this_employees_e.empid ");
        stringBuffer.append("            and unbound_p.projid = this_employees_e_projects_p.projid ");
        stringBuffer.append("            and this_employees_e.department = this.id ");
        stringBuffer.append("            and unbound_e.empid = this_employees_e.empid ");
        stringBuffer.append("            and this.id = 1)) ");
        resultSet = statement.executeQuery(stringBuffer.toString());
        stringArray = new String[][]{{"11", "101"}, {"12", "101"}, {"13", "101"}, {"12", "102"}, {"13", "102"}};
        JDBC.assertUnorderedResultSet(resultSet, stringArray);
        stringBuffer = new StringBuffer();
        stringBuffer.append("select unbound_e.empid,unbound_p.projid from departments this, ");
        stringBuffer.append("       employees unbound_e, projects unbound_p ");
        stringBuffer.append("where exists ( ");
        stringBuffer.append("   select 1 from employees this_employees_e ");
        stringBuffer.append("   where exists ( ");
        stringBuffer.append("      select 1 from project_employees this_employees_e_projects_p ");
        stringBuffer.append("      where this_employees_e_projects_p.\"EMPID\" = this_employees_e.empid ");
        stringBuffer.append("            and unbound_p.projid = this_employees_e_projects_p.projid ");
        stringBuffer.append("            and this_employees_e.department = this.id ");
        stringBuffer.append("            and unbound_e.empid = this_employees_e.empid ");
        stringBuffer.append("            and this.companyid = 1))");
        resultSet = statement.executeQuery(stringBuffer.toString());
        stringArray = new String[][]{{"11", "101"}, {"12", "101"}, {"13", "101"}, {"12", "102"}, {"13", "102"}, {"14", "103"}, {"15", "103"}};
        JDBC.assertUnorderedResultSet(resultSet, stringArray);
        stringBuffer = new StringBuffer();
        stringBuffer.append("select unbound_e.empid, unbound_p.projid ");
        stringBuffer.append("from departments this, ");
        stringBuffer.append("     employees unbound_e, ");
        stringBuffer.append("     projects unbound_p ");
        stringBuffer.append("where exists ( ");
        stringBuffer.append("   select 1 from employees this_employees_e ");
        stringBuffer.append("   where 1 = 1 and exists ( ");
        stringBuffer.append("      select 1 from project_employees this_employees_e_projects_p ");
        stringBuffer.append("      where this_employees_e_projects_p.empid = this_employees_e.empid ");
        stringBuffer.append("            and this_employees_e.department = this.id ");
        stringBuffer.append("            and unbound_p.projid = this_employees_e_projects_p.projid ");
        stringBuffer.append("            and unbound_e.empid = this_employees_e.empid) ");
        stringBuffer.append(")");
        resultSet = statement.executeQuery(stringBuffer.toString());
        stringArray = new String[][]{{"11", "101"}, {"12", "101"}, {"13", "101"}, {"12", "102"}, {"13", "102"}, {"14", "103"}, {"15", "103"}};
        JDBC.assertUnorderedResultSet(resultSet, stringArray);
        stringBuffer = new StringBuffer();
        stringBuffer.append("select unbound_e.empid, unbound_p.projid ");
        stringBuffer.append("from departments this, employees unbound_e, projects unbound_p ");
        stringBuffer.append("where this.id in ( ");
        stringBuffer.append("   select this_employees_e.department from employees this_employees_e ");
        stringBuffer.append("   where this_employees_e.empid in ( ");
        stringBuffer.append("      select this_employees_e_projects_p.empid ");
        stringBuffer.append("      from project_employees this_employees_e_projects_p ");
        stringBuffer.append("      where this_employees_e_projects_p.empid = this_employees_e.empid ");
        stringBuffer.append("            and this_employees_e.department = this.id ");
        stringBuffer.append("            and unbound_p.projid = this_employees_e_projects_p.projid ");
        stringBuffer.append("            and unbound_e.empid = this_employees_e.empid)");
        stringBuffer.append(")");
        resultSet = statement.executeQuery(stringBuffer.toString());
        JDBC.assertUnorderedResultSet(resultSet, stringArray);
        stringBuffer = new StringBuffer();
        stringBuffer.append("select unbound_e.empid, unbound_p.projid ");
        stringBuffer.append("from departments this, employees unbound_e, projects unbound_p ");
        stringBuffer.append("where this.id = any ( ");
        stringBuffer.append("   select this_employees_e.department from employees this_employees_e ");
        stringBuffer.append("   where this_employees_e.empid = any ( ");
        stringBuffer.append("      select this_employees_e_projects_p.empid ");
        stringBuffer.append("      from project_employees this_employees_e_projects_p ");
        stringBuffer.append("      where this_employees_e_projects_p.empid = this_employees_e.empid ");
        stringBuffer.append("            and this_employees_e.department = this.id ");
        stringBuffer.append("            and unbound_p.projid = this_employees_e_projects_p.projid ");
        stringBuffer.append("            and unbound_e.empid = this_employees_e.empid)");
        stringBuffer.append(")");
        resultSet = statement.executeQuery(stringBuffer.toString());
        JDBC.assertUnorderedResultSet(resultSet, stringArray);
        statement.executeUpdate("create table a (aa int, bb int)");
        statement.executeUpdate("create table b (bb int)");
        statement.executeUpdate("insert into a values (1,1),(1,2),(2,2)");
        statement.executeUpdate("insert into b values (1)");
        stringBuffer = new StringBuffer();
        stringBuffer.append("select * from a ");
        stringBuffer.append("where not exists ");
        stringBuffer.append("(select bb from (select bb from b) p where a.bb=p.bb)");
        resultSet = statement.executeQuery(stringBuffer.toString());
        stringArray = new String[][]{{"1", "2"}, {"2", "2"}};
        JDBC.assertUnorderedResultSet(resultSet, stringArray);
        stringBuffer = new StringBuffer();
        stringBuffer.append("select * from a ");
        stringBuffer.append("where exists ");
        stringBuffer.append("(select bb from (select bb from b) p where a.bb=p.bb)");
        resultSet = statement.executeQuery(stringBuffer.toString());
        stringArray = new String[][]{{"1", "1"}};
        JDBC.assertUnorderedResultSet(resultSet, stringArray);
        statement.executeUpdate("drop table project_employees");
        statement.executeUpdate("drop table projects");
        statement.executeUpdate("drop table employees");
        statement.executeUpdate("drop table departments");
        statement.executeUpdate("drop table a");
        statement.executeUpdate("drop table b");
        statement.close();
    }

    public void testDerby5501() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t5501a(i int, j int, primary key(i,j))");
        statement.executeUpdate("create table t5501b(i int)");
        statement.executeUpdate("insert into t5501a values (1,1),(2,2),(3,3),(4,4)");
        statement.executeUpdate("insert into t5501b values 1,3,5");
        ResultSet resultSet = statement.executeQuery("select i from t5501b t1 where not exists     (select i from t5501a t2 where t1.i=t2.i)");
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"5"}});
        resultSet = statement.executeQuery("select i+3.14 from t5501b t1 where not exists     (select i+3.14 from t5501a t2 where t1.i=t2.i)");
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"8.14"}});
        resultSet = statement.executeQuery("select i from t5501b t1 where not exists     (select * from t5501a t2 where t1.i=t2.i)");
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"5"}});
        resultSet = statement.executeQuery("select i from t5501b t1 where not exists     (select i,j from t5501a t2 where t1.i=t2.i)");
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"5"}});
        resultSet = statement.executeQuery("select i from t5501b t1 where not exists     (select true,j from t5501a t2 where t1.i=t2.i)");
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"5"}});
        statement.executeUpdate("delete from t5501a where i=1");
        resultSet = statement.executeQuery("select i from t5501b t1 where not exists     (select i,j from t5501a t2 where t1.i=t2.i)");
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"1"}, {"5"}});
        this.assertCompileError("42X04", "select i from t5501b t1 where not exists     (select i,k from t5501a t2 where t1.i=t2.i)");
        this.assertCompileError("42X10", "select i from t5501b t1 where not exists     (select t2.*,foo.* from t5501a t2 where t1.i=t2.i)");
        this.assertCompileError("22018", "select i from t5501b t1 where not exists    (select t2.*,cast('a' as int) from t5501a t2 where t1.i=t2.i)");
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(NestedWhereSubqueryTest.class);
    }
}

