/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ConstantExpressionTest
extends BaseJDBCTestCase {
    public ConstantExpressionTest(String string) throws SQLException {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(ConstantExpressionTest.class);
    }

    public void setUp() throws SQLException {
        String string = "create table t1(c1 int)";
        Statement statement = this.createStatement();
        statement.executeUpdate(string);
        string = "insert into t1 values 1, 2, 3";
        ConstantExpressionTest.assertEquals((String)"Fail to insert into table", (int)3, (int)statement.executeUpdate(string));
        statement.close();
    }

    @Override
    public void tearDown() throws Exception {
        this.dropTable("t1");
        super.tearDown();
    }

    public void testFalseConstantExpressions() throws SQLException {
        ResultSet resultSet;
        Object object;
        String[] stringArray = new String[]{"1 <> 1", "1 = 1 and 1 = 0", "1 = (2 + 3 - 2)", "(case when 1 = 1 then 0 else 1 end) = 1", "1 in (2, 3, 4)", "1 between 2 and 3"};
        Statement statement = this.createStatement(1004, 1007);
        for (int i = 0; i < stringArray.length; ++i) {
            object = "select * from t1 where " + stringArray[i];
            resultSet = statement.executeQuery((String)object);
            JDBC.assertEmpty(resultSet);
        }
        statement.close();
        object = "select * from t1 where ? = 1";
        PreparedStatement preparedStatement = this.prepareStatement((String)object);
        preparedStatement.setInt(1, 0);
        resultSet = preparedStatement.executeQuery();
        JDBC.assertEmpty(resultSet);
        preparedStatement.close();
        object = "select * from t1 where cast(? as int) = 1";
        PreparedStatement preparedStatement2 = this.prepareStatement((String)object);
        preparedStatement2.setInt(1, 0);
        resultSet = preparedStatement2.executeQuery();
        JDBC.assertEmpty(resultSet);
        preparedStatement2.close();
    }

    public void testTrueConstantExpressions() throws SQLException {
        ResultSet resultSet;
        Object object;
        String[] stringArray = new String[]{"1 = 1", "1 = 0 or 1 = 1", "1 + 2 = (2 + 3 - 2)", "(case when 1 = 1 then 1 else 0 end) = 1", "1 in (2, 3, 4, 4, 3, 2, 1)", "1 + 1 between 0 and 3"};
        String[][] stringArray2 = new String[][]{{"1"}, {"2"}, {"3"}};
        Statement statement = this.createStatement(1004, 1007);
        for (int i = 0; i < stringArray.length; ++i) {
            object = "select * from t1 where " + stringArray[i];
            resultSet = statement.executeQuery((String)object);
            JDBC.assertFullResultSet(resultSet, stringArray2);
        }
        statement.close();
        object = "select * from t1 where ? = 1";
        PreparedStatement preparedStatement = this.prepareStatement((String)object);
        preparedStatement.setInt(1, 1);
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, stringArray2);
        preparedStatement.close();
        object = "select * from t1 where cast(? as int) = 1";
        PreparedStatement preparedStatement2 = this.prepareStatement((String)object);
        preparedStatement2.setInt(1, 1);
        resultSet = preparedStatement2.executeQuery();
        JDBC.assertFullResultSet(resultSet, stringArray2);
        preparedStatement2.close();
    }
}

