/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import io.netty.util.internal.MathUtil;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class LongHashSet
extends AbstractSet<Long>
implements Serializable {
    public static final int DEFAULT_INITIAL_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    static final long MISSING_VALUE = -2L;
    private boolean containsMissingValue;
    private final float loadFactor;
    private int resizeThreshold;
    private int sizeOfArrayValues;
    private long[] values;

    public LongHashSet() {
        this(8);
    }

    public LongHashSet(int proposedCapacity) {
        this(proposedCapacity, 0.5f);
    }

    private static int hashIndex(long value, int mask) {
        return LongHashSet.hashCode(value) & mask;
    }

    private static int hashCode(long value) {
        long hash = value * 31L;
        hash = (int)hash ^ (int)(hash >>> 32);
        return (int)hash;
    }

    public LongHashSet(int proposedCapacity, float loadFactor) {
        if (loadFactor < 0.1f || loadFactor > 0.9f) {
            throw new IllegalArgumentException("load factor must be in the range of 0.1 to 0.9: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        this.sizeOfArrayValues = 0;
        int capacity = MathUtil.findNextPositivePowerOfTwo((int)Math.max(8, proposedCapacity));
        this.resizeThreshold = (int)((float)capacity * loadFactor);
        this.values = new long[capacity];
        Arrays.fill(this.values, -2L);
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public boolean add(Long value) {
        return this.add((long)value);
    }

    @Override
    public boolean add(long value) {
        if (value == -2L) {
            boolean previousContainsMissingValue = this.containsMissingValue;
            this.containsMissingValue = true;
            return !previousContainsMissingValue;
        }
        long[] values = this.values;
        int mask = values.length - 1;
        int index = LongHashSet.hashIndex(value, mask);
        while (values[index] != -2L) {
            if (values[index] == value) {
                return false;
            }
            index = LongHashSet.next(index, mask);
        }
        values[index] = value;
        ++this.sizeOfArrayValues;
        if (this.sizeOfArrayValues > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return true;
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length * 2;
        if (newCapacity < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size());
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int capacity = newCapacity;
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        long[] tempValues = new long[capacity];
        Arrays.fill(tempValues, -2L);
        for (long value : this.values) {
            if (value == -2L) continue;
            int newHash = LongHashSet.hashIndex(value, mask);
            while (tempValues[newHash] != -2L) {
                ++newHash;
                newHash &= mask;
            }
            tempValues[newHash] = value;
        }
        this.values = tempValues;
    }

    @Override
    public boolean remove(Object value) {
        Long l;
        return value instanceof Long && this.remove(l = (Long)value);
    }

    public boolean remove(long value) {
        if (value == -2L) {
            boolean previousContainsMissingValue = this.containsMissingValue;
            this.containsMissingValue = false;
            return previousContainsMissingValue;
        }
        long[] values = this.values;
        int mask = values.length - 1;
        int index = LongHashSet.hashIndex(value, mask);
        while (values[index] != -2L) {
            if (values[index] == value) {
                values[index] = -2L;
                this.compactChain(index);
                --this.sizeOfArrayValues;
                return true;
            }
            index = LongHashSet.next(index, mask);
        }
        return false;
    }

    private static int next(int index, int mask) {
        return index + 1 & mask;
    }

    private void compactChain(int deleteIndex) {
        long[] values = this.values;
        int mask = values.length - 1;
        int index = deleteIndex;
        while (values[index = LongHashSet.next(index, mask)] != -2L) {
            int hash = LongHashSet.hashIndex(values[index], mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            values[deleteIndex] = values[index];
            values[index] = -2L;
            deleteIndex = index;
        }
        return;
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(MathUtil.findNextPositivePowerOfTwo((int)Math.max(8, idealCapacity)));
    }

    @Override
    public boolean contains(Object value) {
        Long l;
        return value instanceof Long && this.contains(l = (Long)value);
    }

    public boolean contains(long value) {
        if (value == -2L) {
            return this.containsMissingValue;
        }
        long[] values = this.values;
        int mask = values.length - 1;
        int index = LongHashSet.hashIndex(value, mask);
        while (values[index] != -2L) {
            if (values[index] == value) {
                return true;
            }
            index = LongHashSet.next(index, mask);
        }
        return false;
    }

    @Override
    public int size() {
        return this.sizeOfArrayValues + (this.containsMissingValue ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        if (this.size() > 0) {
            Arrays.fill(this.values, -2L);
            this.sizeOfArrayValues = 0;
            this.containsMissingValue = false;
        }
    }

    @Override
    public boolean addAll(Collection<? extends Long> coll) {
        boolean added = false;
        for (Long l : coll) {
            added |= this.add(l);
        }
        return added;
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        boolean removed = false;
        for (Object value : coll) {
            removed |= this.remove(value);
        }
        return removed;
    }

    public LongIterator iterator() {
        return new LongIterator().reset();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (long value : this.values) {
            if (value == -2L) continue;
            sb.append(value).append(", ");
        }
        if (this.containsMissingValue) {
            sb.append(-2L).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        Class<Long> componentType = a.getClass().getComponentType();
        if (!componentType.isAssignableFrom(Long.class)) {
            throw new ArrayStoreException("cannot store Longs in array of type " + String.valueOf(componentType));
        }
        int size = this.size();
        Object[] arrayCopy = a.length >= size ? a : (Object[])Array.newInstance(componentType, size);
        this.copyValues(arrayCopy);
        return arrayCopy;
    }

    @Override
    public Object[] toArray() {
        Object[] arrayCopy = new Object[this.size()];
        this.copyValues(arrayCopy);
        return arrayCopy;
    }

    private void copyValues(Object[] arrayCopy) {
        long[] values;
        int i = 0;
        for (long value : values = this.values) {
            if (-2L == value) continue;
            arrayCopy[i++] = value;
        }
        if (this.containsMissingValue) {
            arrayCopy[this.sizeOfArrayValues] = -2L;
        }
    }

    public boolean containsAll(LongHashSet other) {
        for (long value : other.values) {
            if (value == -2L || this.contains(value)) continue;
            return false;
        }
        return !other.containsMissingValue || this.containsMissingValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LongHashSet) {
            LongHashSet other = (LongHashSet)obj;
            return other.containsMissingValue == this.containsMissingValue && other.sizeOfArrayValues == this.sizeOfArrayValues && this.containsAll(other);
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        Set c = (Set)obj;
        if (c.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(c);
        }
        catch (ClassCastException | NullPointerException ignore) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (long value : this.values) {
            if (value == -2L) continue;
            hashCode += Long.hashCode(value);
        }
        if (this.containsMissingValue) {
            int code = Long.hashCode(-2L);
            hashCode += code;
        }
        return hashCode;
    }

    public final class LongIterator
    implements Iterator<Long>,
    Serializable {
        private int remaining;
        private int positionCounter;
        private int stopCounter;
        private boolean isPositionValid = false;

        LongIterator reset() {
            int length;
            this.remaining = LongHashSet.this.size();
            long[] values = LongHashSet.this.values;
            int i = length = values.length;
            if (values[length - 1] != -2L) {
                for (i = 0; i < length && values[i] != -2L; ++i) {
                }
            }
            this.stopCounter = i;
            this.positionCounter = i + length;
            this.isPositionValid = false;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        public int remaining() {
            return this.remaining;
        }

        @Override
        public Long next() {
            return this.nextValue();
        }

        public long nextValue() {
            if (this.remaining == 1 && LongHashSet.this.containsMissingValue) {
                this.remaining = 0;
                this.isPositionValid = true;
                return -2L;
            }
            this.findNext();
            long[] values = LongHashSet.this.values;
            return values[this.position(values)];
        }

        @Override
        public void remove() {
            if (this.isPositionValid) {
                if (0 == this.remaining && LongHashSet.this.containsMissingValue) {
                    LongHashSet.this.containsMissingValue = false;
                } else {
                    long[] values = LongHashSet.this.values;
                    int position = this.position(values);
                    values[position] = -2L;
                    --LongHashSet.this.sizeOfArrayValues;
                    LongHashSet.this.compactChain(position);
                }
            } else {
                throw new IllegalStateException();
            }
            this.isPositionValid = false;
        }

        private void findNext() {
            long[] values = LongHashSet.this.values;
            int mask = values.length - 1;
            this.isPositionValid = true;
            for (int i = this.positionCounter - 1; i >= this.stopCounter; --i) {
                int index = i & mask;
                if (values[index] == -2L) continue;
                this.positionCounter = i;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new NoSuchElementException();
        }

        private int position(long[] values) {
            return this.positionCounter & values.length - 1;
        }
    }
}

