/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import java.util.Collections;
import java.util.Map;
import org.apache.activemq.artemis.api.core.QueueAttributes;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.utils.uri.URISupport;

public class ParameterisedAddress {
    private final SimpleString address;
    private final QueueConfiguration queueConfiguration;

    public static SimpleString toParameterisedAddress(SimpleString address, Map<String, String> parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            return SimpleString.of(ParameterisedAddress.toParameterisedAddress(address.toString(), parameters));
        }
        return address;
    }

    public static String toParameterisedAddress(String address, Map<String, String> parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            return URISupport.appendParameters(new StringBuilder(address), parameters).toString();
        }
        return address;
    }

    public SimpleString getAddress() {
        return this.address;
    }

    @Deprecated
    public QueueAttributes getQueueAttributes() {
        return QueueAttributes.fromQueueConfiguration(this.queueConfiguration);
    }

    public QueueConfiguration getQueueConfiguration() {
        return this.queueConfiguration;
    }

    @Deprecated
    public ParameterisedAddress(SimpleString address, QueueAttributes queueAttributes) {
        this.address = address;
        this.queueConfiguration = queueAttributes.toQueueConfiguration();
    }

    public ParameterisedAddress(SimpleString address, QueueConfiguration queueConfiguration) {
        this.address = address;
        this.queueConfiguration = queueConfiguration;
    }

    @Deprecated
    public ParameterisedAddress(String address, QueueAttributes queueAttributes) {
        this(SimpleString.of(address), queueAttributes.toQueueConfiguration());
    }

    public ParameterisedAddress(String address, QueueConfiguration queueConfiguration) {
        this(SimpleString.of(address), queueConfiguration);
    }

    public ParameterisedAddress(SimpleString address) {
        this(address.toString());
    }

    public ParameterisedAddress(String address) {
        int index = address.indexOf(63);
        if (index == -1) {
            this.address = SimpleString.of(address);
            this.queueConfiguration = null;
        } else {
            this.address = SimpleString.of(address.substring(0, index));
            QueueConfiguration queueConfiguration = QueueConfiguration.of(address);
            URISupport.parseQuery(address).forEach(queueConfiguration::set);
            this.queueConfiguration = queueConfiguration;
        }
    }

    public boolean isParameterised() {
        return this.queueConfiguration != null;
    }

    public static boolean isParameterised(String address) {
        return URISupport.containsQuery(address);
    }

    public static boolean isParameterised(SimpleString address) {
        return URISupport.containsQuery(address);
    }

    public static SimpleString extractAddress(SimpleString address) {
        return SimpleString.of(ParameterisedAddress.extractAddress(address.toString()));
    }

    public static Map<String, String> extractParameters(String address) {
        int index;
        int n = index = address != null ? address.indexOf(63) : -1;
        if (index == -1) {
            return Collections.EMPTY_MAP;
        }
        return URISupport.parseQuery(address);
    }

    public static String extractAddress(String address) {
        int index;
        int n = index = address != null ? address.indexOf(63) : -1;
        if (index == -1) {
            return address;
        }
        return address.substring(0, index);
    }
}

