/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.common;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.oidc.common.AbstractUserInfo;

public class IdToken
extends AbstractUserInfo {
    public static final String AUTH_TIME_CLAIM = "auth_time";
    public static final String NONCE_CLAIM = "nonce";
    public static final String ACR_CLAIM = "acr";
    public static final String AZP_CLAIM = "azp";
    public static final String AMR_CLAIM = "amr";
    public static final String ACCESS_TOKEN_HASH_CLAIM = "at_hash";
    public static final String AUTH_CODE_HASH_CLAIM = "c_hash";
    private static final long serialVersionUID = -2243170791872714855L;

    public IdToken() {
    }

    public IdToken(JwtClaims claims) {
        this(claims.asMap());
    }

    public IdToken(Map<String, Object> claims) {
        super(new LinkedHashMap<String, Object>(claims));
    }

    public void setAuthenticationTime(Long time) {
        this.setProperty(AUTH_TIME_CLAIM, time);
    }

    public Long getAuthenticationTime() {
        return this.getLongProperty(AUTH_TIME_CLAIM);
    }

    public void setNonce(String nonce) {
        this.setProperty(NONCE_CLAIM, nonce);
    }

    public String getNonce() {
        return (String)this.getProperty(NONCE_CLAIM);
    }

    public void setAuthenticationContextRef(String ref) {
        this.setProperty(ACR_CLAIM, ref);
    }

    public String getAuthenticationContextRef() {
        return (String)this.getProperty(ACR_CLAIM);
    }

    public void setAuthenticationMethodRefs(List<String> refs) {
        this.setProperty(AMR_CLAIM, refs);
    }

    public List<String> getAuthenticationMethodRefs() {
        return CastUtils.cast((List)((List)this.getProperty(AMR_CLAIM)));
    }

    public void setAuthorizedParty(String azp) {
        this.setProperty(AZP_CLAIM, azp);
    }

    public String getAuthorizedParty() {
        return (String)this.getProperty(AZP_CLAIM);
    }

    public void setAccessTokenHash(String at) {
        this.setProperty(ACCESS_TOKEN_HASH_CLAIM, at);
    }

    public String getAccessTokenHash() {
        return (String)this.getProperty(ACCESS_TOKEN_HASH_CLAIM);
    }

    public void setAuthorizationCodeHash(String at) {
        this.setProperty(AUTH_CODE_HASH_CLAIM, at);
    }

    public String getAuthorizationCodeHash() {
        return (String)this.getProperty(AUTH_CODE_HASH_CLAIM);
    }
}

