/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;
import org.apache.hadoop.fs.Path;

public class ConcatTool
implements Tool {
    @Override
    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        if (args.isEmpty()) {
            this.printHelp(out);
            return 0;
        }
        FilterOutputStream output = out;
        if (args.size() > 1) {
            output = Util.fileOrStdout(args.get(args.size() - 1), out);
            args = args.subList(0, args.size() - 1);
        }
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());
        Schema schema = null;
        TreeMap<String, byte[]> metadata = new TreeMap<String, byte[]>();
        String inputCodec = null;
        for (String inFile : ConcatTool.expandsInputFiles(args)) {
            byte[] metadatum;
            BufferedInputStream input = Util.fileOrStdin(inFile, in);
            DataFileStream reader = new DataFileStream((InputStream)input, (DatumReader)new GenericDatumReader());
            if (schema == null) {
                schema = reader.getSchema();
                for (String key : reader.getMetaKeys()) {
                    if (DataFileWriter.isReservedMeta((String)key)) continue;
                    metadatum = reader.getMeta(key);
                    metadata.put(key, metadatum);
                    writer.setMeta(key, metadatum);
                }
                inputCodec = reader.getMetaString("avro.codec");
                if (inputCodec == null) {
                    inputCodec = "null";
                }
                writer.setCodec(CodecFactory.fromString((String)inputCodec));
                writer.create(schema, (OutputStream)output);
            } else {
                if (!schema.equals((Object)reader.getSchema())) {
                    err.println("input files have different schemas");
                    reader.close();
                    return 1;
                }
                for (String key : reader.getMetaKeys()) {
                    byte[] writersMetadatum;
                    if (DataFileWriter.isReservedMeta((String)key) || Arrays.equals(metadatum = reader.getMeta(key), writersMetadatum = (byte[])metadata.get(key))) continue;
                    err.println("input files have different non-reserved metadata");
                    reader.close();
                    return 2;
                }
                String thisCodec = reader.getMetaString("avro.codec");
                if (thisCodec == null) {
                    thisCodec = "null";
                }
                if (!inputCodec.equals(thisCodec)) {
                    err.println("input files have different codecs");
                    reader.close();
                    return 3;
                }
            }
            writer.appendAllFrom(reader, false);
            reader.close();
        }
        writer.close();
        return 0;
    }

    private static List<String> expandsInputFiles(List<String> args) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        for (String arg : args) {
            if (arg.equals("-")) {
                files.add(arg);
                continue;
            }
            List<Path> paths = Util.getFiles(arg);
            for (Path path : paths) {
                files.add(path.toString());
            }
        }
        return files;
    }

    private void printHelp(PrintStream out) {
        out.println("concat [input-file...] output-file");
        out.println();
        out.println("Concatenates one or more input files into a new output file");
        out.println("by appending the input blocks without decoding them. The input");
        out.println("files must have the same schema, metadata and codec. If they");
        out.println("do not the tool will return the following error codes:");
        out.println("  1 if the schemas don't match");
        out.println("  2 if the metadata doesn't match");
        out.println("  3 if the codecs don't match");
        out.println("If no input files are given stdin will be used. The tool");
        out.println("0 on success. A dash ('-') can be given as an input file");
        out.println("to use stdin, and as an output file to use stdout. If a directory");
        out.println("is given as an input-file all the files within this directory");
        out.println("are used.");
    }

    @Override
    public String getName() {
        return "concat";
    }

    @Override
    public String getShortDescription() {
        return "Concatenates avro files without re-compressing.";
    }
}

