/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.writer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.writer.ILocalFSValidator;
import org.apache.asterix.runtime.writer.IExternalFilePrinter;
import org.apache.asterix.runtime.writer.IExternalFileWriter;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IValueReference;

final class LocalFSExternalFileWriter
implements IExternalFileWriter {
    private final IExternalFilePrinter printer;
    private final ILocalFSValidator validator;
    private final SourceLocation pathSourceLocation;

    LocalFSExternalFileWriter(IExternalFilePrinter printer, ILocalFSValidator validator, SourceLocation pathSourceLocation) {
        this.printer = printer;
        this.validator = validator;
        this.pathSourceLocation = pathSourceLocation;
    }

    public void open() throws HyracksDataException {
        this.printer.open();
    }

    public void validate(String directory) throws HyracksDataException {
        this.validator.validate(directory, this.pathSourceLocation);
    }

    public boolean newFile(String directory, String fileName) throws HyracksDataException {
        try {
            File parentDirectory = new File(directory);
            File currentFile = new File(parentDirectory, fileName);
            FileUtils.createParentDirectories((File)currentFile);
            if (!currentFile.createNewFile()) {
                throw RuntimeDataException.create((ErrorCode)ErrorCode.COULD_NOT_CREATE_FILE, (Serializable[])new Serializable[]{currentFile.getAbsolutePath()});
            }
            this.printer.newStream((OutputStream)new BufferedOutputStream(new FileOutputStream(currentFile)));
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        return true;
    }

    public void write(IValueReference value) throws HyracksDataException {
        this.printer.print(value);
    }

    public void abort() throws HyracksDataException {
        this.printer.close();
    }

    public void close() throws HyracksDataException {
        this.printer.close();
    }
}

