/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.ParquetConverterContext;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested.AbstractComplexConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.GenericPrimitiveConverter;
import org.apache.asterix.external.parser.JSONDataParser;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleInputStream;
import org.apache.parquet.io.api.Binary;

class JsonStringConverter
extends GenericPrimitiveConverter {
    private static final byte[] EMPTY = new byte[0];
    private final JSONDataParser parser = new JSONDataParser(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE, new JsonFactory());
    private final ByteArrayAccessibleInputStream in = new ByteArrayAccessibleInputStream(EMPTY, 0, 0);

    JsonStringConverter(AbstractComplexConverter parent, String stringFieldName, int index, ParquetConverterContext context) throws IOException {
        super(ATypeTag.ANY, parent, stringFieldName, index, context);
        try {
            this.parser.setInputStream((InputStream)this.in);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public ATypeTag getTypeTag() {
        IMutableValueStorage value = this.parent.getValue();
        byte[] bytes = value.getByteArray();
        int startOffset = value.getStartOffset();
        return ATypeTag.VALUE_TYPE_MAPPING[bytes[startOffset]];
    }

    @Override
    public void addBinary(Binary value) {
        byte[] bytes = value.getBytes();
        this.in.setContent(bytes, 0, value.length());
        DataOutput out = this.parent.getDataOutput();
        try {
            if (this.parser.parseAnyValue(out)) {
                this.parent.addValue(this);
            } else {
                this.resetParser();
            }
        }
        catch (HyracksDataException e) {
            this.resetParser();
        }
    }

    private void resetParser() {
        try {
            this.parser.reset((InputStream)this.in);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

