/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs;

import java.io.IOException;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.dataflow.AbstractFeedDataFlowController;
import org.apache.asterix.external.input.record.GenericRecord;
import org.apache.asterix.external.input.record.reader.hdfs.EmptyRecordReader;
import org.apache.asterix.external.util.IFeedLogManager;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;

public abstract class AbstractHDFSRecordReader<K, V>
implements IRecordReader<V> {
    protected RecordReader<K, V> reader;
    protected V value = null;
    protected K key = null;
    protected int currentSplitIndex = 0;
    protected boolean[] read;
    protected InputFormat<?, ?> inputFormat;
    protected InputSplit[] inputSplits;
    protected String[] readSchedule;
    protected String nodeName;
    protected JobConf conf;
    protected IRawRecord<V> record;
    private boolean firstInputSplit;

    public AbstractHDFSRecordReader(boolean[] read, InputSplit[] inputSplits, String[] readSchedule, String nodeName, JobConf conf) {
        this.read = read;
        this.inputSplits = inputSplits;
        this.readSchedule = readSchedule;
        this.nodeName = nodeName;
        this.conf = conf;
        this.inputFormat = conf.getInputFormat();
        this.record = new GenericRecord<V>();
        this.reader = new EmptyRecordReader();
        this.firstInputSplit = false;
    }

    public AbstractHDFSRecordReader(boolean[] read, InputSplit[] inputSplits, String[] readSchedule, String nodeName, IRawRecord<V> record, JobConf conf) {
        this.read = read;
        this.inputSplits = inputSplits;
        this.readSchedule = readSchedule;
        this.nodeName = nodeName;
        this.conf = conf;
        this.inputFormat = conf.getInputFormat();
        this.record = record;
        this.reader = new EmptyRecordReader();
        this.firstInputSplit = false;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public boolean hasNext() throws Exception {
        if (!this.firstInputSplit) {
            this.firstInputSplit = true;
            this.nextInputSplit();
        }
        if (this.reader.next(this.key, this.value)) {
            return true;
        }
        while (this.nextInputSplit()) {
            if (!this.reader.next(this.key, this.value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IRawRecord<V> next() throws IOException {
        this.record.set(this.value);
        return this.record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean nextInputSplit() throws IOException {
        while (this.currentSplitIndex < this.inputSplits.length) {
            if (this.readSchedule[this.currentSplitIndex].equals(this.nodeName)) {
                boolean skipToNextInputsplit = false;
                boolean[] blArray = this.read;
                // MONITORENTER : this.read
                if (!this.read[this.currentSplitIndex]) {
                    this.read[this.currentSplitIndex] = true;
                } else {
                    skipToNextInputsplit = true;
                }
                // MONITOREXIT : blArray
                if (!(skipToNextInputsplit |= this.onNextInputSplit())) {
                    this.reader.close();
                    this.reader = this.getRecordReader(this.currentSplitIndex);
                    return true;
                }
            }
            ++this.currentSplitIndex;
        }
        return false;
    }

    protected abstract boolean onNextInputSplit() throws IOException;

    protected abstract RecordReader<K, V> getRecordReader(int var1) throws IOException;

    @Override
    public boolean stop() {
        return false;
    }

    public RecordReader<K, V> getReader() {
        return this.reader;
    }

    @Override
    public void setFeedLogManager(IFeedLogManager feedLogManager) {
    }

    @Override
    public void setController(AbstractFeedDataFlowController controller) {
    }

    @Override
    public boolean handleException(Throwable th) {
        return false;
    }
}

