/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.filter;

import java.util.Arrays;
import java.util.List;
import org.apache.asterix.common.external.IExternalFilterEvaluator;
import org.apache.asterix.common.external.IExternalFilterEvaluatorFactory;
import org.apache.asterix.external.input.filter.ExternalFilterEvaluator;
import org.apache.asterix.external.input.filter.FilterEvaluatorContext;
import org.apache.asterix.external.input.filter.IExternalFilterValueEvaluator;
import org.apache.asterix.external.input.filter.NoOpExternalFilterEvaluatorFactory;
import org.apache.asterix.external.input.filter.NoOpExternalFilterValueEvaluator;
import org.apache.asterix.external.input.filter.NoOpFilterValueEmbedder;
import org.apache.asterix.external.input.filter.embedder.ExternalFilterValueEmbedder;
import org.apache.asterix.external.input.filter.embedder.IExternalFilterValueEmbedder;
import org.apache.asterix.external.util.ExternalDataPrefix;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.utils.ProjectionFiltrationTypeUtil;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;

public class ExternalFilterEvaluatorFactory
implements IExternalFilterEvaluatorFactory {
    private static final long serialVersionUID = -309935877927008746L;
    private final IScalarEvaluatorFactory filterEvalFactory;
    private final ARecordType allPaths;
    private final List<ProjectionFiltrationTypeUtil.RenamedType> leafs;
    private final ExternalDataPrefix prefix;
    private final boolean embedFilterValues;

    public ExternalFilterEvaluatorFactory(IScalarEvaluatorFactory filterEvalFactory, ARecordType allPaths, List<ProjectionFiltrationTypeUtil.RenamedType> leafs, ExternalDataPrefix prefix, boolean embedFilterValues) {
        this.filterEvalFactory = filterEvalFactory;
        this.allPaths = allPaths;
        this.leafs = leafs;
        this.prefix = prefix;
        this.embedFilterValues = embedFilterValues;
    }

    public IExternalFilterEvaluator create(IServiceContext serviceContext, IWarningCollector warningCollector) throws HyracksDataException {
        if (this.filterEvalFactory == null) {
            return NoOpExternalFilterEvaluatorFactory.INSTANCE.create(serviceContext, warningCollector);
        }
        Object[] valueEvaluators = new IExternalFilterValueEvaluator[this.leafs.size()];
        Arrays.fill(valueEvaluators, NoOpExternalFilterValueEvaluator.INSTANCE);
        FilterEvaluatorContext filterContext = new FilterEvaluatorContext(serviceContext, warningCollector, (IExternalFilterValueEvaluator[])valueEvaluators);
        return new ExternalFilterEvaluator(this.filterEvalFactory.createScalarEvaluator((IEvaluatorContext)filterContext), (IExternalFilterValueEvaluator[])valueEvaluators);
    }

    public IExternalFilterValueEmbedder createValueEmbedder(IWarningCollector warningCollector) {
        if (this.embedFilterValues) {
            return new ExternalFilterValueEmbedder(this.allPaths, this.leafs, this.prefix);
        }
        return NoOpFilterValueEmbedder.INSTANCE;
    }
}

