/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.indexing;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.metadata.DataverseName;

public class ExternalFile
implements Serializable,
Comparable<ExternalFile> {
    private static final long serialVersionUID = 2L;
    private final String databaseName;
    private DataverseName dataverseName;
    private String datasetName;
    private Date lastModefiedTime;
    private long size;
    private String fileName;
    private int fileNumber;
    private DatasetConfig.ExternalFilePendingOp pendingOp;

    public ExternalFile(String databaseName, DataverseName dataverseName, String datasetName, int fileNumber, String fileName, Date lastModefiedTime, long size, DatasetConfig.ExternalFilePendingOp pendingOp) {
        this.databaseName = Objects.requireNonNull(databaseName);
        this.dataverseName = dataverseName;
        this.datasetName = datasetName;
        this.fileNumber = fileNumber;
        this.fileName = fileName;
        this.lastModefiedTime = lastModefiedTime;
        this.size = size;
        this.setPendingOp(pendingOp);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DataverseName getDataverseName() {
        return this.dataverseName;
    }

    public void setDataverseName(DataverseName dataverseName) {
        this.dataverseName = dataverseName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public Date getLastModefiedTime() {
        return this.lastModefiedTime;
    }

    public void setLastModefiedTime(Date lastModefiedTime) {
        this.lastModefiedTime = lastModefiedTime;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getFileNumber() {
        return this.fileNumber;
    }

    public void setFileNumber(int fileNumber) {
        this.fileNumber = fileNumber;
    }

    public DatasetConfig.ExternalFilePendingOp getPendingOp() {
        return this.pendingOp;
    }

    public void setPendingOp(DatasetConfig.ExternalFilePendingOp pendingOp) {
        this.pendingOp = pendingOp;
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.dataverseName, this.datasetName, this.fileName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExternalFile)) {
            return false;
        }
        ExternalFile anotherFile = (ExternalFile)obj;
        return this.fileNumber == anotherFile.fileNumber && Objects.equals(this.databaseName, anotherFile.databaseName) && Objects.equals(this.dataverseName, anotherFile.getDataverseName()) && Objects.equals(this.datasetName, anotherFile.getDatasetName());
    }

    @Override
    public int compareTo(ExternalFile o) {
        return this.fileNumber - o.getFileNumber();
    }
}

