/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.resource.util;

import com.google.common.base.Preconditions;
import io.opencensus.contrib.resource.util.AwsIdentityDocUtils;
import io.opencensus.contrib.resource.util.GcpMetadataConfig;
import io.opencensus.contrib.resource.util.ResourceUtils;
import io.opencensus.resource.Resource;
import java.util.LinkedHashMap;

public final class CloudResource {
    public static final String TYPE = "cloud";
    public static final String PROVIDER_KEY = "cloud.provider";
    public static final String PROVIDER_AWS = "aws";
    public static final String PROVIDER_AZURE = "azure";
    public static final String PROVIDER_GCP = "gcp";
    public static final String ACCOUNT_ID_KEY = "cloud.account.id";
    public static final String REGION_KEY = "cloud.region";
    public static final String ZONE_KEY = "cloud.zone";

    public static Resource create(String provider, String accountId, String region, String zone) {
        LinkedHashMap<String, Object> labels = new LinkedHashMap<String, Object>();
        labels.put(PROVIDER_KEY, Preconditions.checkNotNull((Object)provider, (Object)"provider"));
        labels.put(ACCOUNT_ID_KEY, Preconditions.checkNotNull((Object)accountId, (Object)"accountId"));
        labels.put(REGION_KEY, Preconditions.checkNotNull((Object)region, (Object)"availabilityZone"));
        labels.put(ZONE_KEY, Preconditions.checkNotNull((Object)zone, (Object)"zone"));
        return Resource.create((String)TYPE, labels);
    }

    static Resource detect() {
        if (AwsIdentityDocUtils.isRunningOnAws()) {
            return CloudResource.create(PROVIDER_AWS, AwsIdentityDocUtils.getAccountId(), AwsIdentityDocUtils.getRegion(), AwsIdentityDocUtils.getAvailabilityZone());
        }
        if (GcpMetadataConfig.isRunningOnGcp()) {
            return CloudResource.create(PROVIDER_GCP, GcpMetadataConfig.getProjectId(), "", GcpMetadataConfig.getZone());
        }
        return ResourceUtils.EMPTY_RESOURCE;
    }

    private CloudResource() {
    }
}

