/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.storage.common.IResource;

public class LocalResource
implements Serializable,
IJsonSerializable {
    private static final long serialVersionUID = 2L;
    private final long id;
    private final int version;
    private final boolean durable;
    private final IResource resource;

    public LocalResource(long id, int version, boolean durable, IResource resource) {
        this.id = id;
        this.version = version;
        this.durable = durable;
        this.resource = resource;
    }

    public long getId() {
        return this.id;
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public IResource getResource() {
        return this.resource;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public String toString() {
        return "{\"" + LocalResource.class.getSimpleName() + "\" : " + "{\"id\" = " + this.id + ", \"resource\" : " + this.getPath() + ", \"version\" : " + this.version + " } ";
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode json = registry.getClassIdentifier(this.getClass(), 2L);
        json.put("id", this.id);
        json.put("version", this.version);
        json.put("durable", this.durable);
        json.set("resource", this.resource.toJson(registry));
        return json;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        long id = json.get("id").asLong();
        int version = json.get("version").asInt();
        boolean durable = json.get("durable").asBoolean();
        IResource resource = (IResource)registry.deserialize(json.get("resource"));
        return new LocalResource(id, version, durable, resource);
    }
}

