/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.exceptions;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.asterix.common.exceptions.WarningUtil;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.Warning;

public final class WarningCollector
implements IWarningCollector {
    private final Set<Warning> warnings = new LinkedHashSet<Warning>();
    private long maxWarnings = Long.MAX_VALUE;
    private long totalWarningsCount;

    public void clear() {
        this.warnings.clear();
        this.totalWarningsCount = 0L;
    }

    public void warn(Warning warning) {
        this.warnings.add(warning);
    }

    public boolean shouldWarn() {
        return this.totalWarningsCount < Long.MAX_VALUE && this.totalWarningsCount++ < this.maxWarnings;
    }

    public long getTotalWarningsCount() {
        return this.totalWarningsCount;
    }

    public void getWarnings(Collection<? super Warning> outWarnings, long maxWarnings) {
        long i = 0L;
        for (Warning warning : this.warnings) {
            if (i >= maxWarnings) break;
            outWarnings.add((Warning)warning);
            ++i;
        }
    }

    public void getWarnings(IWarningCollector outWarningCollector) {
        WarningUtil.mergeWarnings(this.warnings, outWarningCollector);
    }

    public void setMaxWarnings(long maxWarnings) {
        this.maxWarnings = maxWarnings;
    }
}

