/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.comm;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class FixedSizeFrame
implements IFrame {
    private ByteBuffer buffer;

    public FixedSizeFrame() {
    }

    public FixedSizeFrame(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public void reset(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void ensureFrameSize(int frameSize) throws HyracksDataException {
        throw new HyracksDataException("FixedSizeFrame doesn't support capacity changes");
    }

    @Override
    public void resize(int frameSize) throws HyracksDataException {
        throw new HyracksDataException("FixedSizeFrame doesn't support capacity changes");
    }

    @Override
    public int getFrameSize() {
        return this.buffer.capacity();
    }

    @Override
    public int getMinSize() {
        return this.buffer.capacity() / FrameHelper.deserializeNumOfMinFrame(this.buffer, 0);
    }

    @Override
    public void reset() throws HyracksDataException {
        this.buffer.clear();
    }
}

