/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.temporal;

import java.io.DataOutput;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.zone.ZoneRules;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateTimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ATimeSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.functions.AbstractScalarEval;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.functions.temporal.TimezoneHelper;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

abstract class AbstractUnixTimeEval
extends AbstractScalarEval {
    private final IScalarEvaluator arg0;
    private final IScalarEvaluator arg1;
    private final IPointable argPtr0;
    private final IPointable argPtr1;
    private final UTF8StringPointable utf8Ptr;
    protected final GregorianCalendarSystem cal = GregorianCalendarSystem.getInstance();
    protected final TimezoneHelper tzHelper;
    private final ISerializerDeserializer<AInt64> int64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    private final AMutableInt64 aInt64 = new AMutableInt64(0L);
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput out = this.resultStorage.getDataOutput();
    protected ATypeTag tag = ATypeTag.NULL;
    protected Predicate<Byte> incorrectTag = i -> i.byteValue() != this.tag.serialize();

    AbstractUnixTimeEval(IScalarEvaluator arg0, SourceLocation sourceLoc, FunctionIdentifier functionIdentifier) {
        this(arg0, null, sourceLoc, functionIdentifier);
    }

    AbstractUnixTimeEval(IScalarEvaluator arg0, IScalarEvaluator arg1, SourceLocation sourceLoc, FunctionIdentifier fid) {
        super(sourceLoc, fid);
        this.arg0 = arg0;
        this.arg1 = arg1;
        this.argPtr0 = new VoidPointable();
        this.argPtr1 = arg1 != null ? new VoidPointable() : null;
        this.utf8Ptr = arg1 != null ? new UTF8StringPointable() : null;
        this.tzHelper = new TimezoneHelper(sourceLoc, fid);
    }

    private long getChronon(byte[] bytes, int offset, ATypeTag tag) {
        switch (tag) {
            case TIME: {
                return ATimeSerializerDeserializer.getChronon((byte[])bytes, (int)offset);
            }
            case DATE: {
                return ADateSerializerDeserializer.getChronon((byte[])bytes, (int)offset);
            }
            case DATETIME: {
                return ADateTimeSerializerDeserializer.getChronon((byte[])bytes, (int)offset);
            }
        }
        return -1L;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        long chrononUTC;
        int offset0;
        this.arg0.evaluate(tuple, this.argPtr0);
        if (this.arg1 != null) {
            this.arg1.evaluate(tuple, this.argPtr1);
        }
        if (PointableHelper.checkAndSetMissingOrNull(result, this.argPtr0, this.argPtr1)) {
            return;
        }
        byte[] bytes0 = this.argPtr0.getByteArray();
        if (this.incorrectTag.test(bytes0[offset0 = this.argPtr0.getStartOffset()])) {
            throw new TypeMismatchException(this.srcLoc, this.funID, 0, bytes0[offset0], this.tag.serialize());
        }
        long chrononLocal = this.getChronon(bytes0, offset0 + 1, this.tag);
        if (this.arg1 != null) {
            byte[] bytes1 = this.argPtr1.getByteArray();
            int offset1 = this.argPtr1.getStartOffset();
            int len1 = this.argPtr1.getLength();
            if (bytes1[offset1] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                throw new TypeMismatchException(this.srcLoc, this.funID, 1, bytes1[offset1], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
            }
            this.utf8Ptr.set(bytes1, offset1 + 1, len1 - 1);
            ZoneRules tzRules = this.tzHelper.parseTimeZone(this.utf8Ptr);
            LocalDateTime dt = AbstractUnixTimeEval.toLocalDateTime(chrononLocal, this.cal);
            ZoneOffset tzOffset = tzRules.getOffset(dt);
            int tzOffsetMillis = (int)TimeUnit.SECONDS.toMillis(tzOffset.getTotalSeconds());
            chrononUTC = this.cal.adjustChrononByTimezone(chrononLocal, tzOffsetMillis);
        } else {
            chrononUTC = chrononLocal;
        }
        long unixTime = this.chrononToUnixTime(chrononUTC);
        this.resultStorage.reset();
        this.aInt64.setValue(unixTime);
        this.int64Serde.serialize((Object)this.aInt64, this.out);
        result.set((IValueReference)this.resultStorage);
    }

    private static LocalDateTime toLocalDateTime(long chronon, GregorianCalendarSystem cal) {
        int year = cal.getYear(chronon);
        int month = cal.getMonthOfYear(chronon, year);
        int day = cal.getDayOfMonthYear(chronon, year, month);
        int hour = cal.getHourOfDay(chronon);
        int minute = cal.getMinOfHour(chronon);
        int second = cal.getSecOfMin(chronon);
        int milli = cal.getMillisOfSec(chronon);
        int nano = (int)TimeUnit.MILLISECONDS.toNanos(milli);
        return LocalDateTime.of(year, month, day, hour, minute, second, nano);
    }

    abstract long chrononToUnixTime(long var1);
}

