/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils.filter;

import java.util.List;
import java.util.Map;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.config.CompilerProperties;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionManager;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.types.ARecordType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.SourceLocation;

abstract class AbstractFilterBuilder {
    protected final Map<ILogicalExpression, ARecordType> filterPaths;
    protected final ILogicalExpression filterExpression;
    protected final JobGenContext context;
    protected final IVariableTypeEnvironment typeEnv;

    AbstractFilterBuilder(Map<ILogicalExpression, ARecordType> filterPaths, ILogicalExpression filterExpression, JobGenContext context, IVariableTypeEnvironment typeEnv) {
        this.filterPaths = filterPaths;
        this.filterExpression = filterExpression;
        this.context = context;
        this.typeEnv = typeEnv;
    }

    protected IScalarEvaluatorFactory createEvaluator(ILogicalExpression expression) throws AlgebricksException {
        if (this.filterPaths.containsKey(expression)) {
            return this.createValueAccessor(expression);
        }
        if (expression.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
            return this.createConstantAccessor(expression);
        }
        if (expression.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            return this.handleFunction(expression);
        }
        throw new IllegalStateException("Unsupported expression " + expression + ". the provided paths are: " + this.filterPaths);
    }

    protected abstract IScalarEvaluatorFactory createValueAccessor(ILogicalExpression var1);

    private IScalarEvaluatorFactory createConstantAccessor(ILogicalExpression expression) throws AlgebricksException {
        MetadataProvider metadataProvider = (MetadataProvider)this.context.getMetadataProvider();
        ConstantExpression constExpr = (ConstantExpression)expression;
        return metadataProvider.getDataFormat().getConstantEvalFactory(constExpr.getValue());
    }

    private IScalarEvaluatorFactory handleFunction(ILogicalExpression expr) throws AlgebricksException {
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        IScalarEvaluatorFactory[] args = this.handleArgs(funcExpr);
        IFunctionDescriptor fd = this.resolveFunction(funcExpr);
        return fd.createEvaluatorFactory(args);
    }

    private IScalarEvaluatorFactory[] handleArgs(AbstractFunctionCallExpression funcExpr) throws AlgebricksException {
        List args = funcExpr.getArguments();
        IScalarEvaluatorFactory[] argsEvalFactories = new IScalarEvaluatorFactory[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            IScalarEvaluatorFactory evalFactory;
            ILogicalExpression expr = (ILogicalExpression)((Mutable)args.get(i)).getValue();
            argsEvalFactories[i] = evalFactory = this.createEvaluator(expr);
        }
        return argsEvalFactories;
    }

    private IFunctionDescriptor resolveFunction(AbstractFunctionCallExpression funcExpr) throws AlgebricksException {
        MetadataProvider metadataProvider = (MetadataProvider)this.context.getMetadataProvider();
        IFunctionManager functionManager = metadataProvider.getFunctionManager();
        FunctionIdentifier fnId = funcExpr.getFunctionIdentifier();
        SourceLocation sourceLocation = funcExpr.getSourceLocation();
        IFunctionDescriptor fd = functionManager.lookupFunction(fnId, sourceLocation);
        fd.setSourceLocation(sourceLocation);
        IFunctionTypeInferer fnTypeInfer = functionManager.lookupFunctionTypeInferer(fnId);
        if (fnTypeInfer != null) {
            CompilerProperties compilerProps = ((IApplicationContext)this.context.getAppContext()).getCompilerProperties();
            fnTypeInfer.infer((ILogicalExpression)funcExpr, fd, this.typeEnv, compilerProps);
        }
        return fd;
    }
}

