/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.util.Calendar;
import org.apache.asterix.common.external.IDataSourceAdapter;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.external.dataset.adapter.AdapterIdentifier;
import org.apache.asterix.metadata.bootstrap.DatasourceAdapterEntity;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class DatasourceAdapterTupleTranslator
extends AbstractTupleTranslator<DatasourceAdapter> {
    private final DatasourceAdapterEntity datasourceAdapterEntity;

    protected DatasourceAdapterTupleTranslator(boolean getTuple, DatasourceAdapterEntity datasourceAdapterEntity) {
        super(getTuple, datasourceAdapterEntity.getIndex(), datasourceAdapterEntity.payloadPosition());
        this.datasourceAdapterEntity = datasourceAdapterEntity;
    }

    @Override
    protected DatasourceAdapter createMetadataEntityFromARecord(ARecord adapterRecord) throws AlgebricksException {
        String dataverseCanonicalName = ((AString)adapterRecord.getValueByPos(this.datasourceAdapterEntity.dataverseNameIndex())).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        int databaseNameIndex = this.datasourceAdapterEntity.databaseNameIndex();
        String databaseName = databaseNameIndex >= 0 ? ((AString)adapterRecord.getValueByPos(databaseNameIndex)).getStringValue() : MetadataUtil.databaseFor((DataverseName)dataverseName);
        String adapterName = ((AString)adapterRecord.getValueByPos(this.datasourceAdapterEntity.adapterNameIndex())).getStringValue();
        String classname = ((AString)adapterRecord.getValueByPos(this.datasourceAdapterEntity.classNameIndex())).getStringValue();
        IDataSourceAdapter.AdapterType adapterType = IDataSourceAdapter.AdapterType.valueOf((String)((AString)adapterRecord.getValueByPos(this.datasourceAdapterEntity.typeIndex())).getStringValue());
        String libraryDatabase = null;
        DataverseName libraryDataverseName = null;
        String libraryName = null;
        int libraryNameIdx = adapterRecord.getType().getFieldIndex("LibraryName");
        if (libraryNameIdx >= 0) {
            libraryName = ((AString)adapterRecord.getValueByPos(libraryNameIdx)).getStringValue();
            int libraryDataverseNameIdx = adapterRecord.getType().getFieldIndex("LibraryDataverseName");
            libraryDataverseName = libraryDataverseNameIdx >= 0 ? DataverseName.createFromCanonicalForm((String)((AString)adapterRecord.getValueByPos(libraryDataverseNameIdx)).getStringValue()) : dataverseName;
            int libraryDatabaseNameIdx = adapterRecord.getType().getFieldIndex("LibraryDatabaseName");
            libraryDatabase = libraryDatabaseNameIdx >= 0 ? ((AString)adapterRecord.getValueByPos(libraryDatabaseNameIdx)).getStringValue() : MetadataUtil.databaseFor((DataverseName)libraryDataverseName);
        }
        return new DatasourceAdapter(new AdapterIdentifier(databaseName, dataverseName, adapterName), adapterType, classname, libraryDatabase, libraryDataverseName, libraryName);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(DatasourceAdapter adapter) throws HyracksDataException {
        AdapterIdentifier adapterIdentifier = adapter.getAdapterIdentifier();
        String dataverseCanonicalName = adapterIdentifier.getDataverseName().getCanonicalForm();
        this.tupleBuilder.reset();
        if (this.datasourceAdapterEntity.databaseNameIndex() >= 0) {
            this.aString.setValue(adapterIdentifier.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
            this.tupleBuilder.addFieldEndOffset();
        }
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(adapterIdentifier.getName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(this.datasourceAdapterEntity.getRecordType());
        if (this.datasourceAdapterEntity.databaseNameIndex() >= 0) {
            this.fieldValue.reset();
            this.aString.setValue(adapterIdentifier.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField(this.datasourceAdapterEntity.databaseNameIndex(), (IValueReference)this.fieldValue);
        }
        this.fieldValue.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.datasourceAdapterEntity.dataverseNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(adapterIdentifier.getName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.datasourceAdapterEntity.adapterNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(adapter.getClassname());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.datasourceAdapterEntity.classNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(adapter.getType().name());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.datasourceAdapterEntity.typeIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(Calendar.getInstance().getTime().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.datasourceAdapterEntity.timestampIndex(), (IValueReference)this.fieldValue);
        this.writeOpenFields(adapter);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }

    void writeOpenFields(DatasourceAdapter adapter) throws HyracksDataException {
        this.writeLibrary(adapter);
    }

    protected void writeLibrary(DatasourceAdapter adapter) throws HyracksDataException {
        if (adapter.getLibraryName() == null) {
            return;
        }
        if (this.datasourceAdapterEntity.databaseNameIndex() >= 0) {
            this.fieldName.reset();
            this.aString.setValue("LibraryDatabaseName");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aString.setValue(adapter.getLibraryDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        }
        this.fieldName.reset();
        this.aString.setValue("LibraryDataverseName");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.aString.setValue(adapter.getLibraryDataverseName().getCanonicalForm());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        this.fieldName.reset();
        this.aString.setValue("LibraryName");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.aString.setValue(adapter.getLibraryName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
    }
}

