/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.asterix.common.api.IIdentifierMapper;
import org.apache.asterix.common.api.INamespaceResolver;
import org.apache.asterix.common.cluster.PartitioningProperties;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.config.StorageProperties;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.dataflow.LSMTreeInsertDeleteOperatorDescriptor;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.external.IDataSourceAdapter;
import org.apache.asterix.common.external.IExternalFilterEvaluatorFactory;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.LockList;
import org.apache.asterix.common.metadata.MetadataConstants;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.common.storage.ICompressionManager;
import org.apache.asterix.common.transactions.ITxnIdFactory;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.common.utils.IdentifierUtil;
import org.apache.asterix.dataflow.data.nontagged.MissingWriterFactory;
import org.apache.asterix.dataflow.data.nontagged.serde.SerializerDeserializerUtil;
import org.apache.asterix.external.adapter.factory.ExternalAdapterFactory;
import org.apache.asterix.external.api.ITypedAdapterFactory;
import org.apache.asterix.external.feed.api.IFeed;
import org.apache.asterix.external.feed.policy.FeedPolicyAccessor;
import org.apache.asterix.external.operators.ExternalScanOperatorDescriptor;
import org.apache.asterix.external.operators.FeedIntakeOperatorDescriptor;
import org.apache.asterix.external.provider.AdapterFactoryProvider;
import org.apache.asterix.formats.base.IDataFormat;
import org.apache.asterix.formats.nontagged.BinaryIntegerInspector;
import org.apache.asterix.formats.nontagged.LinearizeComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.TypeTraitProvider;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.api.ICCExtensionManager;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.DataSourceIndex;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.declared.MetadataManagerUtil;
import org.apache.asterix.metadata.declared.ResultSetDataSink;
import org.apache.asterix.metadata.declared.ResultSetSinkId;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.FullTextConfigMetadataEntity;
import org.apache.asterix.metadata.entities.FullTextFilterMetadataEntity;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.Synonym;
import org.apache.asterix.metadata.feeds.FeedMetadataUtil;
import org.apache.asterix.metadata.provider.ExternalWriterProvider;
import org.apache.asterix.metadata.utils.DataPartitioningProvider;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.FullTextUtil;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionExtensionManager;
import org.apache.asterix.om.functions.IFunctionManager;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.runtime.base.AsterixTupleFilterFactory;
import org.apache.asterix.runtime.formats.FormatUtils;
import org.apache.asterix.runtime.operators.LSMIndexBulkLoadOperatorDescriptor;
import org.apache.asterix.runtime.operators.LSMPrimaryInsertOperatorDescriptor;
import org.apache.asterix.runtime.operators.LSMSecondaryInsertDeleteWithNestedPlanOperatorDescriptor;
import org.apache.asterix.runtime.operators.LSMSecondaryUpsertOperatorDescriptor;
import org.apache.asterix.runtime.operators.LSMSecondaryUpsertWithNestedPlanOperatorDescriptor;
import org.apache.asterix.runtime.writer.ExternalWriterFactory;
import org.apache.asterix.runtime.writer.IExternalFilePrinterFactory;
import org.apache.asterix.runtime.writer.IExternalFileWriterFactory;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Quadruple;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.Counter;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSink;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourceIndex;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.metadata.IProjectionFiltrationInfo;
import org.apache.hyracks.algebricks.core.algebra.metadata.IWriteDataSink;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.algebricks.data.IAWriterFactory;
import org.apache.hyracks.algebricks.data.IPrinterFactory;
import org.apache.hyracks.algebricks.data.IResultSerializerFactoryProvider;
import org.apache.hyracks.algebricks.data.ISerializerDeserializerProvider;
import org.apache.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.writer.SinkExternalWriterRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.writers.IExternalWriterFactory;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.IResultSerializerFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionerFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.result.IResultMetadata;
import org.apache.hyracks.api.result.ResultSetId;
import org.apache.hyracks.data.std.primitive.ShortPointable;
import org.apache.hyracks.dataflow.common.data.marshalling.ShortSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.partition.FieldHashPartitionerFactory;
import org.apache.hyracks.dataflow.std.result.ResultWriterOperatorDescriptor;
import org.apache.hyracks.storage.am.btree.dataflow.BTreeSearchOperatorDescriptor;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.btree.dataflow.LSMBTreeBatchPointSearchOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.BinaryTokenizerOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.IFullTextConfigEvaluatorFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.am.rtree.dataflow.RTreeSearchOperatorDescriptor;
import org.apache.hyracks.storage.common.IStorageManager;
import org.apache.hyracks.storage.common.projection.ITupleProjectorFactory;

public class MetadataProvider
implements IMetadataProvider<DataSourceId, String> {
    private final ICcApplicationContext appCtx;
    private final IStorageComponentProvider storageComponentProvider;
    private final StorageProperties storageProperties;
    private final IFunctionManager functionManager;
    private final LockList locks;
    private final Map<String, Object> config;
    private Namespace defaultNamespace;
    private MetadataTransactionContext mdTxnCtx;
    private boolean isWriteTransaction;
    private FileSplit outputFile;
    private boolean asyncResults;
    private long maxResultReads;
    private ResultSetId resultSetId;
    private Counter resultSetIdCounter;
    private TxnId txnId;
    private boolean blockingOperatorDisabled = false;
    private final DataPartitioningProvider dataPartitioningProvider;
    private final INamespaceResolver namespaceResolver;
    private IDataFormat dataFormat = FormatUtils.getDefaultFormat();

    public static MetadataProvider createWithDefaultNamespace(ICcApplicationContext appCtx) {
        java.util.function.Function<ICcApplicationContext, IMetadataProvider<?, ?>> factory = ((ICCExtensionManager)appCtx.getExtensionManager()).getMetadataProviderFactory();
        MetadataProvider mp = factory != null ? (MetadataProvider)factory.apply(appCtx) : new MetadataProvider(appCtx);
        mp.setDefaultNamespace(MetadataConstants.DEFAULT_NAMESPACE);
        return mp;
    }

    public static MetadataProvider create(ICcApplicationContext appCtx, Namespace defaultNamespace) {
        java.util.function.Function<ICcApplicationContext, IMetadataProvider<?, ?>> factory = ((ICCExtensionManager)appCtx.getExtensionManager()).getMetadataProviderFactory();
        MetadataProvider mp = factory != null ? (MetadataProvider)factory.apply(appCtx) : new MetadataProvider(appCtx);
        mp.setDefaultNamespace(defaultNamespace);
        return mp;
    }

    protected MetadataProvider(ICcApplicationContext appCtx) {
        this.appCtx = appCtx;
        this.storageComponentProvider = appCtx.getStorageComponentProvider();
        this.namespaceResolver = appCtx.getNamespaceResolver();
        this.storageProperties = appCtx.getStorageProperties();
        this.functionManager = ((IFunctionExtensionManager)appCtx.getExtensionManager()).getFunctionManager();
        this.dataPartitioningProvider = (DataPartitioningProvider)appCtx.getDataPartitioningProvider();
        this.locks = new LockList();
        this.config = new HashMap<String, Object>();
        this.setDefaultNamespace(MetadataConstants.DEFAULT_NAMESPACE);
    }

    public <T> T getProperty(String name) {
        return (T)this.config.get(name);
    }

    public void setProperty(String name, Object value) {
        this.config.put(name, value);
    }

    public <T> T removeProperty(String name) {
        return (T)this.config.remove(name);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        Object v = this.config.get(name);
        return v != null ? Boolean.parseBoolean(String.valueOf(v)) : defaultValue;
    }

    public void disableBlockingOperator() {
        this.blockingOperatorDisabled = true;
    }

    public boolean isBlockingOperatorDisabled() {
        return this.blockingOperatorDisabled;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setTxnId(TxnId txnId) {
        this.txnId = txnId;
    }

    public void setDefaultNamespace(Namespace namespace) {
        this.defaultNamespace = namespace == null ? MetadataConstants.DEFAULT_NAMESPACE : namespace;
    }

    public Namespace getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setWriteTransaction(boolean writeTransaction) {
        this.isWriteTransaction = writeTransaction;
    }

    public void setMetadataTxnContext(MetadataTransactionContext mdTxnCtx) {
        this.mdTxnCtx = mdTxnCtx;
    }

    public MetadataTransactionContext getMetadataTxnContext() {
        return this.mdTxnCtx;
    }

    public FileSplit getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(FileSplit outputFile) {
        this.outputFile = outputFile;
    }

    public boolean getResultAsyncMode() {
        return this.asyncResults;
    }

    public void setResultAsyncMode(boolean asyncResults) {
        this.asyncResults = asyncResults;
    }

    public void setMaxResultReads(long maxResultReads) {
        this.maxResultReads = maxResultReads;
    }

    public long getMaxResultReads() {
        return this.maxResultReads;
    }

    public ResultSetId getResultSetId() {
        return this.resultSetId;
    }

    public void setResultSetId(ResultSetId resultSetId) {
        this.resultSetId = resultSetId;
    }

    public Counter getResultSetIdCounter() {
        return this.resultSetIdCounter;
    }

    public void setResultSetIdCounter(Counter resultSetIdCounter) {
        this.resultSetIdCounter = resultSetIdCounter;
    }

    public boolean isWriteTransaction() {
        return this.isWriteTransaction;
    }

    public IFunctionManager getFunctionManager() {
        return this.functionManager;
    }

    public IDataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(IDataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public INamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public boolean isUsingDatabase() {
        return this.namespaceResolver.isUsingDatabase();
    }

    public StorageProperties getStorageProperties() {
        return this.storageProperties;
    }

    public ARecordType findOutputRecordType() throws AlgebricksException {
        String database = null;
        DataverseName dataverseName = null;
        if (this.defaultNamespace != null) {
            database = this.defaultNamespace.getDatabaseName();
            dataverseName = this.defaultNamespace.getDataverseName();
        }
        return MetadataManagerUtil.findOutputRecordType(this.mdTxnCtx, database, dataverseName, (String)this.getProperty("output-record-type"));
    }

    public Dataset findDataset(String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        return this.findDataset(database, dataverseName, datasetName, false);
    }

    public Dataset findDataset(String database, DataverseName dataverseName, String datasetName, boolean includingViews) throws AlgebricksException {
        String dbName = database;
        DataverseName dvName = dataverseName;
        if (dbName == null && dvName == null) {
            if (this.defaultNamespace == null) {
                return null;
            }
            dbName = this.defaultNamespace.getDatabaseName();
            dvName = this.defaultNamespace.getDataverseName();
        } else if (dbName == null || dvName == null) {
            return null;
        }
        this.appCtx.getMetadataLockManager().acquireDataverseReadLock(this.locks, dbName, dvName);
        this.appCtx.getMetadataLockManager().acquireDatasetReadLock(this.locks, dbName, dvName, datasetName);
        return MetadataManagerUtil.findDataset(this.mdTxnCtx, dbName, dvName, datasetName, includingViews);
    }

    public INodeDomain findNodeDomain(String nodeGroupName) throws AlgebricksException {
        return MetadataManagerUtil.findNodeDomain(this.appCtx.getClusterStateManager(), this.mdTxnCtx, nodeGroupName);
    }

    public List<String> findNodes(String nodeGroupName) throws AlgebricksException {
        return MetadataManagerUtil.findNodes(this.mdTxnCtx, nodeGroupName);
    }

    public Datatype findTypeEntity(String database, DataverseName dataverseName, String typeName) throws AlgebricksException {
        return MetadataManagerUtil.findTypeEntity(this.mdTxnCtx, database, dataverseName, typeName);
    }

    public IAType findTypeForDatasetWithoutType(IAType recordType, IAType metaRecordType, Dataset dataset) throws AlgebricksException {
        return MetadataManagerUtil.findTypeForDatasetWithoutType(recordType, metaRecordType, dataset);
    }

    public IAType findType(String database, DataverseName dataverseName, String typeName) throws AlgebricksException {
        return MetadataManagerUtil.findType(this.mdTxnCtx, database, dataverseName, typeName);
    }

    public IAType findType(Dataset dataset) throws AlgebricksException {
        return this.findType(dataset.getItemTypeDatabaseName(), dataset.getItemTypeDataverseName(), dataset.getItemTypeName());
    }

    public IAType findMetaType(Dataset dataset) throws AlgebricksException {
        return this.findType(dataset.getMetaItemTypeDatabaseName(), dataset.getMetaItemTypeDataverseName(), dataset.getMetaItemTypeName());
    }

    public Feed findFeed(String database, DataverseName dataverseName, String feedName) throws AlgebricksException {
        return MetadataManagerUtil.findFeed(this.mdTxnCtx, database, dataverseName, feedName);
    }

    public FeedConnection findFeedConnection(String database, DataverseName dataverseName, String feedName, String datasetName) throws AlgebricksException {
        return MetadataManagerUtil.findFeedConnection(this.mdTxnCtx, database, dataverseName, feedName, datasetName);
    }

    public FeedPolicyEntity findFeedPolicy(String database, DataverseName dataverseName, String policyName) throws AlgebricksException {
        return MetadataManagerUtil.findFeedPolicy(this.mdTxnCtx, database, dataverseName, policyName);
    }

    public DataSource findDataSource(DataSourceId id) throws AlgebricksException {
        return MetadataManagerUtil.findDataSource(this.appCtx.getClusterStateManager(), this.mdTxnCtx, id);
    }

    public DataSource lookupSourceInMetadata(DataSourceId aqlId) throws AlgebricksException {
        return MetadataManagerUtil.lookupSourceInMetadata(this.appCtx.getClusterStateManager(), this.mdTxnCtx, aqlId);
    }

    public IDataSourceIndex<String, DataSourceId> findDataSourceIndex(String indexId, DataSourceId dataSourceId) throws AlgebricksException {
        String datasetName;
        DataSource source = this.findDataSource(dataSourceId);
        Dataset dataset = ((DatasetDataSource)source).getDataset();
        DataverseName dataverseName = dataset.getDataverseName();
        String database = dataset.getDatabaseName();
        Index index = this.getIndex(database, dataverseName, datasetName = dataset.getDatasetName(), indexId);
        return index != null ? new DataSourceIndex(index, database, dataverseName, datasetName, this) : null;
    }

    public Index getIndex(String database, DataverseName dataverseName, String datasetName, String indexName) throws AlgebricksException {
        return MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, database, dataverseName, datasetName, indexName);
    }

    public List<Index> getDatasetIndexes(String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        return MetadataManagerUtil.getDatasetIndexes(this.mdTxnCtx, database, dataverseName, datasetName);
    }

    public Index findSampleIndex(String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        Pair<String, String> sampleIndexNames = IndexUtil.getSampleIndexNames(datasetName);
        Index sampleIndex = this.getIndex(database, dataverseName, datasetName, (String)sampleIndexNames.first);
        if (sampleIndex != null && sampleIndex.getPendingOp() == 0) {
            return sampleIndex;
        }
        sampleIndex = this.getIndex(database, dataverseName, datasetName, (String)sampleIndexNames.second);
        return sampleIndex != null && sampleIndex.getPendingOp() == 0 ? sampleIndex : null;
    }

    public Quadruple<DataverseName, String, Boolean, String> resolveDatasetNameUsingSynonyms(String databaseName, DataverseName dataverseName, String datasetName, boolean includingViews) throws AlgebricksException {
        String dbName = databaseName;
        DataverseName dvName = dataverseName;
        if (dbName == null && dvName == null) {
            if (this.defaultNamespace == null) {
                return null;
            }
            dbName = this.defaultNamespace.getDatabaseName();
            dvName = this.defaultNamespace.getDataverseName();
        } else if (dbName == null || dvName == null) {
            return null;
        }
        Synonym synonym = null;
        while (MetadataManagerUtil.findDataset(this.mdTxnCtx, dbName, dvName, datasetName, includingViews) == null) {
            synonym = this.findSynonym(dbName, dvName, datasetName);
            if (synonym == null) {
                return null;
            }
            dbName = synonym.getObjectDatabaseName();
            dvName = synonym.getObjectDataverseName();
            datasetName = synonym.getObjectName();
        }
        return new Quadruple((Object)dvName, (Object)datasetName, (Object)(synonym != null ? 1 : 0), (Object)dbName);
    }

    public Synonym findSynonym(String database, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        return MetadataManagerUtil.findSynonym(this.mdTxnCtx, database, dataverseName, synonymName);
    }

    public FullTextConfigMetadataEntity findFullTextConfig(String database, DataverseName dataverseName, String ftConfigName) throws AlgebricksException {
        return MetadataManagerUtil.findFullTextConfigDescriptor(this.mdTxnCtx, database, dataverseName, ftConfigName);
    }

    public FullTextFilterMetadataEntity findFullTextFilter(String database, DataverseName dataverseName, String ftFilterName) throws AlgebricksException {
        return MetadataManagerUtil.findFullTextFilterDescriptor(this.mdTxnCtx, database, dataverseName, ftFilterName);
    }

    public IFunctionInfo lookupFunction(FunctionIdentifier fid) {
        return BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)fid);
    }

    public Function lookupUserDefinedFunction(FunctionSignature signature) throws AlgebricksException {
        if (signature.getDataverseName() == null) {
            return null;
        }
        return MetadataManager.INSTANCE.getFunction(this.mdTxnCtx, signature);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getScannerRuntime(IDataSource<DataSourceId> dataSource, List<LogicalVariable> scanVariables, List<LogicalVariable> projectVariables, boolean projectPushed, List<LogicalVariable> minFilterVars, List<LogicalVariable> maxFilterVars, ITupleFilterFactory tupleFilterFactory, long outputLimit, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, JobSpecification jobSpec, Object implConfig, IProjectionFiltrationInfo projectionFiltrationInfo) throws AlgebricksException {
        return ((DataSource)dataSource).buildDatasourceScanRuntime(this, dataSource, scanVariables, projectVariables, projectPushed, minFilterVars, maxFilterVars, tupleFilterFactory, outputLimit, opSchema, typeEnv, context, jobSpec, implConfig, projectionFiltrationInfo);
    }

    protected Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getLoadableDatasetScanRuntime(JobSpecification jobSpec, ITypedAdapterFactory adapterFactory, RecordDescriptor rDesc) throws AlgebricksException {
        ExternalScanOperatorDescriptor dataScanner = new ExternalScanOperatorDescriptor(jobSpec, rDesc, adapterFactory);
        try {
            return new Pair((Object)dataScanner, (Object)adapterFactory.getPartitionConstraint());
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    public Dataverse findDataverse(String database, DataverseName dataverseName) throws AlgebricksException {
        return MetadataManager.INSTANCE.getDataverse(this.mdTxnCtx, database, dataverseName);
    }

    public Triple<IOperatorDescriptor, AlgebricksPartitionConstraint, ITypedAdapterFactory> getFeedIntakeRuntime(JobSpecification jobSpec, Feed feed, FeedPolicyAccessor policyAccessor) throws Exception {
        Triple<ITypedAdapterFactory, RecordDescriptor, IDataSourceAdapter.AdapterType> factoryOutput = FeedMetadataUtil.getFeedFactoryAndOutput(feed, policyAccessor, this.mdTxnCtx, this.getApplicationContext());
        ARecordType recordType = FeedMetadataUtil.getOutputType(feed, feed.getConfiguration().get("type-name"));
        ITypedAdapterFactory adapterFactory = (ITypedAdapterFactory)factoryOutput.first;
        FeedIntakeOperatorDescriptor feedIngestor = null;
        switch ((IDataSourceAdapter.AdapterType)factoryOutput.third) {
            case INTERNAL: {
                feedIngestor = new FeedIntakeOperatorDescriptor(jobSpec, (IFeed)feed, adapterFactory, recordType, policyAccessor, (RecordDescriptor)factoryOutput.second);
                break;
            }
            case EXTERNAL: {
                ExternalAdapterFactory extAdapterFactory = (ExternalAdapterFactory)adapterFactory;
                feedIngestor = new FeedIntakeOperatorDescriptor(jobSpec, (IFeed)feed, extAdapterFactory.getLibraryDatabase(), extAdapterFactory.getLibraryDataverse(), extAdapterFactory.getLibraryName(), extAdapterFactory.getClassName(), recordType, policyAccessor, (RecordDescriptor)factoryOutput.second);
                break;
            }
        }
        AlgebricksAbsolutePartitionConstraint partitionConstraint = adapterFactory.getPartitionConstraint();
        return new Triple(feedIngestor, (Object)partitionConstraint, (Object)adapterFactory);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getBtreeSearchRuntime(JobSpecification jobSpec, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, boolean retainInput, boolean retainMissing, IMissingWriterFactory nonMatchWriterFactory, Dataset dataset, String indexName, int[] lowKeyFields, int[] highKeyFields, boolean lowKeyInclusive, boolean highKeyInclusive, boolean propagateFilter, IMissingWriterFactory nonFilterWriterFactory, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes, ITupleFilterFactory tupleFilterFactory, long outputLimit, boolean isIndexOnlyPlan, boolean isPrimaryIndexPointSearch, ITupleProjectorFactory tupleProjectorFactory, boolean partitionInputTuples) throws AlgebricksException {
        boolean proceedIndexOnlyPlan;
        int numSecondaryKeys;
        boolean isSecondary = true;
        Index primaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName());
        if (primaryIndex != null && dataset.getDatasetType() != DatasetConfig.DatasetType.EXTERNAL) {
            isSecondary = !indexName.equals(primaryIndex.getIndexName());
        }
        Index theIndex = isSecondary ? MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName(), indexName) : primaryIndex;
        switch (theIndex.getIndexType()) {
            case ARRAY: {
                numSecondaryKeys = ((Index.ArrayIndexDetails)theIndex.getIndexDetails()).getElementList().stream().map(e -> e.getProjectList().size()).reduce(0, Integer::sum);
                break;
            }
            case BTREE: {
                numSecondaryKeys = ((Index.ValueIndexDetails)theIndex.getIndexDetails()).getKeyFieldNames().size();
                break;
            }
            case SAMPLE: {
                if (isIndexOnlyPlan) {
                    throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, new Serializable[]{""});
                }
                numSecondaryKeys = 0;
                break;
            }
            default: {
                throw new CompilationException(ErrorCode.COMPILATION_UNKNOWN_INDEX_TYPE, new Serializable[]{theIndex.getIndexType().toString()});
            }
        }
        int numPrimaryKeys = dataset.getPrimaryKeys().size();
        RecordDescriptor outputRecDesc = JobGenHelper.mkRecordDescriptor((IVariableTypeEnvironment)typeEnv, (IOperatorSchema)opSchema, (JobGenContext)context);
        PartitioningProperties datasetPartitioningProp = this.getPartitioningProperties(dataset, theIndex.getIndexName());
        int[] primaryKeyFields = new int[numPrimaryKeys];
        for (int i = 0; i < numPrimaryKeys; ++i) {
            primaryKeyFields[i] = i;
        }
        int[] primaryKeyFieldsInSecondaryIndex = null;
        byte[] successValueForIndexOnlyPlan = null;
        byte[] failValueForIndexOnlyPlan = null;
        boolean bl = proceedIndexOnlyPlan = isIndexOnlyPlan && isSecondary;
        if (proceedIndexOnlyPlan) {
            primaryKeyFieldsInSecondaryIndex = new int[numPrimaryKeys];
            for (int i = 0; i < numPrimaryKeys; ++i) {
                primaryKeyFieldsInSecondaryIndex[i] = i + numSecondaryKeys;
            }
            failValueForIndexOnlyPlan = SerializerDeserializerUtil.computeByteArrayForIntValue((int)0);
            successValueForIndexOnlyPlan = SerializerDeserializerUtil.computeByteArrayForIntValue((int)1);
        }
        ISearchOperationCallbackFactory searchCallbackFactory = dataset.getSearchCallbackFactory(this.storageComponentProvider, theIndex, IndexOperation.SEARCH, primaryKeyFields, primaryKeyFieldsInSecondaryIndex, proceedIndexOnlyPlan);
        IStorageManager storageManager = this.getStorageComponentProvider().getStorageManager();
        IndexDataflowHelperFactory indexHelperFactory = new IndexDataflowHelperFactory(storageManager, datasetPartitioningProp.getSplitsProvider());
        int[][] partitionsMap = datasetPartitioningProp.getComputeStorageMap();
        FieldHashPartitionerFactory tuplePartitionerFactory = null;
        if (partitionInputTuples) {
            IBinaryHashFunctionFactory[] pkHashFunFactories = dataset.getPrimaryHashFunctionFactories(this);
            tuplePartitionerFactory = new FieldHashPartitionerFactory(lowKeyFields, pkHashFunFactories, datasetPartitioningProp.getNumberOfPartitions());
        }
        Object btreeSearchOp = dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL ? (!isSecondary && isPrimaryIndexPointSearch ? new LSMBTreeBatchPointSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, outputRecDesc, lowKeyFields, highKeyFields, lowKeyInclusive, highKeyInclusive, (IIndexDataflowHelperFactory)indexHelperFactory, retainInput, retainMissing, nonMatchWriterFactory, searchCallbackFactory, minFilterFieldIndexes, maxFilterFieldIndexes, tupleFilterFactory, outputLimit, tupleProjectorFactory, (ITuplePartitionerFactory)tuplePartitionerFactory, partitionsMap) : new BTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, outputRecDesc, lowKeyFields, highKeyFields, lowKeyInclusive, highKeyInclusive, (IIndexDataflowHelperFactory)indexHelperFactory, retainInput, retainMissing, nonMatchWriterFactory, searchCallbackFactory, minFilterFieldIndexes, maxFilterFieldIndexes, propagateFilter, nonFilterWriterFactory, tupleFilterFactory, outputLimit, proceedIndexOnlyPlan, failValueForIndexOnlyPlan, successValueForIndexOnlyPlan, tupleProjectorFactory, (ITuplePartitionerFactory)tuplePartitionerFactory, partitionsMap)) : null;
        return new Pair(btreeSearchOp, (Object)datasetPartitioningProp.getConstraints());
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getRtreeSearchRuntime(JobSpecification jobSpec, List<LogicalVariable> outputVars, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, boolean retainInput, boolean retainMissing, IMissingWriterFactory nonMatchWriterFactory, Dataset dataset, String indexName, int[] keyFields, boolean propagateFilter, IMissingWriterFactory nonFilterWriterFactory, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes, boolean isIndexOnlyPlan) throws AlgebricksException {
        RTreeSearchOperatorDescriptor rtreeSearchOp;
        int numPrimaryKeys = dataset.getPrimaryKeys().size();
        Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName(), indexName);
        if (secondaryIndex == null) {
            throw new AlgebricksException("Code generation error: no index " + indexName + " for " + IdentifierUtil.dataset() + " " + dataset.getDatasetName());
        }
        Index.ValueIndexDetails secondaryIndexDetails = (Index.ValueIndexDetails)secondaryIndex.getIndexDetails();
        RecordDescriptor outputRecDesc = JobGenHelper.mkRecordDescriptor((IVariableTypeEnvironment)typeEnv, (IOperatorSchema)opSchema, (JobGenContext)context);
        PartitioningProperties partitioningProperties = this.getPartitioningProperties(dataset, secondaryIndex.getIndexName());
        int[] primaryKeyFields = new int[numPrimaryKeys];
        for (int i = 0; i < numPrimaryKeys; ++i) {
            primaryKeyFields[i] = i;
        }
        int[] primaryKeyFieldsInSecondaryIndex = null;
        byte[] successValueForIndexOnlyPlan = null;
        byte[] failValueForIndexOnlyPlan = null;
        if (isIndexOnlyPlan) {
            ARecordType recType = (ARecordType)this.findType(dataset.getItemTypeDatabaseName(), dataset.getItemTypeDataverseName(), dataset.getItemTypeName());
            List<List<String>> secondaryKeyFields = secondaryIndexDetails.getKeyFieldNames();
            List<IAType> secondaryKeyTypes = secondaryIndexDetails.getKeyFieldTypes();
            Pair<IAType, Boolean> keyTypePair = Index.getNonNullableOpenFieldType(secondaryIndex, secondaryKeyTypes.get(0), secondaryKeyFields.get(0), recType);
            IAType keyType = (IAType)keyTypePair.first;
            int numDimensions = NonTaggedFormatUtil.getNumDimensions((ATypeTag)keyType.getTypeTag());
            int numNestedSecondaryKeyFields = numDimensions * 2;
            primaryKeyFieldsInSecondaryIndex = new int[numPrimaryKeys];
            for (int i = 0; i < numPrimaryKeys; ++i) {
                primaryKeyFieldsInSecondaryIndex[i] = i + numNestedSecondaryKeyFields;
            }
            failValueForIndexOnlyPlan = SerializerDeserializerUtil.computeByteArrayForIntValue((int)0);
            successValueForIndexOnlyPlan = SerializerDeserializerUtil.computeByteArrayForIntValue((int)1);
        }
        ISearchOperationCallbackFactory searchCallbackFactory = dataset.getSearchCallbackFactory(this.storageComponentProvider, secondaryIndex, IndexOperation.SEARCH, primaryKeyFields, primaryKeyFieldsInSecondaryIndex, isIndexOnlyPlan);
        IndexDataflowHelperFactory indexDataflowHelperFactory = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), partitioningProperties.getSplitsProvider());
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            int[][] partitionsMap = partitioningProperties.getComputeStorageMap();
            rtreeSearchOp = new RTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, outputRecDesc, keyFields, true, true, (IIndexDataflowHelperFactory)indexDataflowHelperFactory, retainInput, retainMissing, nonMatchWriterFactory, searchCallbackFactory, minFilterFieldIndexes, maxFilterFieldIndexes, propagateFilter, nonFilterWriterFactory, isIndexOnlyPlan, failValueForIndexOnlyPlan, successValueForIndexOnlyPlan, partitionsMap);
        } else {
            rtreeSearchOp = null;
        }
        return new Pair(rtreeSearchOp, (Object)partitioningProperties.getConstraints());
    }

    public Pair<IPushRuntimeFactory, AlgebricksPartitionConstraint> getWriteFileRuntime(int sourceColumn, int[] partitionColumns, IBinaryComparatorFactory[] partitionComparatorFactories, IScalarEvaluatorFactory dynamicPathEvalFactory, ILogicalExpression staticPathExpr, SourceLocation pathSourceLocation, IWriteDataSink sink, RecordDescriptor inputDesc, Object sourceType) throws AlgebricksException {
        String staticPath = staticPathExpr != null ? ConstantExpressionUtil.getStringConstant((ILogicalExpression)staticPathExpr) : null;
        IExternalFileWriterFactory fileWriterFactory = ExternalWriterProvider.createWriterFactory(this.appCtx, sink, staticPath, pathSourceLocation);
        fileWriterFactory.validate();
        String fileExtension = ExternalWriterProvider.getFileExtension(sink);
        int maxResult = ExternalWriterProvider.getMaxResult(sink);
        IExternalFilePrinterFactory printerFactory = ExternalWriterProvider.createPrinter(sink, sourceType);
        ExternalWriterFactory writerFactory = new ExternalWriterFactory(fileWriterFactory, printerFactory, fileExtension, maxResult, dynamicPathEvalFactory, staticPath, pathSourceLocation);
        SinkExternalWriterRuntimeFactory runtime = new SinkExternalWriterRuntimeFactory(sourceColumn, partitionColumns, partitionComparatorFactories, inputDesc, (IExternalWriterFactory)writerFactory);
        return new Pair((Object)runtime, null);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getResultHandleRuntime(IDataSink sink, int[] printColumns, IPrinterFactory[] printerFactories, IAWriterFactory writerFactory, IResultSerializerFactoryProvider resultSerializerFactoryProvider, RecordDescriptor inputDesc, IResultMetadata metadata, JobSpecification spec) throws AlgebricksException {
        ResultSetDataSink rsds = (ResultSetDataSink)sink;
        ResultSetSinkId rssId = rsds.getId();
        ResultSetId rsId = rssId.getResultSetId();
        ResultWriterOperatorDescriptor resultWriter = null;
        try {
            IResultSerializerFactory resultSerializedAppenderFactory = resultSerializerFactoryProvider.getResultSerializerFactoryProvider(printColumns, printerFactories, writerFactory);
            resultWriter = new ResultWriterOperatorDescriptor((IOperatorDescriptorRegistry)spec, rsId, metadata, this.getResultAsyncMode(), resultSerializedAppenderFactory, this.getMaxResultReads());
        }
        catch (IOException e) {
            throw new AlgebricksException((Throwable)e);
        }
        return new Pair((Object)resultWriter, null);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getInsertRuntime(IDataSource<DataSourceId> dataSource, IOperatorSchema propagatedSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> keys, LogicalVariable payload, List<LogicalVariable> additionalNonKeyFields, List<LogicalVariable> additionalNonFilteringFields, RecordDescriptor inputRecordDesc, JobGenContext context, JobSpecification spec, boolean bulkload) throws AlgebricksException {
        return this.getInsertOrDeleteRuntime(IndexOperation.INSERT, dataSource, propagatedSchema, keys, payload, additionalNonKeyFields, inputRecordDesc, context, spec, bulkload, additionalNonFilteringFields);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getDeleteRuntime(IDataSource<DataSourceId> dataSource, IOperatorSchema propagatedSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> keys, LogicalVariable payload, List<LogicalVariable> additionalNonKeyFields, List<LogicalVariable> additionalNonFilteringFields, RecordDescriptor inputRecordDesc, JobGenContext context, JobSpecification spec) throws AlgebricksException {
        return this.getInsertOrDeleteRuntime(IndexOperation.DELETE, dataSource, propagatedSchema, keys, payload, additionalNonKeyFields, inputRecordDesc, context, spec, false, additionalNonFilteringFields);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getUpsertRuntime(IDataSource<DataSourceId> dataSource, IOperatorSchema inputSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, LogicalVariable payload, List<LogicalVariable> filterKeys, List<LogicalVariable> additionalNonFilterFields, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec) throws AlgebricksException {
        int idx;
        DataverseName dataverseName = ((DataSourceId)dataSource.getId()).getDataverseName();
        String datasetName = ((DataSourceId)dataSource.getId()).getDatasourceName();
        String database = ((DataSourceId)dataSource.getId()).getDatabaseName();
        Dataset dataset = this.findDataset(database, dataverseName, datasetName);
        if (dataset == null) {
            throw new AsterixException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, new Serializable[]{datasetName, MetadataUtil.dataverseName((String)database, (DataverseName)dataverseName, (boolean)this.isUsingDatabase())});
        }
        int numKeys = primaryKeys.size();
        int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
        int numOfAdditionalFields = additionalNonFilterFields == null ? 0 : additionalNonFilterFields.size();
        int[] fieldPermutation = new int[numKeys + 1 + numFilterFields + numOfAdditionalFields];
        int[] bloomFilterKeyFields = new int[numKeys];
        int i = 0;
        for (LogicalVariable varKey : primaryKeys) {
            fieldPermutation[i] = idx = inputSchema.findVariable(varKey);
            bloomFilterKeyFields[i] = i;
            ++i;
        }
        fieldPermutation[i++] = inputSchema.findVariable(payload);
        if (additionalNonFilterFields != null) {
            for (LogicalVariable var : additionalNonFilterFields) {
                idx = inputSchema.findVariable(var);
                fieldPermutation[i++] = idx;
            }
        }
        if (numFilterFields > 0) {
            int idx2 = inputSchema.findVariable(filterKeys.get(0));
            fieldPermutation[i++] = idx2;
        }
        return this.createPrimaryIndexUpsertOp(spec, this, dataset, recordDesc, fieldPermutation, context.getMissingWriterFactory());
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexInsertRuntime(IDataSourceIndex<String, DataSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, ILogicalExpression filterExpr, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, boolean bulkload, List<List<AlgebricksPipeline>> secondaryKeysPipelines, IOperatorSchema pipelineTopSchema) throws AlgebricksException {
        return this.getIndexModificationRuntime(IndexOperation.INSERT, dataSourceIndex, propagatedSchema, inputSchemas, typeEnv, primaryKeys, secondaryKeys, additionalNonKeyFields, filterExpr, null, recordDesc, context, spec, bulkload, null, null, null, secondaryKeysPipelines, pipelineTopSchema);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexDeleteRuntime(IDataSourceIndex<String, DataSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, ILogicalExpression filterExpr, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, List<List<AlgebricksPipeline>> secondaryKeysPipelines, IOperatorSchema pipelineTopSchema) throws AlgebricksException {
        return this.getIndexModificationRuntime(IndexOperation.DELETE, dataSourceIndex, propagatedSchema, inputSchemas, typeEnv, primaryKeys, secondaryKeys, additionalNonKeyFields, filterExpr, null, recordDesc, context, spec, false, null, null, null, secondaryKeysPipelines, pipelineTopSchema);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexUpsertRuntime(IDataSourceIndex<String, DataSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalFilteringKeys, ILogicalExpression filterExpr, ILogicalExpression prevFilterExpr, LogicalVariable operationVar, List<LogicalVariable> prevSecondaryKeys, LogicalVariable prevAdditionalFilteringKey, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, List<List<AlgebricksPipeline>> secondaryKeysPipelines) throws AlgebricksException {
        return this.getIndexModificationRuntime(IndexOperation.UPSERT, dataSourceIndex, propagatedSchema, inputSchemas, typeEnv, primaryKeys, secondaryKeys, additionalFilteringKeys, filterExpr, prevFilterExpr, recordDesc, context, spec, false, operationVar, prevSecondaryKeys, prevAdditionalFilteringKey, secondaryKeysPipelines, null);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getTokenizerRuntime(IDataSourceIndex<String, DataSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, ILogicalExpression filterExpr, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, boolean bulkload) throws AlgebricksException {
        String indexName = (String)dataSourceIndex.getId();
        DataverseName dataverseName = ((DataSourceId)dataSourceIndex.getDataSource().getId()).getDataverseName();
        String datasetName = ((DataSourceId)dataSourceIndex.getDataSource().getId()).getDatasourceName();
        String database = ((DataSourceId)dataSourceIndex.getDataSource().getId()).getDatabaseName();
        if (inputSchemas.length <= 0) {
            throw new AlgebricksException("TokenizeOperator can not operate without any input variable.");
        }
        IOperatorSchema inputSchema = inputSchemas[0];
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, database, dataverseName, datasetName);
        Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName(), indexName);
        switch (secondaryIndex.getIndexType()) {
            case SINGLE_PARTITION_WORD_INVIX: 
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: 
            case LENGTH_PARTITIONED_NGRAM_INVIX: {
                return this.getBinaryTokenizerRuntime(database, dataverseName, datasetName, indexName, inputSchema, propagatedSchema, primaryKeys, secondaryKeys, recordDesc, spec, secondaryIndex.getIndexType());
            }
        }
        throw new AlgebricksException("Currently, we do not support TokenizeOperator for the index type: " + secondaryIndex.getIndexType());
    }

    public long getCardinalityPerPartitionHint(Dataset dataset) throws AlgebricksException {
        String numElementsHintString = dataset.getHints().get("CARDINALITY");
        long numElementsHint = numElementsHintString == null ? 1000000L : Long.parseLong(numElementsHintString);
        int numPartitions = this.getPartitioningProperties(dataset).getNumberOfPartitions();
        return numElementsHint / (long)numPartitions;
    }

    protected ITypedAdapterFactory getConfiguredAdapterFactory(Dataset dataset, String adapterName, Map<String, String> configuration, ARecordType itemType, IWarningCollector warningCollector, IExternalFilterEvaluatorFactory filterEvaluatorFactory) throws AlgebricksException {
        try {
            configuration.put("dataset-database", dataset.getDatabaseName());
            configuration.put("dataset-dataverse", dataset.getDataverseName().getCanonicalForm());
            return AdapterFactoryProvider.getAdapterFactory((ICCServiceContext)this.getApplicationContext().getServiceContext(), (String)adapterName, configuration, (ARecordType)itemType, null, (IWarningCollector)warningCollector, (IExternalFilterEvaluatorFactory)filterEvaluatorFactory);
        }
        catch (Exception e) {
            throw new AlgebricksException("Unable to create adapter", (Throwable)e);
        }
    }

    public TxnId getTxnId() {
        return this.txnId;
    }

    public static ILinearizeComparatorFactory proposeLinearizer(ATypeTag keyType, int numKeyFields) throws AlgebricksException {
        return LinearizeComparatorFactoryProvider.INSTANCE.getLinearizeComparatorFactory((Object)keyType, true, numKeyFields / 2);
    }

    public PartitioningProperties splitAndConstraints(String databaseName) {
        return this.dataPartitioningProvider.getPartitioningProperties(databaseName);
    }

    public PartitioningProperties splitAndConstraints(String databaseName, DataverseName dataverseName) {
        return this.dataPartitioningProvider.getPartitioningProperties(databaseName, dataverseName);
    }

    public FileSplit[] splitsForIndex(MetadataTransactionContext mdTxnCtx, Dataset dataset, String indexName) throws AlgebricksException {
        return this.dataPartitioningProvider.getPartitioningProperties(mdTxnCtx, dataset, indexName).getSplitsProvider().getFileSplits();
    }

    public DatasourceAdapter getAdapter(MetadataTransactionContext mdTxnCtx, String database, DataverseName dataverseName, String adapterName) throws AlgebricksException {
        DatasourceAdapter adapter = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, "System", MetadataConstants.METADATA_DATAVERSE_NAME, adapterName);
        if (adapter == null) {
            adapter = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, database, dataverseName, adapterName);
        }
        return adapter;
    }

    public AlgebricksAbsolutePartitionConstraint getClusterLocations() {
        return this.appCtx.getClusterStateManager().getClusterLocations();
    }

    public DataPartitioningProvider getDataPartitioningProvider() {
        return this.dataPartitioningProvider;
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildExternalDataLookupRuntime(JobSpecification jobSpec, Dataset dataset, int[] ridIndexes, boolean retainInput, IVariableTypeEnvironment typeEnv, IOperatorSchema opSchema, JobGenContext context, MetadataProvider metadataProvider, boolean retainMissing) throws AlgebricksException {
        return null;
    }

    protected Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> createPrimaryIndexUpsertOp(JobSpecification spec, MetadataProvider metadataProvider, Dataset dataset, RecordDescriptor inputRecordDesc, int[] fieldPermutation, IMissingWriterFactory missingWriterFactory) throws AlgebricksException {
        return DatasetUtil.createPrimaryIndexUpsertOp(spec, this, dataset, inputRecordDesc, fieldPermutation, missingWriterFactory);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getExternalDatasetScanRuntime(JobSpecification jobSpec, IAType itemType, ITypedAdapterFactory adapterFactory, ITupleFilterFactory tupleFilterFactory, long outputLimit) throws AlgebricksException {
        AlgebricksAbsolutePartitionConstraint constraint;
        if (itemType.getTypeTag() != ATypeTag.OBJECT) {
            throw new AlgebricksException("Can only scan " + IdentifierUtil.dataset((IIdentifierMapper.Modifier)IIdentifierMapper.Modifier.PLURAL) + "of records.");
        }
        ISerializerDeserializer payloadSerde = this.getDataFormat().getSerdeProvider().getSerializerDeserializer((Object)itemType);
        RecordDescriptor scannerDesc = new RecordDescriptor(new ISerializerDeserializer[]{payloadSerde});
        ExternalScanOperatorDescriptor dataScanner = new ExternalScanOperatorDescriptor(jobSpec, scannerDesc, adapterFactory, tupleFilterFactory, outputLimit);
        try {
            constraint = adapterFactory.getPartitionConstraint();
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
        return new Pair((Object)dataScanner, (Object)constraint);
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getInsertOrDeleteRuntime(IndexOperation indexOp, IDataSource<DataSourceId> dataSource, IOperatorSchema propagatedSchema, List<LogicalVariable> keys, LogicalVariable payload, List<LogicalVariable> additionalNonKeyFields, RecordDescriptor inputRecordDesc, JobGenContext context, JobSpecification spec, boolean bulkload, List<LogicalVariable> additionalNonFilteringFields) throws AlgebricksException {
        LSMTreeInsertDeleteOperatorDescriptor op;
        int idx;
        String datasetName = ((DataSourceId)dataSource.getId()).getDatasourceName();
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, ((DataSourceId)dataSource.getId()).getDatabaseName(), ((DataSourceId)dataSource.getId()).getDataverseName(), datasetName);
        int numKeys = keys.size();
        int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + 1 + numFilterFields + (additionalNonFilteringFields == null ? 0 : additionalNonFilteringFields.size())];
        int[] bloomFilterKeyFields = new int[numKeys];
        int[] pkFields = new int[numKeys];
        int i = 0;
        for (LogicalVariable varKey : keys) {
            pkFields[i] = idx = propagatedSchema.findVariable(varKey);
            fieldPermutation[i] = idx;
            bloomFilterKeyFields[i] = i;
            ++i;
        }
        fieldPermutation[i++] = propagatedSchema.findVariable(payload);
        if (additionalNonFilteringFields != null) {
            for (LogicalVariable variable : additionalNonFilteringFields) {
                idx = propagatedSchema.findVariable(variable);
                fieldPermutation[i++] = idx;
            }
        }
        int[] filterFields = new int[numFilterFields];
        if (numFilterFields > 0) {
            int idx2 = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
            fieldPermutation[i++] = idx2;
            filterFields[0] = idx2;
        }
        Index primaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName());
        PartitioningProperties partitioningProperties = this.getPartitioningProperties(dataset);
        int[] primaryKeyFields = new int[numKeys];
        for (i = 0; i < numKeys; ++i) {
            primaryKeyFields[i] = i;
        }
        IModificationOperationCallbackFactory modificationCallbackFactory = dataset.getModificationCallbackFactory(this.storageComponentProvider, primaryIndex, indexOp, primaryKeyFields);
        IndexDataflowHelperFactory idfh = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), partitioningProperties.getSplitsProvider());
        IBinaryHashFunctionFactory[] pkHashFunFactories = dataset.getPrimaryHashFunctionFactories(this);
        FieldHashPartitionerFactory partitionerFactory = new FieldHashPartitionerFactory(pkFields, pkHashFunFactories, partitioningProperties.getNumberOfPartitions());
        if (bulkload) {
            long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
            op = new LSMIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, inputRecordDesc, fieldPermutation, 1.0f, true, numElementsHint, true, (IIndexDataflowHelperFactory)idfh, null, LSMIndexBulkLoadOperatorDescriptor.BulkLoadUsage.LOAD, dataset.getDatasetId(), null, (ITuplePartitionerFactory)partitionerFactory, partitioningProperties.getComputeStorageMap());
        } else if (indexOp == IndexOperation.INSERT) {
            ISearchOperationCallbackFactory searchCallbackFactory = dataset.getSearchCallbackFactory(this.storageComponentProvider, primaryIndex, indexOp, primaryKeyFields);
            Optional<Index> primaryKeyIndex = MetadataManager.INSTANCE.getDatasetIndexes(this.mdTxnCtx, dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName()).stream().filter(Index::isPrimaryKeyIndex).findFirst();
            IndexDataflowHelperFactory pkidfh = null;
            if (primaryKeyIndex.isPresent()) {
                PartitioningProperties idxPartitioningProperties = this.getPartitioningProperties(dataset, primaryKeyIndex.get().getIndexName());
                pkidfh = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), idxPartitioningProperties.getSplitsProvider());
            }
            op = this.createLSMPrimaryInsertOperatorDescriptor(spec, inputRecordDesc, fieldPermutation, (IIndexDataflowHelperFactory)idfh, (IIndexDataflowHelperFactory)pkidfh, modificationCallbackFactory, searchCallbackFactory, numKeys, filterFields, (ITuplePartitionerFactory)partitionerFactory, partitioningProperties.getComputeStorageMap());
        } else {
            op = this.createLSMTreeInsertDeleteOperatorDescriptor((IOperatorDescriptorRegistry)spec, inputRecordDesc, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)idfh, null, true, modificationCallbackFactory, (ITuplePartitionerFactory)partitionerFactory, partitioningProperties.getComputeStorageMap());
        }
        return new Pair((Object)op, (Object)partitioningProperties.getConstraints());
    }

    protected LSMPrimaryInsertOperatorDescriptor createLSMPrimaryInsertOperatorDescriptor(JobSpecification spec, RecordDescriptor inputRecordDesc, int[] fieldPermutation, IIndexDataflowHelperFactory idfh, IIndexDataflowHelperFactory pkidfh, IModificationOperationCallbackFactory modificationCallbackFactory, ISearchOperationCallbackFactory searchCallbackFactory, int numKeys, int[] filterFields, ITuplePartitionerFactory tuplePartitionerFactory, int[][] partitionsMap) {
        return new LSMPrimaryInsertOperatorDescriptor((IOperatorDescriptorRegistry)spec, inputRecordDesc, fieldPermutation, idfh, pkidfh, modificationCallbackFactory, searchCallbackFactory, numKeys, filterFields, tuplePartitionerFactory, partitionsMap);
    }

    protected LSMTreeInsertDeleteOperatorDescriptor createLSMTreeInsertDeleteOperatorDescriptor(IOperatorDescriptorRegistry spec, RecordDescriptor outRecDesc, int[] fieldPermutation, IndexOperation op, IIndexDataflowHelperFactory indexHelperFactory, ITupleFilterFactory tupleFilterFactory, boolean isPrimary, IModificationOperationCallbackFactory modCallbackFactory, ITuplePartitionerFactory tuplePartitionerFactory, int[][] partitionsMap) {
        return new LSMTreeInsertDeleteOperatorDescriptor(spec, outRecDesc, fieldPermutation, op, indexHelperFactory, tupleFilterFactory, isPrimary, modCallbackFactory, tuplePartitionerFactory, partitionsMap);
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexModificationRuntime(IndexOperation indexOp, IDataSourceIndex<String, DataSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, ILogicalExpression filterExpr, ILogicalExpression prevFilterExpr, RecordDescriptor inputRecordDesc, JobGenContext context, JobSpecification spec, boolean bulkload, LogicalVariable operationVar, List<LogicalVariable> prevSecondaryKeys, LogicalVariable prevAdditionalFilteringKey, List<List<AlgebricksPipeline>> secondaryKeysPipelines, IOperatorSchema pipelineTopSchema) throws AlgebricksException {
        AsterixTupleFilterFactory prevFilterFactory;
        AsterixTupleFilterFactory filterFactory;
        String indexName = (String)dataSourceIndex.getId();
        DataverseName dataverseName = ((DataSourceId)dataSourceIndex.getDataSource().getId()).getDataverseName();
        String database = ((DataSourceId)dataSourceIndex.getDataSource().getId()).getDatabaseName();
        String datasetName = ((DataSourceId)dataSourceIndex.getDataSource().getId()).getDatasourceName();
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, database, dataverseName, datasetName);
        Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName(), indexName);
        ArrayList<LogicalVariable> prevAdditionalFilteringKeys = null;
        if (indexOp == IndexOperation.UPSERT && prevAdditionalFilteringKey != null) {
            prevAdditionalFilteringKeys = new ArrayList<LogicalVariable>();
            prevAdditionalFilteringKeys.add(prevAdditionalFilteringKey);
        }
        if (pipelineTopSchema != null) {
            IOperatorSchema[] schemasForFilterFactory = new IOperatorSchema[inputSchemas.length + 1];
            System.arraycopy(inputSchemas, 0, schemasForFilterFactory, 0, inputSchemas.length);
            schemasForFilterFactory[inputSchemas.length] = pipelineTopSchema;
            filterFactory = this.createTupleFilterFactory(schemasForFilterFactory, typeEnv, filterExpr, context);
            prevFilterFactory = this.createTupleFilterFactory(schemasForFilterFactory, typeEnv, prevFilterExpr, context);
        } else {
            filterFactory = this.createTupleFilterFactory(inputSchemas, typeEnv, filterExpr, context);
            prevFilterFactory = this.createTupleFilterFactory(inputSchemas, typeEnv, prevFilterExpr, context);
        }
        switch (secondaryIndex.getIndexType()) {
            case BTREE: {
                return this.getBTreeModificationRuntime(database, dataverseName, datasetName, indexName, propagatedSchema, primaryKeys, secondaryKeys, additionalNonKeyFields, filterFactory, prevFilterFactory, inputRecordDesc, context, spec, indexOp, bulkload, operationVar, prevSecondaryKeys, prevAdditionalFilteringKeys);
            }
            case ARRAY: {
                if (bulkload) {
                    return this.getBTreeModificationRuntime(database, dataverseName, datasetName, indexName, propagatedSchema, primaryKeys, secondaryKeys, additionalNonKeyFields, filterFactory, prevFilterFactory, inputRecordDesc, context, spec, indexOp, bulkload, operationVar, prevSecondaryKeys, prevAdditionalFilteringKeys);
                }
                return this.getArrayIndexModificationRuntime(database, dataverseName, datasetName, indexName, propagatedSchema, primaryKeys, additionalNonKeyFields, inputRecordDesc, spec, indexOp, operationVar, secondaryKeysPipelines);
            }
            case RTREE: {
                return this.getRTreeModificationRuntime(database, dataverseName, datasetName, indexName, propagatedSchema, primaryKeys, secondaryKeys, additionalNonKeyFields, filterFactory, prevFilterFactory, inputRecordDesc, context, spec, indexOp, bulkload, operationVar, prevSecondaryKeys, prevAdditionalFilteringKeys);
            }
            case SINGLE_PARTITION_WORD_INVIX: 
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: 
            case LENGTH_PARTITIONED_NGRAM_INVIX: {
                return this.getInvertedIndexModificationRuntime(database, dataverseName, datasetName, indexName, propagatedSchema, primaryKeys, secondaryKeys, additionalNonKeyFields, filterFactory, prevFilterFactory, inputRecordDesc, context, spec, indexOp, secondaryIndex.getIndexType(), bulkload, operationVar, prevSecondaryKeys, prevAdditionalFilteringKeys);
            }
        }
        throw new AlgebricksException(indexOp.name() + " not implemented for index type: " + secondaryIndex.getIndexType());
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getBTreeModificationRuntime(String database, DataverseName dataverseName, String datasetName, String indexName, IOperatorSchema propagatedSchema, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, AsterixTupleFilterFactory filterFactory, AsterixTupleFilterFactory prevFilterFactory, RecordDescriptor inputRecordDesc, JobGenContext context, JobSpecification spec, IndexOperation indexOp, boolean bulkload, LogicalVariable operationVar, List<LogicalVariable> prevSecondaryKeys, List<LogicalVariable> prevAdditionalFilteringKeys) throws AlgebricksException {
        int idx;
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, database, dataverseName, datasetName);
        int numKeys = primaryKeys.size() + secondaryKeys.size();
        int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + numFilterFields];
        int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
        int[] pkFields = new int[primaryKeys.size()];
        int i = 0;
        int j = 0;
        for (LogicalVariable varKey : secondaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            ++i;
        }
        for (LogicalVariable varKey : primaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            pkFields[j] = idx;
            modificationCallbackPrimaryKeyFields[j] = i++;
            ++j;
        }
        if (numFilterFields > 0) {
            int idx2;
            fieldPermutation[numKeys] = idx2 = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
        }
        int[] prevFieldPermutation = null;
        if (indexOp == IndexOperation.UPSERT) {
            int idx3;
            prevFieldPermutation = new int[numKeys + numFilterFields];
            int k = 0;
            for (LogicalVariable varKey : prevSecondaryKeys) {
                prevFieldPermutation[k] = idx3 = propagatedSchema.findVariable(varKey);
                ++k;
            }
            for (LogicalVariable varKey : primaryKeys) {
                prevFieldPermutation[k] = idx3 = propagatedSchema.findVariable(varKey);
                ++k;
            }
            if (numFilterFields > 0) {
                int idx4;
                prevFieldPermutation[numKeys] = idx4 = propagatedSchema.findVariable(prevAdditionalFilteringKeys.get(0));
            }
        }
        try {
            LSMTreeInsertDeleteOperatorDescriptor op;
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            PartitioningProperties partitioningProperties = this.getPartitioningProperties(dataset, secondaryIndex.getIndexName());
            IModificationOperationCallbackFactory modificationCallbackFactory = dataset.getModificationCallbackFactory(this.storageComponentProvider, secondaryIndex, indexOp, modificationCallbackPrimaryKeyFields);
            IndexDataflowHelperFactory idfh = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), partitioningProperties.getSplitsProvider());
            IBinaryHashFunctionFactory[] pkHashFunFactories = dataset.getPrimaryHashFunctionFactories(this);
            FieldHashPartitionerFactory partitionerFactory = new FieldHashPartitionerFactory(pkFields, pkHashFunFactories, partitioningProperties.getNumberOfPartitions());
            if (bulkload) {
                long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
                op = new LSMIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, inputRecordDesc, fieldPermutation, 1.0f, false, numElementsHint, false, (IIndexDataflowHelperFactory)idfh, null, LSMIndexBulkLoadOperatorDescriptor.BulkLoadUsage.LOAD, dataset.getDatasetId(), (ITupleFilterFactory)filterFactory, (ITuplePartitionerFactory)partitionerFactory, partitioningProperties.getComputeStorageMap());
            } else if (indexOp == IndexOperation.UPSERT) {
                int operationFieldIndex = propagatedSchema.findVariable(operationVar);
                op = new LSMSecondaryUpsertOperatorDescriptor((IOperatorDescriptorRegistry)spec, inputRecordDesc, fieldPermutation, (IIndexDataflowHelperFactory)idfh, (ITupleFilterFactory)filterFactory, (ITupleFilterFactory)prevFilterFactory, modificationCallbackFactory, operationFieldIndex, BinaryIntegerInspector.FACTORY, prevFieldPermutation, (ITuplePartitionerFactory)partitionerFactory, partitioningProperties.getComputeStorageMap());
            } else {
                op = new LSMTreeInsertDeleteOperatorDescriptor((IOperatorDescriptorRegistry)spec, inputRecordDesc, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)idfh, (ITupleFilterFactory)filterFactory, false, modificationCallbackFactory, (ITuplePartitionerFactory)partitionerFactory, partitioningProperties.getComputeStorageMap());
            }
            return new Pair((Object)op, (Object)partitioningProperties.getConstraints());
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getArrayIndexModificationRuntime(String database, DataverseName dataverseName, String datasetName, String indexName, IOperatorSchema propagatedSchema, List<LogicalVariable> primaryKeys, List<LogicalVariable> additionalNonKeyFields, RecordDescriptor inputRecordDesc, JobSpecification spec, IndexOperation indexOp, LogicalVariable operationVar, List<List<AlgebricksPipeline>> secondaryKeysPipelines) throws AlgebricksException {
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, database, dataverseName, datasetName);
        int numPrimaryKeys = primaryKeys.size();
        int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numPrimaryKeys + numFilterFields];
        int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
        int[] pkFields = new int[primaryKeys.size()];
        int i = 0;
        int j = 0;
        for (LogicalVariable varKey : primaryKeys) {
            int idx;
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            pkFields[j] = idx;
            modificationCallbackPrimaryKeyFields[j] = i++;
            ++j;
        }
        if (numFilterFields > 0) {
            int idx;
            fieldPermutation[numPrimaryKeys] = idx = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
        }
        try {
            LSMSecondaryInsertDeleteWithNestedPlanOperatorDescriptor op;
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            PartitioningProperties partitioningProperties = this.getPartitioningProperties(dataset, secondaryIndex.getIndexName());
            IModificationOperationCallbackFactory modificationCallbackFactory = dataset.getModificationCallbackFactory(this.storageComponentProvider, secondaryIndex, indexOp, modificationCallbackPrimaryKeyFields);
            IndexDataflowHelperFactory idfh = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), partitioningProperties.getSplitsProvider());
            IBinaryHashFunctionFactory[] pkHashFunFactories = dataset.getPrimaryHashFunctionFactories(this);
            FieldHashPartitionerFactory tuplePartitionerFactory = new FieldHashPartitionerFactory(pkFields, pkHashFunFactories, partitioningProperties.getNumberOfPartitions());
            if (indexOp == IndexOperation.UPSERT) {
                int operationFieldIndex = propagatedSchema.findVariable(operationVar);
                op = new LSMSecondaryUpsertWithNestedPlanOperatorDescriptor(spec, inputRecordDesc, fieldPermutation, (IIndexDataflowHelperFactory)idfh, modificationCallbackFactory, operationFieldIndex, BinaryIntegerInspector.FACTORY, secondaryKeysPipelines.get(0), secondaryKeysPipelines.get(1), (ITuplePartitionerFactory)tuplePartitionerFactory, partitioningProperties.getComputeStorageMap());
            } else {
                op = new LSMSecondaryInsertDeleteWithNestedPlanOperatorDescriptor(spec, inputRecordDesc, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)idfh, modificationCallbackFactory, secondaryKeysPipelines.get(0), (ITuplePartitionerFactory)tuplePartitionerFactory, partitioningProperties.getComputeStorageMap());
            }
            return new Pair((Object)op, (Object)partitioningProperties.getConstraints());
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getRTreeModificationRuntime(String database, DataverseName dataverseName, String datasetName, String indexName, IOperatorSchema propagatedSchema, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, AsterixTupleFilterFactory filterFactory, AsterixTupleFilterFactory prevFilterFactory, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, IndexOperation indexOp, boolean bulkload, LogicalVariable operationVar, List<LogicalVariable> prevSecondaryKeys, List<LogicalVariable> prevAdditionalFilteringKeys) throws AlgebricksException {
        LSMTreeInsertDeleteOperatorDescriptor op;
        int idx;
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, database, dataverseName, datasetName);
        String itemTypeName = dataset.getItemTypeName();
        IAType itemType = MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, dataset.getItemTypeDatabaseName(), dataset.getItemTypeDataverseName(), itemTypeName).getDatatype();
        this.validateRecordType(itemType);
        ARecordType recType = (ARecordType)itemType;
        Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName(), indexName);
        Index.ValueIndexDetails secondaryIndexDetails = (Index.ValueIndexDetails)secondaryIndex.getIndexDetails();
        List<List<String>> secondaryKeyExprs = secondaryIndexDetails.getKeyFieldNames();
        List<IAType> secondaryKeyTypes = secondaryIndexDetails.getKeyFieldTypes();
        Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(secondaryIndex, secondaryKeyTypes.get(0), secondaryKeyExprs.get(0), recType);
        IAType spatialType = (IAType)keyPairType.first;
        int dimension = NonTaggedFormatUtil.getNumDimensions((ATypeTag)spatialType.getTypeTag());
        int numSecondaryKeys = dimension * 2;
        int numPrimaryKeys = primaryKeys.size();
        int numKeys = numSecondaryKeys + numPrimaryKeys;
        int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + numFilterFields];
        int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
        int[] pkFields = new int[primaryKeys.size()];
        int i = 0;
        int j = 0;
        for (LogicalVariable logicalVariable : secondaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(logicalVariable);
            ++i;
        }
        for (LogicalVariable logicalVariable : primaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(logicalVariable);
            pkFields[j] = idx;
            modificationCallbackPrimaryKeyFields[j] = i++;
            ++j;
        }
        if (numFilterFields > 0) {
            int idx2;
            fieldPermutation[numKeys] = idx2 = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
        }
        int[] prevFieldPermutation = null;
        if (indexOp == IndexOperation.UPSERT) {
            void var40_47;
            prevFieldPermutation = new int[numKeys + numFilterFields];
            i = 0;
            for (LogicalVariable varKey : prevSecondaryKeys) {
                int idx3;
                prevFieldPermutation[i] = idx3 = propagatedSchema.findVariable(varKey);
                ++i;
            }
            boolean bl = false;
            while (var40_47 < numPrimaryKeys) {
                prevFieldPermutation[var40_47 + i] = fieldPermutation[var40_47 + i];
                ++i;
                ++var40_47;
            }
            if (numFilterFields > 0) {
                int n;
                prevFieldPermutation[numKeys] = n = propagatedSchema.findVariable(prevAdditionalFilteringKeys.get(0));
            }
        }
        PartitioningProperties partitioningProperties = this.getPartitioningProperties(dataset, secondaryIndex.getIndexName());
        IModificationOperationCallbackFactory modificationCallbackFactory = dataset.getModificationCallbackFactory(this.storageComponentProvider, secondaryIndex, indexOp, modificationCallbackPrimaryKeyFields);
        IndexDataflowHelperFactory indexDataflowHelperFactory = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), partitioningProperties.getSplitsProvider());
        IBinaryHashFunctionFactory[] pkHashFunFactories = dataset.getPrimaryHashFunctionFactories(this);
        FieldHashPartitionerFactory partitionerFactory = new FieldHashPartitionerFactory(pkFields, pkHashFunFactories, partitioningProperties.getNumberOfPartitions());
        if (bulkload) {
            long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
            op = new LSMIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, fieldPermutation, 1.0f, false, numElementsHint, false, (IIndexDataflowHelperFactory)indexDataflowHelperFactory, null, LSMIndexBulkLoadOperatorDescriptor.BulkLoadUsage.LOAD, dataset.getDatasetId(), (ITupleFilterFactory)filterFactory, (ITuplePartitionerFactory)partitionerFactory, partitioningProperties.getComputeStorageMap());
        } else if (indexOp == IndexOperation.UPSERT) {
            int operationFieldIndex = propagatedSchema.findVariable(operationVar);
            op = new LSMSecondaryUpsertOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, fieldPermutation, (IIndexDataflowHelperFactory)indexDataflowHelperFactory, (ITupleFilterFactory)filterFactory, (ITupleFilterFactory)prevFilterFactory, modificationCallbackFactory, operationFieldIndex, BinaryIntegerInspector.FACTORY, prevFieldPermutation, (ITuplePartitionerFactory)partitionerFactory, partitioningProperties.getComputeStorageMap());
        } else {
            op = new LSMTreeInsertDeleteOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)indexDataflowHelperFactory, (ITupleFilterFactory)filterFactory, false, modificationCallbackFactory, (ITuplePartitionerFactory)partitionerFactory, partitioningProperties.getComputeStorageMap());
        }
        return new Pair((Object)op, (Object)partitioningProperties.getConstraints());
    }

    /*
     * WARNING - void declaration
     */
    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getInvertedIndexModificationRuntime(String database, DataverseName dataverseName, String datasetName, String indexName, IOperatorSchema propagatedSchema, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, AsterixTupleFilterFactory filterFactory, AsterixTupleFilterFactory prevFilterFactory, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, IndexOperation indexOp, DatasetConfig.IndexType indexType, boolean bulkload, LogicalVariable operationVar, List<LogicalVariable> prevSecondaryKeys, List<LogicalVariable> prevAdditionalFilteringKeys) throws AlgebricksException {
        int idx;
        boolean isPartitioned;
        boolean bl = isPartitioned = indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
        if (primaryKeys.size() > 1) {
            throw new AlgebricksException("Cannot create inverted index on " + IdentifierUtil.dataset((IIdentifierMapper.Modifier)IIdentifierMapper.Modifier.PLURAL) + " with composite primary key.");
        }
        if (secondaryKeys.size() > 1 && !isPartitioned || secondaryKeys.size() > 2 && isPartitioned) {
            throw new AlgebricksException("Cannot create composite inverted index on multiple fields.");
        }
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, database, dataverseName, datasetName);
        int numKeys = primaryKeys.size() + secondaryKeys.size();
        int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + numFilterFields];
        int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
        int[] pkFields = new int[primaryKeys.size()];
        int i = 0;
        int j = 0;
        for (LogicalVariable logicalVariable : secondaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(logicalVariable);
            ++i;
        }
        for (LogicalVariable logicalVariable : primaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(logicalVariable);
            pkFields[j] = idx;
            modificationCallbackPrimaryKeyFields[j] = i++;
            ++j;
        }
        if (numFilterFields > 0) {
            int idx2;
            fieldPermutation[numKeys] = idx2 = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
        }
        int[] prevFieldPermutation = null;
        if (indexOp == IndexOperation.UPSERT) {
            void var30_37;
            prevFieldPermutation = new int[numKeys + numFilterFields];
            i = 0;
            for (LogicalVariable varKey : prevSecondaryKeys) {
                int idx3;
                prevFieldPermutation[i] = idx3 = propagatedSchema.findVariable(varKey);
                ++i;
            }
            boolean bl2 = false;
            while (var30_37 < primaryKeys.size()) {
                prevFieldPermutation[var30_37 + i] = fieldPermutation[var30_37 + i];
                ++i;
                ++var30_37;
            }
            if (numFilterFields > 0) {
                int n;
                prevFieldPermutation[numKeys] = n = propagatedSchema.findVariable(prevAdditionalFilteringKeys.get(0));
            }
        }
        try {
            LSMTreeInsertDeleteOperatorDescriptor op;
            Index index = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            PartitioningProperties partitioningProperties = this.getPartitioningProperties(dataset, index.getIndexName());
            IModificationOperationCallbackFactory modificationCallbackFactory = dataset.getModificationCallbackFactory(this.storageComponentProvider, index, indexOp, modificationCallbackPrimaryKeyFields);
            IndexDataflowHelperFactory indexDataFlowFactory = new IndexDataflowHelperFactory(this.storageComponentProvider.getStorageManager(), partitioningProperties.getSplitsProvider());
            IBinaryHashFunctionFactory[] pkHashFunFactories = dataset.getPrimaryHashFunctionFactories(this);
            FieldHashPartitionerFactory partitionerFactory = new FieldHashPartitionerFactory(pkFields, pkHashFunFactories, partitioningProperties.getNumberOfPartitions());
            if (bulkload) {
                long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
                op = new LSMIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, fieldPermutation, 1.0f, false, numElementsHint, false, (IIndexDataflowHelperFactory)indexDataFlowFactory, null, LSMIndexBulkLoadOperatorDescriptor.BulkLoadUsage.LOAD, dataset.getDatasetId(), (ITupleFilterFactory)filterFactory, (ITuplePartitionerFactory)partitionerFactory, partitioningProperties.getComputeStorageMap());
            } else if (indexOp == IndexOperation.UPSERT) {
                int upsertOperationFieldIndex = propagatedSchema.findVariable(operationVar);
                op = new LSMSecondaryUpsertOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, fieldPermutation, (IIndexDataflowHelperFactory)indexDataFlowFactory, (ITupleFilterFactory)filterFactory, (ITupleFilterFactory)prevFilterFactory, modificationCallbackFactory, upsertOperationFieldIndex, BinaryIntegerInspector.FACTORY, prevFieldPermutation, (ITuplePartitionerFactory)partitionerFactory, partitioningProperties.getComputeStorageMap());
            } else {
                op = new LSMTreeInsertDeleteOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)indexDataFlowFactory, (ITupleFilterFactory)filterFactory, false, modificationCallbackFactory, (ITuplePartitionerFactory)partitionerFactory, partitioningProperties.getComputeStorageMap());
            }
            return new Pair((Object)op, (Object)partitioningProperties.getConstraints());
        }
        catch (Exception exception) {
            throw new AlgebricksException((Throwable)exception);
        }
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getBinaryTokenizerRuntime(String database, DataverseName dataverseName, String datasetName, String indexName, IOperatorSchema inputSchema, IOperatorSchema propagatedSchema, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, RecordDescriptor recordDesc, JobSpecification spec, DatasetConfig.IndexType indexType) throws AlgebricksException {
        int idx;
        if (primaryKeys.size() > 1) {
            throw new AlgebricksException("Cannot tokenize composite primary key.");
        }
        if (secondaryKeys.size() > 1) {
            throw new AlgebricksException("Cannot tokenize composite secondary key fields.");
        }
        boolean isPartitioned = indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
        int numKeys = inputSchema.getSize();
        ArrayList<LogicalVariable> otherKeys = new ArrayList<LogicalVariable>();
        if (inputSchema.getSize() > 0) {
            for (int k = 0; k < inputSchema.getSize(); ++k) {
                boolean found = false;
                for (LogicalVariable varKey : primaryKeys) {
                    if (varKey.equals((Object)inputSchema.getVariable(k))) {
                        found = true;
                        break;
                    }
                    found = false;
                }
                if (!found) {
                    for (LogicalVariable varKey : secondaryKeys) {
                        if (varKey.equals((Object)inputSchema.getVariable(k))) {
                            found = true;
                            break;
                        }
                        found = false;
                    }
                }
                if (found) continue;
                otherKeys.add(inputSchema.getVariable(k));
            }
        }
        int numTokenKeyPairFields = !isPartitioned ? 1 + numKeys : 2 + numKeys;
        int[] fieldPermutation = new int[numKeys];
        int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
        int i = 0;
        int j = 0;
        for (LogicalVariable varKey : primaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            modificationCallbackPrimaryKeyFields[j] = i++;
            ++j;
        }
        for (LogicalVariable varKey : otherKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            ++i;
        }
        for (LogicalVariable varKey : secondaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            ++i;
        }
        Dataset dataset = MetadataManagerUtil.findExistingDataset(this.mdTxnCtx, database, dataverseName, datasetName);
        String itemTypeName = dataset.getItemTypeName();
        try {
            IAType itemType = MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, dataset.getItemTypeDatabaseName(), dataset.getItemTypeDataverseName(), itemTypeName).getDatatype();
            if (itemType.getTypeTag() != ATypeTag.OBJECT) {
                throw new AlgebricksException("Only record types can be tokenized.");
            }
            ARecordType recType = (ARecordType)itemType;
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            Index.TextIndexDetails secondaryIndexDetails = (Index.TextIndexDetails)secondaryIndex.getIndexDetails();
            List<List<String>> secondaryKeyExprs = secondaryIndexDetails.getKeyFieldNames();
            List<IAType> secondaryKeyTypeEntries = secondaryIndexDetails.getKeyFieldTypes();
            int numTokenFields = !isPartitioned ? secondaryKeys.size() : secondaryKeys.size() + 1;
            ITypeTraits[] tokenTypeTraits = new ITypeTraits[numTokenFields];
            ITypeTraits[] invListsTypeTraits = new ITypeTraits[primaryKeys.size()];
            Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(secondaryIndex, secondaryKeyTypeEntries.get(0), secondaryKeyExprs.get(0), recType);
            IAType secondaryKeyType = (IAType)keyPairType.first;
            List<List<String>> partitioningKeys = dataset.getPrimaryKeys();
            i = 0;
            for (List<String> partitioningKey : partitioningKeys) {
                IAType keyType = recType.getSubFieldType(partitioningKey);
                invListsTypeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
                ++i;
            }
            tokenTypeTraits[0] = NonTaggedFormatUtil.getTokenTypeTrait((IAType)secondaryKeyType);
            if (isPartitioned) {
                tokenTypeTraits[1] = ShortPointable.TYPE_TRAITS;
            }
            IBinaryTokenizerFactory tokenizerFactory = NonTaggedFormatUtil.getBinaryTokenizerFactory((ATypeTag)secondaryKeyType.getTypeTag(), (DatasetConfig.IndexType)indexType, (int)secondaryIndexDetails.getGramLength());
            IFullTextConfigEvaluatorFactory fullTextConfigEvaluatorFactory = FullTextUtil.fetchFilterAndCreateConfigEvaluator(this, secondaryIndex.getDatabaseName(), secondaryIndex.getDataverseName(), secondaryIndexDetails.getFullTextConfigName());
            PartitioningProperties partitioningProperties = this.getPartitioningProperties(dataset, secondaryIndex.getIndexName());
            ISerializerDeserializer[] tokenKeyPairFields = new ISerializerDeserializer[numTokenKeyPairFields];
            ITypeTraits[] tokenKeyPairTypeTraits = new ITypeTraits[numTokenKeyPairFields];
            ISerializerDeserializerProvider serdeProvider = this.getDataFormat().getSerdeProvider();
            for (int k = 0; k < recordDesc.getFieldCount(); ++k) {
                tokenKeyPairFields[k] = recordDesc.getFields()[k];
                tokenKeyPairTypeTraits[k] = recordDesc.getTypeTraits()[k];
            }
            int tokenOffset = recordDesc.getFieldCount();
            tokenKeyPairFields[tokenOffset] = serdeProvider.getSerializerDeserializer((Object)secondaryKeyType);
            tokenKeyPairTypeTraits[tokenOffset] = tokenTypeTraits[0];
            ++tokenOffset;
            if (isPartitioned) {
                tokenKeyPairFields[tokenOffset] = ShortSerializerDeserializer.INSTANCE;
                tokenKeyPairTypeTraits[tokenOffset] = tokenTypeTraits[1];
            }
            RecordDescriptor tokenKeyPairRecDesc = new RecordDescriptor(tokenKeyPairFields, tokenKeyPairTypeTraits);
            int docField = fieldPermutation[fieldPermutation.length - 1];
            int[] keyFields = new int[numKeys];
            for (int k = 0; k < keyFields.length; ++k) {
                keyFields[k] = k;
            }
            BinaryTokenizerOperatorDescriptor tokenizerOp = new BinaryTokenizerOperatorDescriptor((IOperatorDescriptorRegistry)spec, tokenKeyPairRecDesc, tokenizerFactory, fullTextConfigEvaluatorFactory, docField, keyFields, isPartitioned, true, false, (IMissingWriterFactory)MissingWriterFactory.INSTANCE);
            return new Pair((Object)tokenizerOp, (Object)partitioningProperties.getConstraints());
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    public AsterixTupleFilterFactory createTupleFilterFactory(IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, ILogicalExpression filterExpr, JobGenContext context) throws AlgebricksException {
        if (filterExpr == null) {
            return null;
        }
        IExpressionRuntimeProvider expressionRuntimeProvider = context.getExpressionRuntimeProvider();
        IScalarEvaluatorFactory filterEvalFactory = expressionRuntimeProvider.createEvaluatorFactory(filterExpr, typeEnv, inputSchemas, context);
        return new AsterixTupleFilterFactory(filterEvalFactory, context.getBinaryBooleanInspectorFactory());
    }

    private void validateRecordType(IAType itemType) throws AlgebricksException {
        if (itemType.getTypeTag() != ATypeTag.OBJECT) {
            throw new AlgebricksException("Only record types can be indexed.");
        }
    }

    public IStorageComponentProvider getStorageComponentProvider() {
        return this.storageComponentProvider;
    }

    public Namespace resolve(List<String> multiIdent) throws AsterixException {
        return this.namespaceResolver.resolve(multiIdent);
    }

    public PartitioningProperties getPartitioningProperties(Index idx) throws AlgebricksException {
        Dataset ds = this.findDataset(idx.getDatabaseName(), idx.getDataverseName(), idx.getDatasetName());
        return this.getPartitioningProperties(ds, idx.getIndexName());
    }

    public PartitioningProperties getPartitioningProperties(Dataset ds) throws AlgebricksException {
        return this.getPartitioningProperties(ds, ds.getDatasetName());
    }

    public PartitioningProperties getPartitioningProperties(Dataset ds, String indexName) throws AlgebricksException {
        return this.dataPartitioningProvider.getPartitioningProperties(this.mdTxnCtx, ds, indexName);
    }

    public PartitioningProperties getPartitioningProperties(Feed feed) throws AlgebricksException {
        return this.dataPartitioningProvider.getPartitioningProperties(feed);
    }

    public List<Index> getSecondaryIndexes(Dataset ds) throws AlgebricksException {
        return this.getDatasetIndexes(ds.getDatabaseName(), ds.getDataverseName(), ds.getDatasetName()).stream().filter(idx -> idx.isSecondaryIndex() && !idx.isSampleIndex()).collect(Collectors.toList());
    }

    public LockList getLocks() {
        return this.locks;
    }

    public ICcApplicationContext getApplicationContext() {
        return this.appCtx;
    }

    public ITxnIdFactory getTxnIdFactory() {
        return this.appCtx.getTxnIdFactory();
    }

    public ICompressionManager getCompressionManager() {
        return this.appCtx.getCompressionManager();
    }

    public void validateNamespaceName(Namespace namespace, SourceLocation srcLoc) throws AlgebricksException {
        this.validateDatabaseName(namespace.getDatabaseName(), srcLoc);
        this.validateDataverseName(namespace.getDataverseName(), srcLoc);
    }

    public void validateDatabaseName(String databaseName, SourceLocation srcLoc) throws AlgebricksException {
        this.validateDatabaseObjectNameImpl(databaseName, srcLoc);
        MetadataProvider.validateChars(databaseName, srcLoc);
    }

    public void validateDataverseName(DataverseName dataverseName, SourceLocation sourceLoc) throws AlgebricksException {
        List dvParts = dataverseName.getParts();
        this.validatePartsLimit(dataverseName, dvParts, sourceLoc);
        int totalLengthUTF8 = 0;
        for (String dvNamePart : dvParts) {
            this.validateDatabaseObjectNameImpl(dvNamePart, sourceLoc);
            if (totalLengthUTF8 == 0 && 94 == dvNamePart.codePointAt(0)) {
                throw new AsterixException(ErrorCode.INVALID_DATABASE_OBJECT_NAME, sourceLoc, new Serializable[]{dvNamePart});
            }
            if (this.namespaceResolver.isUsingDatabase()) {
                MetadataProvider.validateChars(dvNamePart, sourceLoc);
            }
            totalLengthUTF8 += dvNamePart.getBytes(StandardCharsets.UTF_8).length;
        }
        if (totalLengthUTF8 > 1004) {
            throw new AsterixException(ErrorCode.INVALID_DATABASE_OBJECT_NAME, sourceLoc, new Serializable[]{dataverseName.toString()});
        }
    }

    public IExternalFilterEvaluatorFactory createExternalFilterEvaluatorFactory(JobGenContext context, IVariableTypeEnvironment typeEnv, IProjectionFiltrationInfo projectionFiltrationInfo, Map<String, String> properties) throws AlgebricksException {
        return IndexUtil.createExternalFilterEvaluatorFactory(context, typeEnv, projectionFiltrationInfo, properties);
    }

    public void validateDatabaseObjectName(Namespace namespace, String objectName, SourceLocation sourceLoc) throws AlgebricksException {
        if (namespace != null) {
            this.validateNamespaceName(namespace, sourceLoc);
        }
        this.validateDatabaseObjectNameImpl(objectName, sourceLoc);
        if (this.namespaceResolver.isUsingDatabase()) {
            MetadataProvider.validateChars(objectName, sourceLoc);
        }
    }

    private void validateDatabaseObjectNameImpl(String name, SourceLocation sourceLoc) throws AlgebricksException {
        if (name == null || name.isEmpty()) {
            throw new AsterixException(ErrorCode.INVALID_DATABASE_OBJECT_NAME, sourceLoc, new Serializable[]{""});
        }
        if (Character.isWhitespace(name.codePointAt(0)) || MetadataConstants.METADATA_OBJECT_NAME_INVALID_CHARS.matcher(name).find()) {
            throw new AsterixException(ErrorCode.INVALID_DATABASE_OBJECT_NAME, sourceLoc, new Serializable[]{name});
        }
        int lengthUTF8 = name.getBytes(StandardCharsets.UTF_8).length;
        if (lengthUTF8 > 251) {
            throw new AsterixException(ErrorCode.INVALID_DATABASE_OBJECT_NAME, sourceLoc, new Serializable[]{name});
        }
    }

    private void validatePartsLimit(DataverseName dvName, List<String> parts, SourceLocation srcLoc) throws AsterixException {
        if (this.namespaceResolver.isUsingDatabase() && parts.size() != 1) {
            throw new AsterixException(ErrorCode.INVALID_DATABASE_OBJECT_NAME, srcLoc, new Serializable[]{dvName});
        }
    }

    private static void validateChars(String name, SourceLocation srcLoc) throws AsterixException {
        int codePointChar;
        int len = name.length();
        for (int off = 0; off < len; off += Character.charCount(codePointChar)) {
            codePointChar = name.codePointAt(off);
            if (!(off == 0 ? !Character.isLetter(codePointChar) : !Character.isLetterOrDigit(codePointChar) && codePointChar != 95 && codePointChar != 45)) continue;
            throw new AsterixException(ErrorCode.INVALID_DATABASE_OBJECT_NAME, srcLoc, new Serializable[]{name});
        }
    }
}

