/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.util.Arrays;
import java.util.List;
import org.apache.asterix.metadata.bootstrap.MetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public final class LibraryEntity {
    private static final LibraryEntity LIBRARY = new LibraryEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_LIBRARY, 3, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DataverseName"), List.of("Name")), 0, LibraryEntity.libraryType(), true, new int[]{0, 1}), 2, -1);
    private static final LibraryEntity DB_LIBRARY = new LibraryEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_LIBRARY, 4, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DatabaseName"), List.of("DataverseName"), List.of("Name")), 0, LibraryEntity.databaseLibraryType(), true, new int[]{0, 1, 2}), 3, 0);
    private final int payloadPosition;
    private final MetadataIndex index;
    private final int databaseNameIndex;
    private final int dataverseNameIndex;
    private final int libraryNameIndex;
    private final int timestampIndex;

    private LibraryEntity(MetadataIndex index, int payloadPosition, int startIndex) {
        this.index = index;
        this.payloadPosition = payloadPosition;
        this.databaseNameIndex = startIndex++;
        this.dataverseNameIndex = startIndex++;
        this.libraryNameIndex = startIndex++;
        this.timestampIndex = startIndex++;
    }

    public static LibraryEntity of(boolean usingDatabase) {
        return usingDatabase ? DB_LIBRARY : LIBRARY;
    }

    public MetadataIndex getIndex() {
        return this.index;
    }

    public ARecordType getRecordType() {
        return this.index.getPayloadRecordType();
    }

    public int payloadPosition() {
        return this.payloadPosition;
    }

    public int databaseNameIndex() {
        return this.databaseNameIndex;
    }

    public int dataverseNameIndex() {
        return this.dataverseNameIndex;
    }

    public int libraryNameIndex() {
        return this.libraryNameIndex;
    }

    public int timestampIndex() {
        return this.timestampIndex;
    }

    private static ARecordType libraryType() {
        return MetadataRecordTypes.createRecordType("LibraryRecordType", new String[]{"DataverseName", "Name", "Timestamp"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, true);
    }

    private static ARecordType databaseLibraryType() {
        return MetadataRecordTypes.createRecordType("LibraryRecordType", new String[]{"DatabaseName", "DataverseName", "Name", "Timestamp"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, true);
    }
}

