/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.util.Arrays;
import java.util.List;
import org.apache.asterix.metadata.bootstrap.MetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public final class FeedPolicyEntity {
    private static final FeedPolicyEntity FEED_POLICY = new FeedPolicyEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_FEED_POLICY, 3, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DataverseName"), List.of("PolicyName")), 0, FeedPolicyEntity.feedPolicyType(), true, new int[]{0, 1}), 2, -1);
    private static final FeedPolicyEntity DB_FEED_POLICY = new FeedPolicyEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_FEED_POLICY, 4, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DatabaseName"), List.of("DataverseName"), List.of("PolicyName")), 0, FeedPolicyEntity.databaseFeedPolicyType(), true, new int[]{0, 1, 2}), 3, 0);
    private final int payloadPosition;
    private final MetadataIndex index;
    private final int databaseNameIndex;
    private final int dataverseNameIndex;
    private final int policyNameIndex;
    private final int descriptionIndex;
    private final int propertiesIndex;

    private FeedPolicyEntity(MetadataIndex index, int payloadPosition, int startIndex) {
        this.index = index;
        this.payloadPosition = payloadPosition;
        this.databaseNameIndex = startIndex++;
        this.dataverseNameIndex = startIndex++;
        this.policyNameIndex = startIndex++;
        this.descriptionIndex = startIndex++;
        this.propertiesIndex = startIndex++;
    }

    public static FeedPolicyEntity of(boolean usingDatabase) {
        return usingDatabase ? DB_FEED_POLICY : FEED_POLICY;
    }

    public MetadataIndex getIndex() {
        return this.index;
    }

    public ARecordType getRecordType() {
        return this.index.getPayloadRecordType();
    }

    public int payloadPosition() {
        return this.payloadPosition;
    }

    public int databaseNameIndex() {
        return this.databaseNameIndex;
    }

    public int dataverseNameIndex() {
        return this.dataverseNameIndex;
    }

    public int policyNameIndex() {
        return this.policyNameIndex;
    }

    public int descriptionIndex() {
        return this.descriptionIndex;
    }

    public int propertiesIndex() {
        return this.propertiesIndex;
    }

    private static ARecordType feedPolicyType() {
        return MetadataRecordTypes.createRecordType("FeedPolicyRecordType", new String[]{"DataverseName", "PolicyName", "Description", "Properties"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, new AUnorderedListType((IAType)MetadataRecordTypes.POLICY_PARAMS_RECORDTYPE, null)}, true);
    }

    private static ARecordType databaseFeedPolicyType() {
        return MetadataRecordTypes.createRecordType("FeedPolicyRecordType", new String[]{"DatabaseName", "DataverseName", "PolicyName", "Description", "Properties"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, new AUnorderedListType((IAType)MetadataRecordTypes.POLICY_PARAMS_RECORDTYPE, null)}, true);
    }
}

