/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.util.List;
import org.apache.asterix.metadata.bootstrap.MetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public final class DataverseEntity {
    private static final DataverseEntity DATAVERSE = new DataverseEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_DATAVERSE, 2, new IAType[]{BuiltinType.ASTRING}, List.of(List.of("DataverseName")), 0, DataverseEntity.dataverseType(), true, new int[]{0}), 1, -1);
    private static final DataverseEntity DB_DATAVERSE = new DataverseEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_DATAVERSE, 3, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING}, List.of(List.of("DatabaseName"), List.of("DataverseName")), 0, DataverseEntity.databaseDataverseType(), true, new int[]{0, 1}), 2, 0);
    private final int payloadPosition;
    private final MetadataIndex index;
    private final int databaseNameIndex;
    private final int dataverseNameIndex;
    private final int dataFormatIndex;
    private final int timestampIndex;
    private final int pendingOpIndex;

    private DataverseEntity(MetadataIndex index, int payloadPosition, int startIndex) {
        this.index = index;
        this.payloadPosition = payloadPosition;
        this.databaseNameIndex = startIndex++;
        this.dataverseNameIndex = startIndex++;
        this.dataFormatIndex = startIndex++;
        this.timestampIndex = startIndex++;
        this.pendingOpIndex = startIndex++;
    }

    public static DataverseEntity of(boolean usingDatabase) {
        return usingDatabase ? DB_DATAVERSE : DATAVERSE;
    }

    public MetadataIndex getIndex() {
        return this.index;
    }

    public ARecordType getRecordType() {
        return this.index.getPayloadRecordType();
    }

    public int payloadPosition() {
        return this.payloadPosition;
    }

    public int databaseNameIndex() {
        return this.databaseNameIndex;
    }

    public int dataverseNameIndex() {
        return this.dataverseNameIndex;
    }

    public int dataFormatIndex() {
        return this.dataFormatIndex;
    }

    public int timestampIndex() {
        return this.timestampIndex;
    }

    public int pendingOpIndex() {
        return this.pendingOpIndex;
    }

    private static ARecordType dataverseType() {
        return MetadataRecordTypes.createRecordType("DataverseRecordType", new String[]{"DataverseName", "DataFormat", "Timestamp", "PendingOp"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.AINT32}, true);
    }

    private static ARecordType databaseDataverseType() {
        return MetadataRecordTypes.createRecordType("DataverseRecordType", new String[]{"DatabaseName", "DataverseName", "DataFormat", "Timestamp", "PendingOp"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.AINT32}, true);
    }
}

